% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolators.R
\name{cardinal_cubic_b_spline}
\alias{cardinal_cubic_b_spline}
\title{Cardinal Cubic B-Spline Interpolator}
\usage{
cardinal_cubic_b_spline(
  y,
  t0,
  h,
  left_endpoint_derivative = NULL,
  right_endpoint_derivative = NULL
)
}
\arguments{
\item{y}{Numeric vector of data points to interpolate.}

\item{t0}{Numeric scalar representing the starting point of the data.}

\item{h}{Numeric scalar representing the spacing between data points.}

\item{left_endpoint_derivative}{Optional numeric scalar for the derivative at the left endpoint.}

\item{right_endpoint_derivative}{Optional numeric scalar for the derivative at the right endpoint.}
}
\value{
An object of class \code{cardinal_cubic_b_spline} with methods:
\itemize{
\item \code{interpolate(x)}: Evaluate the spline at point \code{x}.
\item \code{prime(x)}: Evaluate the first derivative of the spline at point \code{x}.
\item \code{double_prime(x)}: Evaluate the second derivative of the spline at point \code{x}.
}
}
\description{
Constructs a cardinal cubic B-spline interpolator given data points.
}
\examples{
y <- c(1, 2, 0, 2, 1)
t0 <- 0
h <- 1
spline_obj <- cardinal_cubic_b_spline(y, t0, h)
x <- 0.5
spline_obj$interpolate(x)
spline_obj$prime(x)
spline_obj$double_prime(x)
}
