% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edge_asymmetry.R
\name{edge_asymmetry}
\alias{edge_asymmetry}
\title{Calculate an asymmetry index based on edge counts}
\usage{
edge_asymmetry(g, level = c("hemi", "vertex"), A = NULL)
}
\arguments{
\item{g}{An \code{igraph} graph object}

\item{level}{Character string indicating whether to calculate asymmetry for
each region, or the hemisphere as a whole (default: \code{'hemi'})}

\item{A}{Numeric matrix; the adjacency matrix of the input graph. Default:
\code{NULL}}
}
\value{
A data table with edge counts for both hemispheres and the asymmetry
  index; if \code{level} is \emph{vertex}, the data table will have
  \code{vcount(g)} rows.
}
\description{
Calculate an \emph{asymmetry index}, a ratio of intra-hemispheric edges in
the left to right hemisphere of a graph for brain MRI data.
}
\details{
The equation is:
\deqn{A = \frac{E_{lh} - E_{rh}}{0.5 \times (E_{lh} + E_{rh})}}
where \emph{lh} and \emph{rh} are left and right hemispheres, respectively.
The range of this measure is \eqn{[-2, 2]} (although the limits will only be
reached if all edges are in one hemisphere), with negative numbers
indicating more edges in the right hemisphere, and a value of 0 indicating
equal number of edges in each hemisphere.

The \code{level} argument specifies whether to calculate asymmetry for each
vertex, or for the whole hemisphere.
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
