% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/breathtest_parameters.R
\name{t50_maes_ghoos}
\alias{t50_maes_ghoos}
\title{Half-emptying time by Maes/Ghoos method}
\usage{
t50_maes_ghoos(cf)
}
\arguments{
\item{cf}{named vector of coefficients; only \code{k} and \code{beta} are required
note that \code{k} is measured in 1/min (e.g. 0.01/min),
usually it is quoted as 1/h (e.g. 0.6/h).}
}
\value{
Time in minutes when area under curve is 50\% of the AUC to infinity.
In the Maes/Ghoos model, this is used as a surrogate for gastric emptying 
half time \code{t50}.
}
\description{
Half-emptying time t50 as determined from the fit of a
beta exponential function. In the Maes/Ghoos model, it is defined as the time
when the area under curve (AUC) is 50\% of the AUC from 0 to infinity.

Maes B D, Ghoos Y F, Rutgeerts P J, Hiele M I, Geypens B and Vantrappen G 1994 
Dig. Dis. Sci. 39 S104-6.
}
\examples{
# Integral from 0 to infinity is 100 at dose 100 mg
integrate(exp_beta, 0, Inf, beta = 1.5, k = 0.01, m = 1, dose = 100)
t50_mg = t50_maes_ghoos(c(beta = 1.5, k = 0.01, dose = 100))
t50_mg
# Integral to half-emptying time \code{t50_maes_ghoos} is 50 
integrate(exp_beta, 0, t50_mg, beta = 1.5, k = 0.01, m = 1, dose = 100)
}
\seealso{
\code{\link{exp_beta}}, and \code{\link{t50_bluck_coward}} for an example.
}
