% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survey.R
\name{glance.svyolr}
\alias{glance.svyolr}
\title{Glance at a(n) svyolr object}
\usage{
\method{glance}{svyolr}(x, ...)
}
\arguments{
\item{x}{A \code{svyolr} object returned from \code{\link[survey:svyolr]{survey::svyolr()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Two exceptions here are:
\itemize{
\item \code{tidy()} methods will warn when supplied an \code{exponentiate} argument if
it will be ignored.
\item \code{augment()} methods will warn when supplied a \code{newdata} argument if it
will be ignored.
}}
}
\description{
Glance accepts a model object and returns a \code{\link[tibble:tibble]{tibble::tibble()}}
with exactly one row of model summaries. The summaries are typically
goodness of fit measures, p-values for hypothesis tests on residuals,
or model convergence information.

Glance never returns information from the original call to the modeling
function. This includes the name of the modeling function or any
arguments passed to the modeling function.

Glance does not calculate summary measures. Rather, it farms out these
computations to appropriate methods and gathers the results together.
Sometimes a goodness of fit measure will be undefined. In these cases
the measure will be reported as \code{NA}.

Glance returns the same number of columns regardless of whether the
model matrix is rank-deficient or not. If so, entries in columns
that no longer have a well-defined value are filled in with an \code{NA}
of the appropriate type.
}
\examples{
\dontshow{if (rlang::is_installed(c("survey", "MASS"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(broom)
library(survey)

data(api)
dclus1 <- svydesign(id = ~dnum, weights = ~pw, data = apiclus1, fpc = ~fpc)
dclus1 <- update(dclus1, mealcat = cut(meals, c(0, 25, 50, 75, 100)))

m <- svyolr(mealcat ~ avg.ed + mobility + stype, design = dclus1)

m

tidy(m, conf.int = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
\link{tidy}, \code{\link[survey:svyolr]{survey::svyolr()}}

Other ordinal tidiers: 
\code{\link{augment.clm}()},
\code{\link{augment.polr}()},
\code{\link{glance.clm}()},
\code{\link{glance.clmm}()},
\code{\link{glance.polr}()},
\code{\link{tidy.clm}()},
\code{\link{tidy.clmm}()},
\code{\link{tidy.polr}()},
\code{\link{tidy.svyolr}()}
}
\concept{ordinal tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with exactly one row and columns:
  \item{df.residual}{Residual degrees of freedom.}
  \item{edf}{The effective degrees of freedom.}
  \item{nobs}{Number of observations used.}

}
