% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR-stats_1_basic.R
\name{RESCALE}
\alias{RESCALE}
\title{Rescale a variable (e.g., from 5-point to 7-point).}
\usage{
RESCALE(var, from = range(var, na.rm = T), to)
}
\arguments{
\item{var}{Variable (numeric).}

\item{from}{Numeric vector, the range of old scale (e.g., \code{1:5}).
If not defined, it will compute the range of \code{var}.}

\item{to}{Numeric vector, the range of new scale (e.g., \code{1:7}).}
}
\value{
A vector of rescaled variable.
}
\description{
Rescale a variable (e.g., from 5-point to 7-point).
}
\examples{
d = data.table(var=rep(1:5, 2))
added(d, {
  var1 = RESCALE(var, to=1:7)
  var2 = RESCALE(var, from=1:5, to=1:7)
})
d  # var1 is equal to var2

}
