#' Mobius clust dataset with noise dimensions
#'
#' The `mobius_clust_data` dataset contains a 3-dimensional Mobius and Gaussian cluster
#' with added noise dimensions.
#' Each data point is represented by five dimensions (x1 to x5).
#'
#' @format A data frame with 500 rows and 5 columns:
#' \describe{
#'   \item{x1, x2, x3, x4, x5}{High-dimensional coordinates}
#' }
#'
#' @examples
#' # Load the mobius_clust_data dataset
#' data(mobius_clust_data)
#'
#' # Display the first few rows of the dataset
#' head(mobius_clust_data)
#'
#' @keywords datasets
#'
#' @rdname mobius_clust_data
#' @docType data
#' @usage data(mobius_clust_data)
#' @source This dataset is generated for illustrative purposes.
"mobius_clust_data"

#' UMAP embedding for mobius_clust_data dataset which with noise dimensions
#' UMAP parameters set to n-neigbors: 15 and min-dist: 0.1.
#'
#' The `mobius_clust_umap_param1` dataset contains the UMAP (Uniform Manifold
#' Approximation and Projection) embeddings of a five-dimensional mobius_clust_data.
#' Each data point is represented by two UMAP coordinates (emb1
#' and emb2).
#'
#' @format ## `mobius_clust_umap_param1`
#' A data frame with 500 rows and 2 columns:
#' \describe{
#'   \item{emb1}{Numeric, first UMAP 2D embeddings.}
#'   \item{emb2}{Numeric, second UMAP 2D embeddings.}
#' }
#' @examples
#' # Load the mobius_clust_umap_param1 dataset
#' data(mobius_clust_umap_param1)
#'
#' # Display the first few rows of the dataset
#' head(mobius_clust_umap_param1)
#'
#' @keywords datasets
#'
#' @rdname mobius_clust_umap_param1
#' @docType data
#' @usage data(mobius_clust_umap_param1)
#'
#' @source This dataset is generated for illustrative purposes.
"mobius_clust_umap_param1"


#' UMAP embedding for mobius_clust_data dataset which with noise dimensions
#' UMAP parameters set to n-neigbors: 30 and min-dist: 0.08.
#'
#' The `mobius_clust_umap_param2` dataset contains the UMAP (Uniform Manifold
#' Approximation and Projection) embeddings of a five-dimensional mobius_clust_data.
#' Each data point is represented by two UMAP coordinates (emb1
#' and emb2).
#'
#' @format ## `mobius_clust_umap_param2`
#' A data frame with 500 rows and 2 columns:
#' \describe{
#'   \item{emb1}{Numeric, first UMAP 2D embeddings.}
#'   \item{emb2}{Numeric, second UMAP 2D embeddings.}
#' }
#' @examples
#' # Load the mobius_clust_umap_param2 dataset
#' data(mobius_clust_umap_param2)
#'
#' # Display the first few rows of the dataset
#' head(mobius_clust_umap_param2)
#'
#' @keywords datasets
#'
#' @rdname mobius_clust_umap_param2
#' @docType data
#' @usage data(mobius_clust_umap_param2)
#'
#' @source This dataset is generated for illustrative purposes.
"mobius_clust_umap_param2"


#' UMAP embedding for mobius_clust_data dataset which with noise dimensions
#' UMAP parameters set to n-neigbors: 5 and min-dist: 0.9.
#'
#' The `mobius_clust_umap_param3` dataset contains the UMAP (Uniform Manifold
#' Approximation and Projection) embeddings of a five-dimensional mobius_clust_data.
#' Each data point is represented by two UMAP coordinates (emb1
#' and emb2).
#'
#' @format ## `mobius_clust_umap_param3`
#' A data frame with 500 rows and 2 columns:
#' \describe{
#'   \item{emb1}{Numeric, first UMAP 2D embeddings.}
#'   \item{emb2}{Numeric, second UMAP 2D embeddings.}
#' }
#' @examples
#' # Load the mobius_clust_umap_param3 dataset
#' data(mobius_clust_umap_param3)
#'
#' # Display the first few rows of the dataset
#' head(mobius_clust_umap_param3)
#'
#' @keywords datasets
#'
#' @rdname mobius_clust_umap_param3
#' @docType data
#' @usage data(mobius_clust_umap_param3)
#'
#' @source This dataset is generated for illustrative purposes.
"mobius_clust_umap_param3"


#' tSNE embedding for mobius_clust_data dataset which with noise dimensions
#' tSNE parameters set to perplexity: 15.
#'
#' The `mobius_clust_tsne_param1` dataset contains the tSNE (t-distributed Stochastic
#' Neighbor Embedding) embeddings of a five-dimensional mobius_clust_data.
#' Each data point is represented by two tSNE coordinates (emb1
#' and emb2).
#'
#' @format ## `mobius_clust_tsne_param1`
#' A data frame with 500 rows and 2 columns:
#' \describe{
#'   \item{emb1}{Numeric, first tSNE 2D embeddings.}
#'   \item{emb2}{Numeric, second tSNE 2D embeddings.}
#' }
#' @examples
#' # Load the mobius_clust_tsne_param1 dataset
#' data(mobius_clust_tsne_param1)
#'
#' # Display the first few rows of the dataset
#' head(mobius_clust_tsne_param1)
#'
#' @keywords datasets
#'
#' @rdname mobius_clust_tsne_param1
#' @docType data
#' @usage data(mobius_clust_tsne_param1)
#'
#' @source This dataset is generated for illustrative purposes.
"mobius_clust_tsne_param1"


#' tSNE embedding for mobius_clust_data dataset which with noise dimensions
#' tSNE parameters set to perplexity: 30.
#'
#' The `mobius_clust_tsne_param2` dataset contains the tSNE (t-distributed Stochastic
#' Neighbor Embedding) embeddings of a five-dimensional mobius_clust_data.
#' Each data point is represented by two tSNE coordinates (emb1
#' and emb2).
#'
#' @format ## `mobius_clust_tsne_param2`
#' A data frame with 500 rows and 2 columns:
#' \describe{
#'   \item{emb1}{Numeric, first tSNE 2D embeddings.}
#'   \item{emb2}{Numeric, second tSNE 2D embeddings.}
#' }
#' @examples
#' # Load the mobius_clust_tsne_param2 dataset
#' data(mobius_clust_tsne_param2)
#'
#' # Display the first few rows of the dataset
#' head(mobius_clust_tsne_param2)
#'
#' @keywords datasets
#'
#' @rdname mobius_clust_tsne_param2
#' @docType data
#' @usage data(mobius_clust_tsne_param2)
#'
#' @source This dataset is generated for illustrative purposes.
"mobius_clust_tsne_param2"


#' tSNE embedding for mobius_clust_data dataset which with noise dimensions
#' tSNE parameters set to perplexity: 5.
#'
#' The `mobius_clust_tsne_param3` dataset contains the tSNE (t-distributed Stochastic
#' Neighbor Embedding) embeddings of a five-dimensional mobius_clust_data.
#' Each data point is represented by two tSNE coordinates (emb1
#' and emb2).
#'
#' @format ## `mobius_clust_tsne_param3`
#' A data frame with 500 rows and 2 columns:
#' \describe{
#'   \item{emb1}{Numeric, first tSNE 2D embeddings.}
#'   \item{emb2}{Numeric, second tSNE 2D embeddings.}
#' }
#' @examples
#' # Load the mobius_clust_tsne_param1 dataset
#' data(mobius_clust_tsne_param3)
#'
#' # Display the first few rows of the dataset
#' head(mobius_clust_tsne_param3)
#'
#' @keywords datasets
#'
#' @rdname mobius_clust_tsne_param3
#' @docType data
#' @usage data(mobius_clust_tsne_param3)
#'
#' @source This dataset is generated for illustrative purposes.
"mobius_clust_tsne_param3"
