% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circulars.R
\name{two_circulars}
\alias{two_circulars}
\title{Generate Linked Data}
\usage{
two_circulars(n, num_noise, min_n, max_n)
}
\arguments{
\item{n}{The total number of data points to be generated. Should be a product of two.}

\item{num_noise}{The number of additional noise dimensions to be generated.}

\item{min_n}{The minimum value for the noise added to the data points.}

\item{max_n}{The maximum value for the noise added to the data points.}
}
\value{
A matrix containing the generated linked data points.
}
\description{
This function generates linked data points.
}
\examples{

# Generate linked data with noise with custom parameters
set.seed(20240412)
data <- two_circulars(n = 200, num_noise = 2, min_n = -0.05, max_n = 0.05)
}
