# scurve() works

    Code
      scurve(n = 100, num_noise = 3, min_n = -0.05, max_n = 0.05)
    Output
                    [,1]       [,2]         [,3]         [,4]          [,5]
        [1,] -0.63409382 1.98822308 -1.773256117  0.046811273 -0.0397026339
        [2,]  0.60979065 1.19084207 -0.207437470 -0.012496258  0.0290763175
        [3,] -0.77282163 1.19084792  1.634623293 -0.039036306  0.0422360181
        [4,] -0.97598814 1.11329627  0.782176312  0.012114244 -0.0214310022
        [5,]  0.60165944 1.72328295  1.798752727 -0.007777032 -0.0499433291
        [6,]  0.23391154 1.27587685 -1.972257884 -0.043311664 -0.0356851794
        [7,] -0.59213043 0.54464748 -1.805842141  0.009618158  0.0015637302
        [8,] -0.31892865 0.02749521  0.052221271  0.040446538 -0.0123396746
        [9,]  0.98304320 1.74959711 -0.816625894 -0.049745073 -0.0284339315
       [10,]  0.52746023 1.12029180 -0.150420279 -0.015265306 -0.0350829806
       [11,] -0.54575151 0.75524998  0.162052931  0.036571148 -0.0353439124
       [12,] -0.76238203 1.30264013  0.352872777  0.015919120  0.0423142502
       [13,]  0.83018106 1.13949024  1.557493862 -0.031443569 -0.0051962465
       [14,] -0.05256134 0.76038637  1.998617697  0.044940477 -0.0389469245
       [15,]  0.99044093 0.14966866 -0.862062479 -0.028938895 -0.0086575911
       [16,]  0.80008922 1.39771197 -0.400118980  0.013595432  0.0232040592
       [17,] -0.99342170 0.31691738  1.114513430  0.002368991 -0.0245691278
       [18,] -0.29058582 0.72196182  0.043151066 -0.030572272 -0.0315889175
       [19,] -0.99990729 0.91255936 -1.013616793 -0.018436977  0.0227344875
       [20,] -0.76350898 1.72522245 -1.645797206  0.045953311 -0.0366494890
       [21,]  0.97168436 1.18282396 -0.763717301  0.034806118  0.0157848667
       [22,] -0.58161788 0.24975524 -1.813462130  0.004200594  0.0070135517
       [23,] -0.08179654 1.41087269  0.003350952 -0.030929957  0.0208199039
       [24,]  0.95810815 0.80659040  1.286406640 -0.023326323 -0.0189224581
       [25,]  0.81002386 1.14849298 -0.413603085  0.038856192  0.0338216087
       [26,] -0.67371532 1.79045356 -1.738990979  0.036005257 -0.0460992394
       [27,] -0.26847269 0.71967963  0.036712704 -0.005547783  0.0447378346
       [28,]  0.81181813 0.99730093  1.583910379  0.010797826  0.0272497393
       [29,] -0.96495110 0.20814043  1.262429739  0.029635492 -0.0160971409
       [30,]  0.99615149 1.84362445 -0.912351785  0.009967849  0.0464448324
       [31,]  0.98467740 1.38412160 -0.825614148 -0.006457079  0.0179349351
       [32,]  0.15116459 0.34007230  1.988508607 -0.030954550 -0.0207382537
       [33,] -0.91400277 1.88360282  0.594292048 -0.025088984  0.0037443788
       [34,]  0.61208821 0.28147940  1.790789497  0.031934072 -0.0118583800
       [35,]  0.95132213 1.43101242 -0.691801670 -0.035403466  0.0063740385
       [36,]  0.99299450 1.46228171  1.118160592 -0.042859625 -0.0297865495
       [37,]  0.99692836 1.58093975 -0.921681082 -0.034428535 -0.0433482581
       [38,] -0.39838585 0.30680197  1.917217921  0.034162961 -0.0163532625
       [39,] -0.02975532 1.49081430 -1.999557212 -0.045406635  0.0359919606
       [40,]  0.13251027 0.12353514  1.991181633  0.012260502 -0.0370901504
       [41,] -0.65756705 0.61925959 -1.753396031  0.002252682 -0.0496382012
       [42,] -0.66178996 1.31466000  1.749689302  0.004865140  0.0114451926
       [43,]  0.06864664 0.72770988  1.997641037  0.037104514 -0.0157686300
       [44,]  0.18066782 1.42363410 -0.016455828  0.019189041 -0.0482725061
       [45,] -0.53663480 1.59305915  0.156185395  0.016947191  0.0417446218
       [46,] -0.46717887 1.77179572  0.115837174  0.023474528  0.0490760001
       [47,]  0.64598602 1.22870479  1.763349243 -0.046460505 -0.0143416769
       [48,]  0.72403491 0.21064063 -0.310236677 -0.014047195 -0.0389693632
       [49,]  0.95838467 1.75805706 -0.714520008 -0.002774406 -0.0050521928
       [50,]  0.69780794 0.82678269 -0.283715084  0.021978159 -0.0338490285
       [51,]  0.97949914 0.20433490 -0.798551679  0.001459893  0.0007207744
       [52,] -0.76712559 1.77936902 -1.641496947 -0.032680244  0.0358561296
       [53,]  0.40244559 1.21567890 -0.084556095 -0.006952650 -0.0343432767
       [54,] -0.18113170 0.54019666  1.983458848  0.049056897  0.0380912595
       [55,]  0.48699748 1.06403200 -0.126596628 -0.037429136 -0.0017651984
       [56,] -0.71736749 1.37783345 -1.696694971  0.040186682  0.0271230818
       [57,] -0.21661629 1.81234607  1.976256822  0.037823953 -0.0153674109
       [58,] -0.45758849 0.56344260 -1.889164089 -0.013801423 -0.0435791666
       [59,] -0.55047369 1.35785120 -1.834852511  0.014180800 -0.0007038843
       [60,] -0.99419990 0.16205910 -1.107547980  0.016110678 -0.0042624283
       [61,] -0.66771783 1.57904019  0.255585528  0.045699345  0.0307058573
       [62,]  0.19022187 0.63538332  1.981741126 -0.017281139 -0.0172181919
       [63,] -0.17441078 0.15865368  1.984672981 -0.022220930  0.0344564827
       [64,]  0.12352264 1.43083296  1.992341754  0.048801365 -0.0145525717
       [65,]  0.97212372 1.06575937 -0.765531495  0.007458667  0.0024064121
       [66,]  0.94858297 0.72765404 -0.683471419 -0.033425671  0.0470545179
       [67,]  0.72095834 1.25721234 -1.692978403 -0.035560294 -0.0429631366
       [68,] -0.85775561 0.18626929 -1.514057690  0.046699327  0.0314480813
       [69,]  0.84482271 1.11313583 -0.464953655  0.021227714 -0.0469257004
       [70,]  0.83675633 0.58639582  1.547575430  0.028738201  0.0067218661
       [71,] -0.99977917 0.41272092  0.978985596 -0.048813058 -0.0365070718
       [72,]  0.89762366 0.80107257 -1.440762701 -0.025414831  0.0148092618
       [73,] -0.72342249 0.56646323  0.309594394 -0.044960774 -0.0288158743
       [74,]  0.69053782 0.74656543 -1.723296291 -0.032921567 -0.0393909458
       [75,] -0.07613472 0.72417720 -1.997097540  0.004026652 -0.0436995254
       [76,] -0.61473001 1.40312127 -1.788737612  0.014284641 -0.0465217978
       [77,]  0.92609278 1.94893263 -1.377295857 -0.032963758 -0.0291392233
       [78,]  0.61462550 0.93106444  1.788819052  0.049464466  0.0114881480
       [79,] -0.22119842 1.90264380  1.975228824 -0.036069776 -0.0194828836
       [80,] -0.38332199 0.10094962  1.923614773  0.020289299 -0.0485348954
       [81,] -0.79441275 0.39771306  1.607378285  0.036633093 -0.0097199444
       [82,]  0.49691144 0.96923935  1.867801255 -0.029914531 -0.0044783109
       [83,]  0.54378297 0.37215268  1.839225885  0.035608689  0.0366461525
       [84,]  0.71724226 0.71440046 -1.696823892  0.030768446 -0.0395055116
       [85,] -0.96460709 1.68472647 -1.263691396  0.022653194 -0.0053874930
       [86,] -0.21540610 1.87538966 -1.976524558  0.014886355  0.0058034629
       [87,] -0.56843312 0.67281952 -1.822729471 -0.003475857  0.0060975001
       [88,] -0.09545236 0.56865985  1.995433999  0.021506445 -0.0234173421
       [89,]  0.56793327 0.37445470  1.823074601  0.031937469  0.0187736356
       [90,]  0.97235848 0.19040564 -0.766506968 -0.037160310 -0.0442129100
       [91,]  0.39500403 0.60406527 -1.918679388  0.049801787 -0.0419374371
       [92,]  0.24121023 1.16486948 -0.029527114  0.012772074 -0.0498900986
       [93,] -0.61685902 0.77911405  0.212926340  0.005877741  0.0109741065
       [94,] -0.36354115 0.82676218  0.068421859  0.025761254 -0.0074751925
       [95,] -0.28515728 0.24396778 -1.958480737  0.027342288 -0.0305212979
       [96,] -0.17648281 0.46467497  1.984303722 -0.035392174 -0.0172342707
       [97,]  0.93854228 0.59407428 -0.654835709  0.018060863 -0.0040695532
       [98,] -0.99476748 1.65265585  0.897835108 -0.004448415  0.0392953042
       [99,]  0.63840919 1.79659842 -1.769697155 -0.047147391  0.0337261188
      [100,]  0.48191627 0.06863880  1.876217272 -0.017987990  0.0190098491
                      [,6]
        [1,] -1.458899e-02
        [2,]  2.865623e-02
        [3,]  2.609781e-02
        [4,]  4.110739e-02
        [5,]  4.965122e-02
        [6,]  3.251858e-02
        [7,] -2.281042e-02
        [8,] -4.688578e-02
        [9,]  3.585914e-02
       [10,] -4.046627e-02
       [11,]  1.089824e-02
       [12,]  3.413554e-02
       [13,]  3.089505e-02
       [14,] -4.024651e-02
       [15,]  2.819042e-02
       [16,]  3.771454e-02
       [17,]  4.630252e-03
       [18,]  4.492376e-02
       [19,] -1.361151e-02
       [20,]  2.761497e-02
       [21,] -7.016805e-03
       [22,] -7.230506e-03
       [23,] -1.352021e-02
       [24,]  4.457019e-02
       [25,]  1.310034e-03
       [26,]  9.513795e-03
       [27,] -3.003845e-02
       [28,] -6.382821e-03
       [29,]  2.444980e-02
       [30,]  2.677100e-02
       [31,] -4.704865e-02
       [32,]  2.961780e-02
       [33,] -3.370171e-02
       [34,] -1.654683e-02
       [35,] -1.833225e-02
       [36,]  3.866709e-03
       [37,]  4.063287e-02
       [38,] -3.401228e-02
       [39,] -4.455656e-03
       [40,] -2.337754e-02
       [41,] -6.600727e-03
       [42,] -7.430371e-03
       [43,]  4.363294e-02
       [44,] -4.190935e-02
       [45,] -3.425425e-02
       [46,]  3.860183e-02
       [47,]  7.435258e-03
       [48,] -4.040416e-02
       [49,]  4.276738e-02
       [50,] -2.994692e-02
       [51,]  4.456985e-02
       [52,]  1.082111e-02
       [53,]  1.241861e-02
       [54,]  1.631652e-02
       [55,] -3.040836e-03
       [56,]  4.027878e-02
       [57,]  9.351035e-03
       [58,]  1.717753e-02
       [59,]  7.135615e-03
       [60,]  3.335375e-02
       [61,] -3.431115e-03
       [62,] -1.866506e-02
       [63,]  2.138503e-02
       [64,] -4.667769e-02
       [65,]  3.253958e-02
       [66,] -2.804652e-02
       [67,] -9.009592e-03
       [68,]  2.988130e-02
       [69,]  7.058739e-03
       [70,] -1.708714e-02
       [71,] -2.566097e-02
       [72,] -3.205063e-02
       [73,] -2.594132e-02
       [74,]  3.803132e-02
       [75,]  4.379304e-02
       [76,] -1.434154e-02
       [77,] -4.449161e-03
       [78,] -7.503827e-03
       [79,] -4.656778e-02
       [80,] -2.710841e-02
       [81,]  2.600811e-02
       [82,] -3.284313e-02
       [83,] -4.479017e-02
       [84,] -3.177405e-02
       [85,]  1.214109e-02
       [86,] -2.545728e-03
       [87,] -3.369623e-02
       [88,] -3.942831e-02
       [89,]  1.072001e-02
       [90,] -4.184796e-02
       [91,] -4.625760e-02
       [92,] -2.384936e-02
       [93,] -2.029594e-02
       [94,] -3.089043e-05
       [95,] -2.164460e-02
       [96,]  7.280862e-03
       [97,] -5.159603e-03
       [98,]  4.571919e-02
       [99,]  4.371184e-02
      [100,] -8.465952e-03

---

    Code
      scurve(n = 100, num_noise = 0)
    Output
                     [,1]       [,2]         [,3]
        [1,] -0.797656357 0.75669106  0.396887791
        [2,]  0.756737148 1.48760770 -1.653719273
        [3,] -0.052877405 0.26148660  1.998601011
        [4,]  0.808856675 1.24597999 -0.411994150
        [5,]  0.246266807 0.09145341 -1.969202074
        [6,] -0.984000867 0.78644971  0.821836329
        [7,]  0.986795681 1.74561682 -1.161970011
        [8,] -0.603565521 1.92691586  1.797313403
        [9,] -0.933721397 1.70103240  0.641999508
       [10,] -0.746580649 0.02283360 -1.665294923
       [11,]  0.786643817 0.05244561 -0.382592918
       [12,]  0.456550755 1.20881218 -1.889697369
       [13,] -0.716752706 1.91108015 -1.697327440
       [14,] -0.944383775 1.29313190  0.671154617
       [15,] -0.979674527 0.69623632  1.200593674
       [16,] -0.999075501 0.80411848  1.042990031
       [17,] -0.676589112 0.95819037  0.263639237
       [18,]  0.729374196 0.66540642  1.684114962
       [19,] -0.416910380 1.21061658  1.908947598
       [20,] -0.098616929 0.48618638  1.995125470
       [21,] -0.491371339 0.60960237  1.870950175
       [22,]  0.997481685 0.40483303 -1.070924528
       [23,] -0.469217335 0.77801292  0.116917279
       [24,]  0.331593055 1.29831038 -1.943422517
       [25,] -0.942683637 0.67622104  1.333687818
       [26,] -0.608810252 0.05267472  0.206684125
       [27,]  0.266135649 1.54901890 -0.036064413
       [28,]  0.984729539 1.08317638  1.174091170
       [29,]  0.999649091 0.32674933 -0.973510492
       [30,] -0.754057913 1.71255075 -1.656807935
       [31,] -0.941095043 1.40336721  1.338142161
       [32,] -0.413580603 1.07948379  0.089532491
       [33,] -0.999050050 1.37801312  1.043577498
       [34,]  0.587787302 1.67890744  1.809015505
       [35,]  0.190963658 0.20903147 -1.981597107
       [36,]  0.999603611 1.70315687 -1.028153509
       [37,]  0.638132612 1.23691027 -1.769926470
       [38,] -0.573049308 0.94214304  1.819520891
       [39,] -0.147808514 0.16790823  1.989015997
       [40,]  0.945814703 1.26710216 -1.324706865
       [41,] -0.975343661 0.27404650  0.779308488
       [42,] -0.838326132 0.37165490 -1.545169053
       [43,]  0.961512728 0.64502093  1.274760394
       [44,]  0.405739844 1.16241798 -0.086011390
       [45,] -0.304635148 0.68267627 -1.952469121
       [46,] -0.720009742 0.81628121  0.306036045
       [47,]  0.673271148 1.58190771 -0.260604327
       [48,] -0.289239093 0.58927817 -1.957256887
       [49,]  0.002821703 1.16127267  1.999996019
       [50,]  0.974249639 0.68932352 -1.225472040
       [51,]  0.138210437 0.47942744 -0.009597115
       [52,]  0.953804969 1.89219462 -0.699573502
       [53,]  0.175082457 0.09582141  1.984553774
       [54,]  0.781650481 0.95345629 -1.623716702
       [55,]  0.591435763 1.77075013 -1.806352118
       [56,]  0.208102311 1.14760667  1.978107064
       [57,]  0.244348928 1.44659154  1.969687373
       [58,]  0.959616606 1.12131345 -0.718688839
       [59,]  0.993111111 1.25180878  1.117176452
       [60,] -0.711179229 0.13345643  1.703010743
       [61,]  0.445313232 0.52734748 -0.104625148
       [62,] -0.564723036 1.43176200 -1.825280493
       [63,] -0.732718996 1.02468865  0.319468683
       [64,] -0.997855036 0.24265042  0.934537590
       [65,]  0.945135296 1.11978817 -1.326679157
       [66,] -0.758712884 0.06054516  0.348574824
       [67,] -0.283482236 1.92224759  1.958977488
       [68,] -0.993406177 0.98872155  1.114648014
       [69,] -0.784383779 1.76909859 -1.620275816
       [70,]  0.875190166 1.16325905 -1.483779055
       [71,] -0.587739083 0.12146691  0.190949464
       [72,]  0.843368884 0.45810918  1.537335021
       [73,] -0.323049621 1.36734316  1.946382028
       [74,] -0.425900756 0.87236253  0.095230114
       [75,]  0.882827810 1.39806176 -0.530303228
       [76,]  0.370076077 0.45384375 -1.929001452
       [77,] -0.152855724 0.15475642 -1.988248515
       [78,] -0.048025000 0.06700026  0.001153866
       [79,]  0.864349049 0.57664034 -0.497107644
       [80,]  0.104115731 1.86188323  1.994565189
       [81,] -0.161492708 1.38413546  0.013126095
       [82,] -0.462875137 1.44857961  0.113576508
       [83,]  0.778736519 0.16164526 -0.372648875
       [84,] -0.835160334 0.92651867  1.550006560
       [85,] -0.348714158 1.88869130 -1.937229127
       [86,]  0.859899805 1.37203620  1.510462854
       [87,] -0.964699766 0.56490961  0.736647837
       [88,] -0.580312044 1.43605085 -1.814394212
       [89,] -0.966946452 0.18151906  0.745020475
       [90,]  0.425973621 1.23121875 -0.095264418
       [91,] -0.952121717 0.12177382  0.694280790
       [92,]  0.235656087 0.31566295 -1.971836513
       [93,] -0.900953973 0.15583810  0.566085333
       [94,] -0.886876200 1.80442910  1.462007148
       [95,] -0.351297198 0.14068382  0.063735999
       [96,]  0.944279570 1.90480520 -1.329144489
       [97,]  0.336629286 1.50223044 -0.058362743
       [98,] -0.500463839 1.58133861  0.134242559
       [99,] -0.647713367 0.95021885  1.761884108
      [100,]  0.996713442 0.62187354 -0.918991892

# scurve_hole() works

    Code
      scurve_hole(n = 100, num_noise = 3, min_n = -0.05, max_n = 0.05)
    Output
                   [,1]       [,2]        [,3]         [,4]          [,5]
       [1,] -0.63409382 1.98822308 -1.77325612  0.046811273 -0.0058777411
       [2,]  0.60979065 1.19084207 -0.20743747 -0.012496258 -0.0257612543
       [3,] -0.77282163 1.19084792  1.63462329 -0.039036306 -0.0273422876
       [4,] -0.97598814 1.11329627  0.78217631  0.012114244  0.0353921735
       [5,]  0.60165944 1.72328295  1.79875273 -0.007777032 -0.0180608628
       [6,]  0.23391154 1.27587685 -1.97225788 -0.043311664  0.0044484145
       [7,] -0.59213043 0.54464748 -1.80584214  0.009618158  0.0471473908
       [8,] -0.31892865 0.02749521  0.05222127  0.040446538  0.0179879901
       [9,]  0.98304320 1.74959711 -0.81662589 -0.049745073 -0.0397026339
      [10,]  0.52746023 1.12029180 -0.15042028 -0.015265306  0.0290763175
      [11,] -0.54575151 0.75524998  0.16205293  0.036571148  0.0422360181
      [12,] -0.76238203 1.30264013  0.35287278  0.015919120 -0.0214310022
      [13,]  0.83018106 1.13949024  1.55749386 -0.031443569 -0.0499433291
      [14,] -0.05256134 0.76038637  1.99861770  0.044940477 -0.0356851794
      [15,]  0.99044093 0.14966866 -0.86206248 -0.028938895  0.0015637302
      [16,]  0.80008922 1.39771197 -0.40011898  0.013595432 -0.0123396746
      [17,] -0.99342170 0.31691738  1.11451343  0.002368991 -0.0284339315
      [18,] -0.99990729 0.91255936 -1.01361679 -0.030572272 -0.0350829806
      [19,] -0.76350898 1.72522245 -1.64579721 -0.018436977 -0.0353439124
      [20,]  0.97168436 1.18282396 -0.76371730  0.045953311  0.0423142502
      [21,] -0.58161788 0.24975524 -1.81346213  0.034806118 -0.0051962465
      [22,]  0.95810815 0.80659040  1.28640664  0.004200594 -0.0389469245
      [23,]  0.81002386 1.14849298 -0.41360309 -0.030929957 -0.0086575911
      [24,] -0.67371532 1.79045356 -1.73899098 -0.023326323  0.0232040592
      [25,]  0.81181813 0.99730093  1.58391038  0.038856192 -0.0245691278
      [26,] -0.96495110 0.20814043  1.26242974  0.036005257 -0.0315889175
      [27,]  0.99615149 1.84362445 -0.91235178 -0.005547783  0.0227344875
      [28,]  0.98467740 1.38412160 -0.82561415  0.010797826 -0.0366494890
      [29,]  0.15116459 0.34007230  1.98850861  0.029635492  0.0157848667
      [30,] -0.91400277 1.88360282  0.59429205  0.009967849  0.0070135517
      [31,]  0.61208821 0.28147940  1.79078950 -0.006457079  0.0208199039
      [32,]  0.95132213 1.43101242 -0.69180167 -0.030954550 -0.0189224581
      [33,]  0.99299450 1.46228171  1.11816059 -0.025088984  0.0338216087
      [34,]  0.99692836 1.58093975 -0.92168108  0.031934072 -0.0460992394
      [35,] -0.39838585 0.30680197  1.91721792 -0.035403466  0.0447378346
      [36,] -0.02975532 1.49081430 -1.99955721 -0.042859625  0.0272497393
      [37,]  0.13251027 0.12353514  1.99118163 -0.034428535 -0.0160971409
      [38,] -0.65756705 0.61925959 -1.75339603  0.034162961  0.0464448324
      [39,] -0.66178996 1.31466000  1.74968930 -0.045406635  0.0179349351
      [40,]  0.06864664 0.72770988  1.99764104  0.012260502 -0.0207382537
      [41,] -0.53663480 1.59305915  0.15618540  0.002252682  0.0037443788
      [42,] -0.46717887 1.77179572  0.11583717  0.004865140 -0.0118583800
      [43,]  0.64598602 1.22870479  1.76334924  0.037104514  0.0063740385
      [44,]  0.72403491 0.21064063 -0.31023668  0.019189041 -0.0297865495
      [45,]  0.95838467 1.75805706 -0.71452001  0.016947191 -0.0433482581
      [46,]  0.69780794 0.82678269 -0.28371508  0.023474528 -0.0163532625
      [47,]  0.97949914 0.20433490 -0.79855168 -0.046460505  0.0359919606
      [48,] -0.76712559 1.77936902 -1.64149695 -0.014047195 -0.0370901504
      [49,] -0.18113170 0.54019666  1.98345885 -0.002774406 -0.0496382012
      [50,] -0.71736749 1.37783345 -1.69669497  0.021978159  0.0114451926
      [51,] -0.21661629 1.81234607  1.97625682  0.001459893 -0.0157686300
      [52,] -0.45758849 0.56344260 -1.88916409 -0.032680244 -0.0482725061
      [53,] -0.55047369 1.35785120 -1.83485251 -0.006952650  0.0417446218
      [54,] -0.99419990 0.16205910 -1.10754798  0.049056897  0.0490760001
      [55,] -0.66771783 1.57904019  0.25558553 -0.037429136 -0.0143416769
      [56,]  0.19022187 0.63538332  1.98174113  0.040186682 -0.0389693632
      [57,] -0.17441078 0.15865368  1.98467298  0.037823953 -0.0050521928
      [58,]  0.12352264 1.43083296  1.99234175 -0.013801423 -0.0338490285
      [59,]  0.97212372 1.06575937 -0.76553149  0.014180800  0.0007207744
      [60,]  0.94858297 0.72765404 -0.68347142  0.016110678  0.0358561296
      [61,]  0.72095834 1.25721234 -1.69297840  0.045699345 -0.0343432767
      [62,] -0.85775561 0.18626929 -1.51405769 -0.017281139  0.0380912595
      [63,]  0.84482271 1.11313583 -0.46495366 -0.022220930 -0.0017651984
      [64,]  0.83675633 0.58639582  1.54757543  0.048801365  0.0271230818
      [65,] -0.99977917 0.41272092  0.97898560  0.007458667 -0.0153674109
      [66,]  0.89762366 0.80107257 -1.44076270 -0.033425671 -0.0435791666
      [67,] -0.72342249 0.56646323  0.30959439 -0.035560294 -0.0007038843
      [68,]  0.69053782 0.74656543 -1.72329629  0.046699327 -0.0042624283
      [69,] -0.07613472 0.72417720 -1.99709754  0.021227714  0.0307058573
      [70,] -0.61473001 1.40312127 -1.78873761  0.028738201 -0.0172181919
      [71,]  0.92609278 1.94893263 -1.37729586 -0.048813058  0.0344564827
      [72,]  0.61462550 0.93106444  1.78881905 -0.025414831 -0.0145525717
      [73,] -0.22119842 1.90264380  1.97522882 -0.044960774  0.0024064121
      [74,] -0.38332199 0.10094962  1.92361477 -0.032921567  0.0470545179
      [75,] -0.79441275 0.39771306  1.60737829  0.004026652 -0.0429631366
      [76,]  0.49691144 0.96923935  1.86780125  0.014284641  0.0314480813
      [77,]  0.54378297 0.37215268  1.83922588 -0.032963758 -0.0469257004
      [78,]  0.71724226 0.71440046 -1.69682389  0.049464466  0.0067218661
      [79,] -0.96460709 1.68472647 -1.26369140 -0.036069776 -0.0365070718
      [80,] -0.21540610 1.87538966 -1.97652456  0.020289299  0.0148092618
      [81,] -0.56843312 0.67281952 -1.82272947  0.036633093 -0.0288158743
      [82,] -0.09545236 0.56865985  1.99543400 -0.029914531 -0.0393909458
      [83,]  0.56793327 0.37445470  1.82307460  0.035608689 -0.0436995254
      [84,]  0.97235848 0.19040564 -0.76650697  0.030768446 -0.0465217978
      [85,]  0.39500403 0.60406527 -1.91867939  0.022653194 -0.0291392233
      [86,] -0.61685902 0.77911405  0.21292634  0.014886355  0.0114881480
      [87,] -0.28515728 0.24396778 -1.95848074 -0.003475857 -0.0194828836
      [88,] -0.17648281 0.46467497  1.98430372  0.021506445 -0.0485348954
      [89,]  0.93854228 0.59407428 -0.65483571  0.031937469 -0.0097199444
      [90,] -0.99476748 1.65265585  0.89783511 -0.037160310 -0.0044783109
      [91,]  0.63840919 1.79659842 -1.76969715  0.049801787  0.0366461525
      [92,]  0.48191627 0.06863880  1.87621727  0.012772074 -0.0395055116
                    [,6]
       [1,]  0.005387493
       [2,] -0.005803463
       [3,] -0.006097500
       [4,]  0.023417342
       [5,] -0.018773636
       [6,]  0.044212910
       [7,]  0.041937437
       [8,]  0.049890099
       [9,] -0.010974107
      [10,]  0.007475193
      [11,]  0.030521298
      [12,]  0.017234271
      [13,]  0.004069553
      [14,] -0.039295304
      [15,] -0.033726119
      [16,] -0.019009849
      [17,] -0.014588987
      [18,]  0.028656227
      [19,]  0.026097815
      [20,]  0.041107389
      [21,]  0.049651224
      [22,]  0.032518576
      [23,] -0.022810422
      [24,] -0.046885777
      [25,]  0.035859143
      [26,] -0.040466273
      [27,]  0.010898241
      [28,]  0.034135537
      [29,]  0.030895051
      [30,] -0.040246513
      [31,]  0.028190421
      [32,]  0.037714540
      [33,]  0.004630252
      [34,]  0.044923757
      [35,] -0.013611508
      [36,]  0.027614974
      [37,] -0.007016805
      [38,] -0.007230506
      [39,] -0.013520212
      [40,]  0.044570192
      [41,]  0.001310034
      [42,]  0.009513795
      [43,] -0.030038451
      [44,] -0.006382821
      [45,]  0.024449796
      [46,]  0.026771001
      [47,] -0.047048649
      [48,]  0.029617803
      [49,] -0.033701712
      [50,] -0.016546835
      [51,] -0.018332251
      [52,]  0.003866709
      [53,]  0.040632869
      [54,] -0.034012283
      [55,] -0.004455656
      [56,] -0.023377536
      [57,] -0.006600727
      [58,] -0.007430371
      [59,]  0.043632942
      [60,] -0.041909354
      [61,] -0.034254255
      [62,]  0.038601829
      [63,]  0.007435258
      [64,] -0.040404157
      [65,]  0.042767378
      [66,] -0.029946921
      [67,]  0.044569850
      [68,]  0.010821111
      [69,]  0.012418607
      [70,]  0.016316517
      [71,] -0.003040836
      [72,]  0.040278781
      [73,]  0.009351035
      [74,]  0.017177533
      [75,]  0.007135615
      [76,]  0.033353748
      [77,] -0.003431115
      [78,] -0.018665058
      [79,]  0.021385025
      [80,] -0.046677693
      [81,]  0.032539581
      [82,] -0.028046523
      [83,] -0.009009592
      [84,]  0.029881301
      [85,]  0.007058739
      [86,] -0.017087144
      [87,] -0.025660973
      [88,] -0.032050633
      [89,] -0.025941323
      [90,]  0.038031322
      [91,]  0.043793043
      [92,] -0.014341541

---

    Code
      scurve_hole(n = 100, num_noise = 0)
    Output
                    [,1]       [,2]        [,3]
       [1,]  0.407142677 1.69923132 -0.08663543
       [2,]  0.649722253 0.98980486 -0.23982831
       [3,] -0.948135114 1.22151281 -1.31786759
       [4,]  0.553603485 0.31119918 -1.83278039
       [5,] -0.636834701 0.96557945  1.77100037
       [6,]  0.046184233 0.89787855 -1.99893294
       [7,] -0.881854697 1.18942606 -1.47152125
       [8,]  0.146430533 0.54308347 -1.98922096
       [9,] -0.910408598 1.74225440  0.58628973
      [10,]  0.237633834 0.11368395 -0.02864519
      [11,] -0.034195069 0.72321874 -1.99941518
      [12,] -0.543363180 1.79804627 -1.83949774
      [13,] -0.847011024 0.72137916  0.46842468
      [14,] -0.719085254 1.09337891 -1.69492186
      [15,] -0.938439125 0.73259792 -1.34544465
      [16,]  0.779484901 1.61618407 -1.62642102
      [17,]  0.942068579 0.76191205 -1.33542032
      [18,]  0.891948964 0.92382712 -1.45213609
      [19,] -0.633605756 1.40450688  0.22634391
      [20,]  0.919709216 0.88877521  1.39260025
      [21,]  0.829465873 0.48284971  1.55855740
      [22,]  0.715889475 1.31612402 -0.30178638
      [23,] -0.797656357 0.75669106  0.39688779
      [24,]  0.756737148 1.48760770 -1.65371927
      [25,] -0.052877405 0.26148660  1.99860101
      [26,]  0.808856675 1.24597999 -0.41199415
      [27,]  0.246266807 0.09145341 -1.96920207
      [28,] -0.984000867 0.78644971  0.82183633
      [29,]  0.986795681 1.74561682 -1.16197001
      [30,] -0.603565521 1.92691586  1.79731340
      [31,] -0.933721397 1.70103240  0.64199951
      [32,] -0.746580649 0.02283360 -1.66529492
      [33,]  0.786643817 0.05244561 -0.38259292
      [34,]  0.456550755 1.20881218 -1.88969737
      [35,] -0.716752706 1.91108015 -1.69732744
      [36,] -0.944383775 1.29313190  0.67115462
      [37,] -0.979674527 0.69623632  1.20059367
      [38,] -0.999075501 0.80411848  1.04299003
      [39,] -0.676589112 0.95819037  0.26363924
      [40,]  0.729374196 0.66540642  1.68411496
      [41,] -0.416910380 1.21061658  1.90894760
      [42,] -0.098616929 0.48618638  1.99512547
      [43,] -0.491371339 0.60960237  1.87095018
      [44,]  0.997481685 0.40483303 -1.07092453
      [45,]  0.331593055 1.29831038 -1.94342252
      [46,] -0.942683637 0.67622104  1.33368782
      [47,] -0.608810252 0.05267472  0.20668413
      [48,]  0.266135649 1.54901890 -0.03606441
      [49,]  0.984729539 1.08317638  1.17409117
      [50,]  0.999649091 0.32674933 -0.97351049
      [51,] -0.754057913 1.71255075 -1.65680794
      [52,] -0.941095043 1.40336721  1.33814216
      [53,] -0.999050050 1.37801312  1.04357750
      [54,]  0.587787302 1.67890744  1.80901551
      [55,]  0.190963658 0.20903147 -1.98159711
      [56,]  0.999603611 1.70315687 -1.02815351
      [57,]  0.638132612 1.23691027 -1.76992647
      [58,] -0.573049308 0.94214304  1.81952089
      [59,] -0.147808514 0.16790823  1.98901600
      [60,]  0.945814703 1.26710216 -1.32470687
      [61,] -0.975343661 0.27404650  0.77930849
      [62,] -0.838326132 0.37165490 -1.54516905
      [63,]  0.961512728 0.64502093  1.27476039
      [64,] -0.304635148 0.68267627 -1.95246912
      [65,] -0.720009742 0.81628121  0.30603604
      [66,]  0.673271148 1.58190771 -0.26060433
      [67,] -0.289239093 0.58927817 -1.95725689
      [68,]  0.002821703 1.16127267  1.99999602
      [69,]  0.974249639 0.68932352 -1.22547204
      [70,]  0.953804969 1.89219462 -0.69957350
      [71,]  0.175082457 0.09582141  1.98455377
      [72,]  0.781650481 0.95345629 -1.62371670
      [73,]  0.591435763 1.77075013 -1.80635212
      [74,]  0.208102311 1.14760667  1.97810706
      [75,]  0.244348928 1.44659154  1.96968737
      [76,]  0.959616606 1.12131345 -0.71868884
      [77,]  0.993111111 1.25180878  1.11717645
      [78,] -0.711179229 0.13345643  1.70301074
      [79,]  0.445313232 0.52734748 -0.10462515
      [80,] -0.564723036 1.43176200 -1.82528049
      [81,] -0.732718996 1.02468865  0.31946868
      [82,] -0.997855036 0.24265042  0.93453759
      [83,]  0.945135296 1.11978817 -1.32667916
      [84,] -0.758712884 0.06054516  0.34857482
      [85,] -0.283482236 1.92224759  1.95897749
      [86,] -0.993406177 0.98872155  1.11464801
      [87,] -0.784383779 1.76909859 -1.62027582
      [88,]  0.875190166 1.16325905 -1.48377905
      [89,] -0.587739083 0.12146691  0.19094946
      [90,]  0.843368884 0.45810918  1.53733502
      [91,] -0.323049621 1.36734316  1.94638203
      [92,]  0.882827810 1.39806176 -0.53030323
      [93,]  0.370076077 0.45384375 -1.92900145

# two_scurves() works

    Code
      two_scurves(n = 200, num_noise = 2, min_n = -0.05, max_n = 0.05)
    Output
                    [,1]        [,2]          [,3]          [,4]          [,5]
        [1,] -0.63409382 0.063774541 -1.773256e+00 -1.458899e-02 -1.393803e-02
        [2,]  0.60979065 1.249925162 -2.074375e-01  2.865623e-02 -2.225547e-02
        [3,] -0.77282163 1.780726119  1.634623e+00  2.609781e-02 -2.738212e-02
        [4,] -0.97598814 0.757715126  7.821763e-01  4.110739e-02  3.073480e-02
        [5,]  0.60165944 1.155540646  1.798753e+00  4.965122e-02 -2.495993e-02
        [6,]  0.23391154 1.866233288 -1.972258e+00  3.251858e-02 -4.024293e-02
        [7,] -0.59213043 0.807636847 -1.805842e+00 -2.281042e-02  4.621974e-02
        [8,] -0.31892865 0.191069238  5.222127e-02 -4.688578e-02 -3.932236e-02
        [9,]  0.98304320 1.994901470 -8.166259e-01  3.585914e-02  2.399021e-02
       [10,]  0.52746023 1.305306111 -1.504203e-01 -4.046627e-02 -4.876298e-02
       [11,] -0.54575151 0.268577042  1.620529e-01  1.089824e-02 -5.570777e-03
       [12,] -0.76238203 0.681617608  3.528728e-01  3.413554e-02  3.719361e-02
       [13,]  0.83018106 1.628871372  1.557494e+00  3.089505e-02  4.364063e-02
       [14,] -0.05256134 0.101190451  1.998618e+00 -4.024651e-02  3.907752e-02
       [15,]  0.99044093 1.578777892 -8.620625e-01  2.819042e-02  2.274678e-02
       [16,]  0.80008922 0.728091357 -4.001190e-01  3.771454e-02 -2.764111e-02
       [17,] -0.99342170 0.952620177  1.114513e+00  4.630252e-03  4.468815e-02
       [18,] -0.29058582 1.611445446  4.315107e-02  4.492376e-02  1.634977e-03
       [19,] -0.99990729 1.368739535 -1.013617e+00 -1.361151e-02 -2.401393e-02
       [20,] -0.76350898 0.080933786 -1.645797e+00  2.761497e-02  1.812660e-02
       [21,]  0.97168436 0.303877640 -7.637173e-01 -7.016805e-03 -4.922323e-02
       [22,] -0.58161788 0.915988121 -1.813462e+00 -7.230506e-03 -3.299203e-02
       [23,] -0.08179654 1.618599133  3.350952e-03 -1.352021e-02  6.474367e-03
       [24,]  0.95810815 1.466526459  1.286407e+00  4.457019e-02  4.223610e-02
       [25,]  0.81002386 0.222876150 -4.136031e-01  1.310034e-03 -3.448482e-02
       [26,] -0.67371532 0.279894869 -1.738991e+00  9.513795e-03  3.052665e-02
       [27,] -0.26847269 1.110955666  3.671270e-02 -3.003845e-02  2.311675e-02
       [28,]  0.81181813 0.784043477  1.583910e+00 -6.382821e-03 -1.942860e-02
       [29,] -0.96495110 0.407290157  1.262430e+00  2.444980e-02 -1.718890e-04
       [30,]  0.99615149 0.800643028 -9.123518e-01  2.677100e-02  3.404807e-02
       [31,]  0.98467740 1.129141585 -8.256141e-01 -4.704865e-02 -2.371948e-02
       [32,]  0.15116459 1.619091009  1.988509e+00  2.961780e-02  4.342598e-04
       [33,] -0.91400277 1.501779689  5.942920e-01 -3.370171e-02 -4.823518e-02
       [34,]  0.61208821 0.361318561  1.790789e+00 -1.654683e-02 -1.964920e-02
       [35,]  0.95132213 1.708069316 -6.918017e-01 -1.833225e-02  1.948357e-02
       [36,]  0.99299450 1.857192501  1.118161e+00  3.866709e-03 -1.592498e-02
       [37,]  0.99692836 1.688570697 -9.216811e-01  4.063287e-02  2.456669e-02
       [38,] -0.39838585 0.316740780  1.917218e+00 -3.401228e-02 -4.787787e-02
       [39,] -0.02975532 1.908132700 -1.999557e+00 -4.455656e-03  2.193019e-03
       [40,]  0.13251027 0.754789950  1.991182e+00 -2.337754e-02  4.167884e-02
       [41,] -0.65756705 0.954946357 -1.753396e+00 -6.600727e-03 -2.316105e-02
       [42,] -0.66178996 0.902697199  1.749689e+00 -7.430371e-03 -2.623009e-02
       [43,]  0.06864664 0.257909717  1.997641e+00  4.363294e-02  3.703178e-02
       [44,]  0.18066782 0.616219185 -1.645583e-02 -4.190935e-02  3.463169e-02
       [45,] -0.53663480 0.661056175  1.561854e-01 -3.425425e-02 -4.101954e-02
       [46,] -0.46717887 0.530509430  1.158372e-01  3.860183e-02 -1.660521e-02
       [47,]  0.64598602 1.929210094  1.763349e+00  7.435258e-03  3.055208e-02
       [48,]  0.72403491 1.280943904 -3.102367e-01 -4.040416e-02  2.456755e-02
       [49,]  0.95838467 1.055488120 -7.145200e-01  4.276738e-02  3.454551e-02
       [50,]  0.69780794 0.560436827 -2.837151e-01 -2.994692e-02  3.508595e-04
       [51,]  0.97949914 0.970802149 -7.985517e-01  4.456985e-02  3.405702e-03
       [52,] -0.76712559 1.653604885 -1.641497e+00  1.082111e-02  1.186254e-03
       [53,]  0.40244559 1.139052992 -8.455610e-02  1.241861e-02  1.096035e-02
       [54,] -0.18113170 0.018862059  1.983459e+00  1.631652e-02 -2.121938e-02
       [55,]  0.48699748 1.748582728 -1.265966e-01 -3.040836e-03  2.175540e-02
       [56,] -0.71736749 0.196266359 -1.696695e+00  4.027878e-02  1.917075e-02
       [57,] -0.21661629 0.243520937  1.976257e+00  9.351035e-03 -4.423345e-02
       [58,] -0.45758849 1.276028467 -1.889164e+00  1.717753e-02  2.195092e-02
       [59,] -0.55047369 0.716383994 -1.834853e+00  7.135615e-03  4.953112e-02
       [60,] -0.99419990 0.677786445 -1.107548e+00  3.335375e-02 -1.138406e-02
       [61,] -0.66771783 0.086013095  2.555855e-01 -3.431115e-03 -1.550899e-02
       [62,]  0.19022187 1.345622776  1.981741e+00 -1.866506e-02  4.010219e-02
       [63,] -0.17441078 1.444418599  1.984673e+00  2.138503e-02 -1.634947e-02
       [64,]  0.12352264 0.023972705  1.992342e+00 -4.667769e-02  4.253979e-02
       [65,]  0.97212372 0.850826656 -7.655315e-01  3.253958e-02 -4.808981e-02
       [66,]  0.94858297 1.668513428 -6.834714e-01 -2.804652e-02 -3.081084e-02
       [67,]  0.72095834 1.711205878 -1.692978e+00 -9.009592e-03  7.190514e-03
       [68,] -0.85775561 0.066013470 -1.514058e+00  2.988130e-02 -4.127902e-02
       [69,]  0.84482271 0.575445720 -4.649537e-01  7.058739e-03  2.404599e-02
       [70,]  0.83675633 0.425235970  1.547575e+00 -1.708714e-02  1.933766e-02
       [71,] -0.99977917 1.976261157  9.789856e-01 -2.566097e-02 -4.239964e-02
       [72,]  0.89762366 1.508296627 -1.440763e+00 -3.205063e-02  1.849773e-02
       [73,] -0.72342249 1.899215475  3.095944e-01 -2.594132e-02  1.989845e-02
       [74,]  0.69053782 1.658431338 -1.723296e+00  3.803132e-02  1.169297e-02
       [75,] -0.07613472 0.919466956 -1.997098e+00  4.379304e-02 -2.322755e-02
       [76,] -0.61473001 0.714307189 -1.788738e+00 -1.434154e-02  1.927021e-02
       [77,]  0.92609278 1.659275169 -1.377296e+00 -4.449161e-03  3.201269e-02
       [78,]  0.61462550 0.010710677  1.788819e+00 -7.503827e-03  8.195556e-03
       [79,] -0.22119842 1.721395517  1.975229e+00 -4.656778e-02  3.135465e-02
       [80,] -0.38332199 0.594214020  1.923615e+00 -2.710841e-02 -2.442750e-02
       [81,] -0.79441275 0.267338136  1.607378e+00  2.600811e-02  1.517884e-02
       [82,]  0.49691144 1.598290628  1.867801e+00 -3.284313e-02  3.514090e-02
       [83,]  0.54378297 0.287826222  1.839226e+00 -4.479017e-02 -2.150824e-02
       [84,]  0.71724226 0.384631082 -1.696824e+00 -3.177405e-02 -2.728485e-03
       [85,] -0.96460709 0.546936116 -1.263691e+00  1.214109e-02 -3.871202e-02
       [86,] -0.21540610 0.702272893 -1.976525e+00 -2.545728e-03 -2.278382e-02
       [87,] -0.56843312 1.069517132 -1.822729e+00 -3.369623e-02 -2.512407e-02
       [88,] -0.09545236 0.569871100  1.995434e+00 -3.942831e-02  4.649326e-02
       [89,]  0.56793327 0.361250622  1.823075e+00  1.072001e-02 -1.995078e-02
       [90,]  0.97235848 1.743206203 -7.665070e-01 -4.184796e-02  2.565149e-02
       [91,]  0.39500403 0.003964251 -1.918679e+00 -4.625760e-02  4.058669e-02
       [92,]  0.24121023 0.744558516 -2.952711e-02 -2.384936e-02 -2.873166e-03
       [93,] -0.61685902 0.882445178  2.129263e-01 -2.029594e-02 -4.442756e-02
       [94,] -0.36354115 0.484774913  6.842186e-02 -3.089043e-05  4.911115e-02
       [95,] -0.28515728 0.453154247 -1.958481e+00 -2.164460e-02  4.165463e-02
       [96,] -0.17648281 1.707843470  1.984304e+00  7.280862e-03  3.419861e-02
       [97,]  0.93854228 0.638782745 -6.548357e-01 -5.159603e-03  8.630894e-03
       [98,] -0.99476748 1.088968290  8.978351e-01  4.571919e-02 -1.077493e-02
       [99,]  0.63840919 1.942947816 -1.769697e+00  4.371184e-02 -1.501543e-02
      [100,]  0.48191627 1.359759802  1.876217e+00 -8.465952e-03 -3.249849e-02
      [101,] -0.99846041 0.205947322 -1.055469e+00  9.797570e-03  3.576007e-02
      [102,]  0.78290531 1.581526350 -3.778591e-01 -2.422641e-02  1.850679e-02
      [103,]  0.78292246 1.844720363 -3.778807e-01  3.277202e-02 -2.710531e-02
      [104,]  0.50889106 0.571379955 -1.391691e-01 -9.997107e-03 -2.235682e-02
      [105,] -0.26364404 0.001133419 -1.964620e+00 -3.069320e-02 -3.600592e-02
      [106,]  0.96356863 0.286296412 -7.325388e-01  1.476614e-02  1.070241e-02
      [107,] -0.83919128 1.031274604  1.543836e+00 -1.839283e-02 -1.818586e-02
      [108,]  0.99161779 0.753206508  1.129206e+00  2.645821e-02 -2.815670e-02
      [109,] -0.38092869 0.431321371 -1.924604e+00  1.278195e-02  3.828808e-03
      [110,]  0.53698730 0.298340388 -1.564097e-01 -4.227686e-02  4.094278e-02
      [111,] -0.91413020 0.293121752  5.945793e-01 -9.606105e-03 -3.250933e-02
      [112,]  0.98955811 1.846285003 -8.558655e-01 -2.830282e-02  2.053256e-02
      [113,]  0.61100720 0.896075070 -2.083750e-01 -4.181241e-02  3.559308e-02
      [114,] -0.90405033 0.221061511  5.725740e-01  1.311135e-02 -4.878065e-02
      [115,]  0.76141910 0.826848178  1.648260e+00  1.880957e-02 -4.481919e-02
      [116,]  0.95433302 1.464081183 -1.298745e+00  1.712295e-02  4.397552e-02
      [117,]  0.07728123 0.508617444  1.997009e+00  7.884755e-03 -3.610309e-02
      [118,] -0.96624270 0.368221651  7.423665e-01  4.200629e-02  2.131414e-02
      [119,] -0.40049252 1.454689750  8.369997e-02  2.877043e-02 -3.636798e-03
      [120,] -0.27244919 0.267010221 -1.962170e+00  3.228527e-02 -3.402189e-02
      [121,]  0.75884487 1.315697334 -3.487286e-01  2.788319e-02 -3.049437e-02
      [122,]  0.38374880 1.140271035  1.923438e+00 -1.741983e-02  8.520503e-03
      [123,]  0.93398247 1.416398077 -1.357319e+00  5.182130e-03 -3.672661e-02
      [124,] -0.79037523 0.621550838  3.873769e-01 -2.974713e-02 -2.642170e-02
      [125,]  0.64403155 1.676432175 -2.350011e-01  2.027644e-02 -9.144743e-03
      [126,] -0.55080799 0.078015211 -1.834632e+00  6.945097e-03  5.949574e-03
      [127,] -0.96895750 1.894756693  7.527727e-01 -2.858230e-03 -2.816194e-02
      [128,] -0.01271875 1.544994786  8.088654e-05  4.814338e-02  1.726960e-03
      [129,]  0.55632584 0.678057181  1.830964e+00 -1.638557e-02 -2.569834e-02
      [130,] -0.74055366 1.928896648 -1.671997e+00 -4.239687e-02 -4.967059e-02
      [131,]  0.97149605 1.358698701 -1.237056e+00  2.032662e-02  5.135249e-03
      [132,] -0.03175129 0.585234926  1.999496e+00  4.524067e-03 -2.735784e-02
      [133,] -0.85330302 1.074887576 -1.521415e+00  1.712918e-02 -1.159155e-02
      [134,]  0.24193139 0.762832400  1.970293e+00  4.000003e-02  2.640640e-02
      [135,]  0.89591845 1.127480770 -1.444219e+00 -3.129462e-02  1.985293e-02
      [136,]  0.82098919 0.404269010 -1.570944e+00 -1.696542e-02 -2.438598e-04
      [137,]  0.39307978 0.133034837 -1.919504e+00 -2.599024e-02 -5.309682e-03
      [138,]  0.12470062 0.672934750  1.992194e+00  2.685868e-02 -3.622295e-02
      [139,]  0.73704309 1.719839212 -1.675846e+00  3.175927e-02 -1.938526e-02
      [140,]  0.83528486 0.258196992  1.549817e+00 -2.017552e-02  9.325156e-03
      [141,] -0.97514970 0.007235975  1.221547e+00  1.430562e-02 -2.487195e-02
      [142,]  0.99613085 1.228903851 -9.121175e-01 -4.388218e-02  4.730527e-02
      [143,] -0.95891056 0.684627399  7.162915e-01  4.704672e-02  2.389774e-02
      [144,]  0.91081911 0.034549879 -1.412806e+00 -4.432870e-03 -2.647772e-02
      [145,]  0.33995330 1.834892436 -1.940442e+00 -3.661782e-02 -1.890590e-02
      [146,] -0.47539149 1.981520003 -1.879774e+00  8.528756e-03 -3.497542e-02
      [147,]  0.88089315 0.713166462 -5.266848e-01 -7.837044e-03  4.571855e-02
      [148,]  0.54649709 0.220612736  1.837461e+00 -3.644674e-02  1.080535e-02
      [149,] -0.41747708 0.898956143 -1.908687e+00  3.336327e-02 -4.276782e-02
      [150,] -0.72859424 0.323019431  3.150544e-01 -1.907975e-02  1.553904e-02
      [151,]  0.57113737 1.014415488  1.820854e+00 -1.471168e-03 -1.026275e-02
      [152,] -0.50647982 1.717122592 -1.862252e+00 -1.342903e-02 -2.543897e-02
      [153,]  0.85019884 0.313134466 -4.735383e-01  3.520064e-02 -1.780995e-02
      [154,] -0.82760113 1.761825189  1.561317e+00 -2.381260e-02 -1.053365e-02
      [155,]  0.29718557 0.964696032 -4.518026e-02 -2.661871e-02 -2.969802e-02
      [156,]  0.97809302 1.542461636 -1.208168e+00  3.555762e-02 -1.318234e-02
      [157,] -0.63383238 0.692651781 -1.773470e+00  3.595247e-02 -2.211034e-02
      [158,] -0.88400645 0.128416669  1.467475e+00 -1.364102e-02 -1.949560e-02
      [159,]  0.99333294 0.985922315 -1.115281e+00  4.875386e-02  3.431024e-02
      [160,]  0.72229206 0.914751434  1.691588e+00  2.493871e-02 -3.547910e-02
      [161,]  0.40129481 1.614117147 -1.915949e+00 -4.896922e-03 -4.555309e-02
      [162,] -0.98915344 0.655636163  1.146886e+00 -3.970057e-02  4.446336e-02
      [163,]  0.73329695 1.689129653  1.679909e+00  8.724967e-03 -2.781911e-02
      [164,]  0.89629380 0.708948566 -1.443461e+00  1.597159e-02 -1.002056e-02
      [165,]  0.30494791 1.048128242 -4.763097e-02 -2.019766e-02  2.079151e-02
      [166,] -0.95898518 1.941090359  7.165438e-01  9.139048e-03  1.940213e-02
      [167,]  0.93634987 0.140737269 -6.489318e-01  3.028368e-02 -4.202857e-02
      [168,]  0.63886572 1.628961627  1.769318e+00  1.788580e-02  1.437366e-02
      [169,]  0.50824008 0.061485993 -1.387846e-01 -4.290069e-02  4.711666e-02
      [170,] -0.92930587 1.134437323  1.369311e+00 -2.202454e-02  1.110588e-03
      [171,] -0.36543977 0.269858563  1.930835e+00  6.666061e-03  3.239017e-02
      [172,] -0.80603579 1.296185236  4.081332e-01  4.398104e-02  1.339229e-02
      [173,] -0.89057089 0.423682514  1.454844e+00  2.984306e-02  4.645296e-02
      [174,] -0.92995201 0.212181083  6.323191e-01  4.668091e-03  1.192731e-02
      [175,] -0.96350046 0.126009492  7.322933e-01 -1.147877e-02  2.116185e-02
      [176,]  0.94640858 0.069564044 -1.322972e+00 -2.931105e-02  1.631644e-02
      [177,] -0.97118343 0.417215534 -1.238333e+00 -3.496157e-02  1.546603e-02
      [178,] -0.31916776 1.229762960  5.230177e-02  5.097572e-04 -6.941579e-04
      [179,] -0.89659331 0.610342328 -1.442855e+00 -1.107564e-02  2.659954e-02
      [180,]  0.88896600 0.029302091  1.457973e+00  3.444004e-02 -1.646715e-02
      [181,] -0.29874975 0.805601112  1.954331e+00  1.721028e-03  4.339491e-02
      [182,] -0.14444904 0.910433781  1.048776e-02  5.106072e-03 -2.145939e-02
      [183,] -0.18191331 1.732923050  1.983315e+00 -9.471303e-03  5.977730e-03
      [184,] -0.97480745 0.209889768  7.769519e-01  2.284583e-02 -3.318530e-02
      [185,] -0.08500213 0.892250139 -1.996381e+00 -3.711272e-02 -1.249937e-02
      [186,] -0.83248837 1.116069258 -1.554043e+00  4.431580e-02  6.530065e-03
      [187,] -0.99957968 1.121950002  9.710094e-01  1.383906e-02 -4.114174e-02
      [188,] -0.89523134 0.531653158  1.445602e+00 -3.990231e-02 -2.478450e-02
      [189,] -0.19256939 1.375472712  1.981283e+00  1.393104e-02  4.352686e-02
      [190,]  0.62374970 0.115741799  1.781624e+00 -4.668946e-03 -4.589231e-02
      [191,] -0.95680152 0.161251259  1.290742e+00  1.337010e-02  4.617009e-03
      [192,]  0.70109296 0.002198028 -2.869301e-01 -3.080920e-02  4.507646e-02
      [193,] -0.86285974 1.219482131  4.945566e-01  1.190440e-02  5.940151e-03
      [194,] -0.72866045 0.850496149  3.151249e-01  2.176235e-02 -8.188367e-03
      [195,]  0.40878766 0.389574041  1.912630e+00  3.808644e-03 -3.046013e-02
      [196,] -0.58016631 0.655314586  1.814498e+00 -2.022534e-02 -2.082963e-03
      [197,] -0.94205777 0.918608937  1.335451e+00 -3.642897e-03 -3.047816e-02
      [198,]  0.06597645 1.785906083 -1.997821e+00  5.561239e-03  4.257658e-02
      [199,] -0.57474209 1.674522376 -1.818335e+00  2.585751e-02 -1.141599e-02
      [200,]  0.94814365 1.380196982  1.317842e+00 -1.580620e-02 -2.337407e-02
      [201,]  5.63409382 1.063774541 -7.732561e-01  1.216545e-02  3.390966e-02
      [202,]  4.39020935 2.249925162  7.925625e-01 -2.438039e-02 -4.143774e-02
      [203,]  5.77282163 2.780726119  2.634623e+00  3.692567e-02 -3.741529e-02
      [204,]  5.97598814 1.757715126  1.782176e+00 -1.229900e-02  4.039443e-02
      [205,]  4.39834056 2.155540646  2.798753e+00  4.542733e-02  2.845354e-02
      [206,]  4.76608846 2.866233288 -9.722579e-01  1.067751e-02  1.434015e-02
      [207,]  5.59213043 1.807636847 -8.058421e-01 -3.728084e-02  1.508975e-02
      [208,]  5.31892865 1.191069238  1.052221e+00 -4.634579e-02 -2.946663e-02
      [209,]  4.01695680 2.994901470  1.833741e-01 -3.505162e-02 -2.687273e-02
      [210,]  4.47253977 2.305306111  8.495797e-01  4.885832e-02  2.450101e-02
      [211,]  5.54575151 1.268577042  1.162053e+00  4.737772e-02  3.236095e-02
      [212,]  5.76238203 1.681617608  1.352873e+00 -1.044061e-02 -2.834071e-02
      [213,]  4.16981894 2.628871372  2.557494e+00 -4.555401e-02  1.017609e-02
      [214,]  5.05256134 1.101190451  2.998618e+00 -1.465659e-02 -4.951010e-03
      [215,]  4.00955907 2.578777892  1.379375e-01  1.518818e-02 -9.329137e-03
      [216,]  4.19991078 1.728091357  5.998810e-01  9.794076e-03  9.235702e-03
      [217,]  5.99342170 1.952620177  2.114513e+00  2.090481e-03  1.424448e-02
      [218,]  5.29058582 2.611445446  1.043151e+00  1.672968e-02  2.765936e-02
      [219,]  5.99990729 2.368739535 -1.361679e-02 -1.053083e-02 -2.357522e-02
      [220,]  5.76350898 1.080933786 -6.457972e-01  2.569068e-02 -9.247106e-04
      [221,]  4.02831564 1.303877640  2.362827e-01  1.951988e-02  2.226533e-02
      [222,]  5.58161788 1.915988121 -8.134621e-01  2.975835e-02  1.087636e-02
      [223,]  5.08179654 2.618599133  1.003351e+00  1.109935e-02 -4.905825e-03
      [224,]  4.04189185 2.466526459  2.286407e+00 -1.491552e-02 -2.455052e-02
      [225,]  4.18997614 1.222876150  5.863969e-01  1.618895e-02 -1.645280e-03
      [226,]  5.67371532 1.279894869 -7.389910e-01  4.736626e-02 -2.338030e-02
      [227,]  5.26847269 2.110955666  1.036713e+00 -2.745094e-02 -4.603940e-02
      [228,]  4.18818187 1.784043477  2.583910e+00 -4.158819e-03  3.328674e-02
      [229,]  5.96495110 1.407290157  2.262430e+00  3.366253e-02  4.064574e-02
      [230,]  4.00384851 1.800643028  8.764822e-02 -3.562754e-02 -1.298184e-02
      [231,]  4.01532260 2.129141585  1.743859e-01 -2.016836e-02 -1.381245e-03
      [232,]  4.84883541 2.619091009  2.988509e+00 -3.974189e-03 -9.914179e-03
      [233,]  5.91400277 2.501779689  1.594292e+00 -1.890066e-02 -2.530526e-03
      [234,]  4.38791179 1.361318561  2.790789e+00 -3.394537e-02 -2.729615e-02
      [235,]  4.04867787 2.708069316  3.081983e-01  3.954843e-02  4.977361e-02
      [236,]  4.00700550 2.857192501  2.118161e+00 -3.515784e-02 -3.738483e-02
      [237,]  4.00307164 2.688570697  7.831892e-02 -1.184551e-02 -1.781895e-02
      [238,]  5.39838585 1.316740780  2.917218e+00  2.892848e-03  2.909667e-02
      [239,]  5.02975532 2.908132700 -9.995572e-01  4.160459e-02  3.765714e-02
      [240,]  4.86748973 1.754789950  2.991182e+00 -1.335511e-02 -1.222253e-02
      [241,]  5.65756705 1.954946357 -7.533960e-01  3.629767e-02 -2.075209e-02
      [242,]  5.66178996 1.902697199  2.749689e+00  3.141726e-02  4.898746e-02
      [243,]  4.93135336 1.257909717  2.997641e+00  1.774895e-02 -3.192730e-02
      [244,]  4.81933218 1.616219185  9.835442e-01 -8.120899e-03  2.347345e-02
      [245,]  5.53663480 1.661056175  1.156185e+00  1.586619e-02  3.927989e-02
      [246,]  5.46717887 1.530509430  1.115837e+00  9.185939e-03  4.121712e-02
      [247,]  4.35401398 2.929210094  2.763349e+00 -2.909539e-02 -3.928497e-02
      [248,]  4.27596509 2.280943904  6.897633e-01  2.053609e-02  3.702536e-02
      [249,]  4.04161533 2.055488120  2.854800e-01 -8.063634e-03  1.453956e-02
      [250,]  4.30219206 1.560436827  7.162849e-01  1.553382e-02  1.511670e-02
      [251,]  4.02050086 1.970802149  2.014483e-01  2.602863e-02 -2.085086e-02
      [252,]  5.76712559 2.653604885 -6.414969e-01 -4.460973e-02  2.631276e-02
      [253,]  4.59755441 2.139052992  9.154439e-01  4.520893e-02  3.924439e-02
      [254,]  5.18113170 1.018862059  2.983459e+00  2.327186e-03  3.962608e-02
      [255,]  4.51300252 2.748582728  8.734034e-01 -3.853751e-02  3.601795e-02
      [256,]  5.71736749 1.196266359 -6.966950e-01 -7.380333e-03 -2.132409e-02
      [257,]  5.21661629 1.243520937  2.976257e+00 -2.232958e-02 -4.799574e-02
      [258,]  5.45758849 2.276028467 -8.891641e-01 -6.065673e-03 -3.955065e-02
      [259,]  5.55047369 1.716383994 -8.348525e-01 -1.259044e-02 -3.353678e-02
      [260,]  5.99419990 1.677786445 -1.075480e-01  4.332718e-02  3.749058e-03
      [261,]  5.66771783 1.086013095  1.255586e+00  2.363263e-02  2.561923e-02
      [262,]  4.80977813 2.345622776  2.981741e+00 -2.158810e-02 -4.328054e-02
      [263,]  5.17441078 2.444418599  2.984673e+00 -1.234432e-03 -2.657243e-02
      [264,]  4.87647736 1.023972705  2.992342e+00  3.786748e-02 -2.482937e-03
      [265,]  4.02787628 1.850826656  2.344685e-01 -5.989409e-03  2.067488e-02
      [266,]  4.05141703 2.668513428  3.165286e-01  4.697274e-02 -2.909830e-02
      [267,]  4.27904166 2.711205878 -6.929784e-01 -4.611238e-02  5.261940e-03
      [268,]  5.85775561 1.066013470 -5.140577e-01  5.639224e-04  1.225310e-03
      [269,]  4.15517729 1.575445720  5.350463e-01 -3.845493e-02 -2.573979e-02
      [270,]  4.16324367 1.425235970  2.547575e+00 -8.162953e-03 -4.920211e-02
      [271,]  5.99977917 2.976261157  1.978986e+00  4.392665e-02  3.828112e-03
      [272,]  4.10237634 2.508296627 -4.407627e-01  2.709454e-02 -4.840133e-02
      [273,]  5.72342249 2.899215475  1.309594e+00 -1.836716e-02  1.622421e-02
      [274,]  4.30946218 2.658431338 -7.232963e-01  6.381873e-03  4.705459e-02
      [275,]  5.07613472 1.919466956 -9.970975e-01 -1.990309e-02 -5.583441e-03
      [276,]  5.61473001 1.714307189 -7.887376e-01  2.730781e-02 -1.856189e-02
      [277,]  4.07390722 2.659275169 -3.772959e-01  4.226218e-02 -3.931910e-02
      [278,]  4.38537450 1.010710677  2.788819e+00  4.664999e-02 -2.130964e-02
      [279,]  5.22119842 2.721395517  2.975229e+00  2.116798e-02  2.342741e-02
      [280,]  5.38332199 1.594214020  2.923615e+00 -4.309416e-02  2.933642e-02
      [281,]  5.79441275 1.267338136  2.607378e+00 -1.920677e-02 -2.671146e-02
      [282,]  4.50308856 2.598290628  2.867801e+00 -2.242898e-02 -2.874434e-03
      [283,]  4.45621703 1.287826222  2.839226e+00  4.191774e-02 -4.335716e-02
      [284,]  4.28275774 1.384631082 -6.968239e-01  3.674067e-03  3.560783e-02
      [285,]  5.96460709 1.546936116 -2.636914e-01 -4.443457e-02 -4.759485e-02
      [286,]  5.21540610 1.702272893 -9.765246e-01 -1.860181e-02 -2.414846e-02
      [287,]  5.56843312 2.069517132 -8.227295e-01  2.175452e-02 -3.752585e-02
      [288,]  5.09545236 1.569871100  2.995434e+00 -2.180254e-02 -4.680808e-02
      [289,]  4.43206673 1.361250622  2.823075e+00  4.092405e-02  3.778814e-02
      [290,]  4.02764152 2.743206203  2.334930e-01 -1.156094e-02  4.903727e-02
      [291,]  4.60499597 1.003964251 -9.186794e-01  4.391131e-02  1.696616e-03
      [292,]  4.75878977 1.744558516  9.704729e-01  3.421685e-02  1.757738e-02
      [293,]  5.61685902 1.882445178  1.212926e+00  4.220810e-02 -1.058579e-02
      [294,]  5.36354115 1.484774913  1.068422e+00 -4.022145e-02  3.779881e-02
      [295,]  5.28515728 1.453154247 -9.584807e-01  4.296581e-02  9.174128e-03
      [296,]  5.17648281 2.707843470  2.984304e+00 -4.524026e-02 -4.528655e-02
      [297,]  4.06145772 1.638782745  3.451643e-01 -2.511152e-02 -2.627506e-02
      [298,]  5.99476748 2.088968290  1.897835e+00 -2.906693e-02  2.480230e-02
      [299,]  4.36159081 2.942947816 -7.696972e-01  2.489058e-03  1.863678e-02
      [300,]  4.51808373 2.359759802  2.876217e+00  1.890632e-02  4.428247e-02
      [301,]  5.99846041 1.205947322 -5.546894e-02  2.927220e-02  3.309084e-02
      [302,]  4.21709469 2.581526350  6.221409e-01  4.092765e-02  6.205570e-04
      [303,]  4.21707754 2.844720363  6.221193e-01  3.048572e-02  1.274938e-02
      [304,]  4.49110894 1.571379955  8.608309e-01  3.307067e-02  2.556577e-02
      [305,]  5.26364404 1.001133419 -9.646200e-01  3.749385e-02 -2.704463e-03
      [306,]  4.03643137 1.286296412  2.674612e-01 -3.411267e-02 -1.715678e-02
      [307,]  5.83919128 2.031274604  2.543836e+00 -3.205123e-02  2.553369e-02
      [308,]  4.00838221 1.753206508  2.129206e+00  3.857820e-02 -1.342221e-02
      [309,]  5.38092869 1.431321371 -9.246044e-01 -2.676152e-02 -2.135242e-02
      [310,]  4.46301270 1.298340388  8.435903e-01  2.005807e-02 -4.435638e-02
      [311,]  5.91413020 1.293121752  1.594579e+00 -3.963579e-02 -3.480150e-02
      [312,]  4.01044189 2.846285003  1.441345e-01 -4.464460e-02  7.342764e-03
      [313,]  4.38899280 1.896075070  7.916250e-01  3.259540e-02 -7.514273e-03
      [314,]  5.90405033 1.221061511  1.572574e+00  4.315758e-02  1.997895e-02
      [315,]  4.23858090 1.826848178  2.648260e+00 -4.323491e-02  2.137183e-02
      [316,]  4.04566698 2.464081183 -2.987449e-01 -1.448548e-02 -8.705977e-03
      [317,]  4.92271877 1.508617444  2.997009e+00  2.217300e-02  1.731751e-02
      [318,]  5.96624270 1.368221651  1.742366e+00 -1.027064e-02 -4.477979e-02
      [319,]  5.40049252 2.454689750  1.083700e+00  4.496821e-02  4.190433e-02
      [320,]  5.27244919 1.267010221 -9.621702e-01  2.655916e-02  2.007988e-02
      [321,]  4.24115513 2.315697334  6.512714e-01 -8.054416e-03 -3.115944e-02
      [322,]  4.61625120 2.140271035  2.923438e+00 -4.392374e-02 -2.308626e-02
      [323,]  4.06601753 2.416398077 -3.573188e-01 -2.359525e-02  3.330740e-02
      [324,]  5.79037523 1.621550838  1.387377e+00 -1.092390e-02  4.415502e-02
      [325,]  4.35596845 2.676432175  7.649989e-01  4.630102e-02 -3.834558e-02
      [326,]  5.55080799 1.078015211 -8.346320e-01  2.662198e-02  2.309174e-02
      [327,]  5.96895750 2.894756693  1.752773e+00 -4.263518e-03 -8.338904e-03
      [328,]  5.01271875 2.544994786  1.000081e+00 -2.611584e-02  3.812055e-02
      [329,]  4.44367416 1.678057181  2.830964e+00  4.355451e-02  3.733654e-05
      [330,]  5.74055366 2.928896648 -6.719972e-01 -1.124803e-02 -4.724280e-02
      [331,]  4.02850395 2.358698701 -2.370557e-01 -2.867090e-02 -1.894036e-02
      [332,]  5.03175129 1.585234926  2.999496e+00  1.485437e-02  7.934875e-03
      [333,]  5.85330302 2.074887576 -5.214153e-01  4.124495e-02  2.471494e-02
      [334,]  4.75806861 1.762832400  2.970293e+00 -3.849647e-02 -9.015889e-03
      [335,]  4.10408155 2.127480770 -4.442186e-01 -4.035356e-02 -2.119069e-03
      [336,]  4.17901081 1.404269010 -5.709437e-01  4.438101e-02  2.862516e-02
      [337,]  4.60692022 1.133034837 -9.195044e-01  1.914029e-02 -4.937218e-02
      [338,]  4.87529938 1.672934750  2.992194e+00 -8.827151e-03  1.189991e-03
      [339,]  4.26295691 2.719839212 -6.758458e-01  6.906394e-03 -1.052345e-02
      [340,]  4.16471514 1.258196992  2.549817e+00 -2.500496e-02  1.419472e-02
      [341,]  5.97514970 1.007235975  2.221547e+00  3.486415e-02 -3.895420e-02
      [342,]  4.00386915 2.228903851  8.788249e-02  3.207366e-02  1.607776e-02
      [343,]  5.95891056 1.684627399  1.716291e+00  1.476420e-02  3.519951e-02
      [344,]  4.08918089 1.034549879 -4.128057e-01 -1.487132e-03 -4.306235e-02
      [345,]  4.66004670 2.834892436 -9.404423e-01 -3.114883e-02 -2.677924e-02
      [346,]  5.47539149 2.981520003 -8.797744e-01  3.930624e-02  3.370115e-02
      [347,]  4.11910685 1.713166462  4.733152e-01 -1.292091e-02 -7.628256e-03
      [348,]  4.45350291 1.220612736  2.837461e+00 -3.438110e-02  1.474725e-03
      [349,]  5.41747708 1.898956143 -9.086875e-01  3.673330e-02  2.119039e-02
      [350,]  5.72859424 1.323019431  1.315054e+00 -7.785790e-03  1.268381e-02
      [351,]  4.42886263 2.014415488  2.820854e+00  3.775987e-02  1.346007e-02
      [352,]  5.50647982 2.717122592 -8.622518e-01 -2.817780e-02 -1.548746e-02
      [353,]  4.14980116 1.313134466  5.264617e-01  1.064854e-02 -2.307818e-02
      [354,]  5.82760113 2.761825189  2.561317e+00  4.422468e-02  4.217972e-02
      [355,]  4.70281443 1.964696032  9.548197e-01  4.409485e-03  4.829483e-02
      [356,]  4.02190698 2.542461636 -2.081683e-01  2.765841e-02  2.072083e-02
      [357,]  5.63383238 1.692651781 -7.734704e-01  6.641598e-03  3.700059e-02
      [358,]  5.88400645 1.128416669  2.467475e+00 -2.512449e-02 -2.682958e-02
      [359,]  4.00666706 1.985922315 -1.152809e-01 -4.955630e-02  5.010260e-03
      [360,]  4.27770794 1.914751434  2.691588e+00 -3.146839e-03  2.138814e-02
      [361,]  4.59870519 2.614117147 -9.159489e-01  9.831291e-03  3.384213e-02
      [362,]  5.98915344 1.655636163  2.146886e+00 -2.714389e-02 -2.381642e-02
      [363,]  4.26670305 2.689129653  2.679909e+00 -4.002474e-02 -3.741723e-02
      [364,]  4.10370620 1.708948566 -4.434607e-01  3.417797e-02 -2.485847e-02
      [365,]  4.69505209 2.048128242  9.523690e-01  5.691283e-03 -1.459736e-03
      [366,]  5.95898518 2.941090359  1.716544e+00  2.159807e-02 -4.685443e-03
      [367,]  4.06365013 1.140737269  3.510682e-01 -8.071225e-03 -4.021027e-02
      [368,]  4.36113428 2.628961627  2.769318e+00  4.391317e-03  4.312391e-02
      [369,]  4.49175992 1.061485993  8.612154e-01 -4.771512e-03  1.495112e-02
      [370,]  5.92930587 2.134437323  2.369311e+00  1.587071e-02 -1.122955e-02
      [371,]  5.36543977 1.269858563  2.930835e+00  3.635973e-02  4.721409e-02
      [372,]  5.80603579 2.296185236  1.408133e+00 -1.133370e-02 -4.704446e-02
      [373,]  5.89057089 1.423682514  2.454844e+00  2.288790e-02  6.842718e-03
      [374,]  5.92995201 1.212181083  1.632319e+00 -6.661088e-03  1.286648e-02
      [375,]  5.96350046 1.126009492  1.732293e+00 -3.594665e-02 -3.359787e-02
      [376,]  4.05359142 1.069564044 -3.229718e-01 -3.459761e-02 -4.484048e-02
      [377,]  5.97118343 1.417215534 -2.383333e-01 -5.795360e-03 -4.241089e-02
      [378,]  5.31916776 2.229762960  1.052302e+00  1.656536e-02 -3.371412e-02
      [379,]  5.89659331 1.610342328 -4.428549e-01  1.015206e-02 -1.659019e-02
      [380,]  4.11103400 1.029302091  2.457973e+00 -4.870286e-02 -2.000044e-02
      [381,]  5.29874975 1.805601112  2.954331e+00 -1.152507e-02  1.690339e-02
      [382,]  5.14444904 1.910433781  1.010488e+00 -4.444306e-02 -9.961860e-03
      [383,]  5.18191331 2.732923050  2.983315e+00 -8.271111e-03 -2.888342e-02
      [384,]  5.97480745 1.209889768  1.776952e+00  3.604335e-02 -2.930204e-02
      [385,]  5.08500213 1.892250139 -9.963808e-01  4.192450e-02 -4.338725e-02
      [386,]  5.83248837 2.116069258 -5.540425e-01  3.463579e-02  1.025363e-03
      [387,]  5.99957968 2.121950002  1.971009e+00  5.629439e-03  6.947431e-03
      [388,]  5.89523134 1.531653158  2.445602e+00  3.736544e-03 -3.107307e-02
      [389,]  5.19256939 2.375472712  2.981283e+00  1.467698e-02 -2.983059e-02
      [390,]  4.37625030 1.115741799  2.781624e+00  2.188860e-03 -3.587464e-03
      [391,]  5.95680152 1.161251259  2.290742e+00  2.250117e-03  3.662836e-02
      [392,]  4.29890704 1.002198028  7.130699e-01 -8.365604e-03 -2.557130e-02
      [393,]  5.86285974 2.219482131  1.494557e+00 -2.348013e-02 -4.820601e-02
      [394,]  5.72866045 1.850496149  1.315125e+00 -1.505425e-02 -4.970583e-02
      [395,]  4.59121234 1.389574041  2.912630e+00 -1.848556e-02  1.212139e-02
      [396,]  5.58016631 1.655314586  2.814498e+00  3.956056e-02  3.294325e-02
      [397,]  5.94205777 1.918608937  2.335451e+00 -3.476416e-02  1.258265e-02
      [398,]  4.93402355 2.785906083 -9.978212e-01  4.016556e-02 -1.569915e-04
      [399,]  5.57474209 2.674522376 -8.183346e-01 -3.392490e-02 -1.541384e-02
      [400,]  4.05185635 2.380196982  2.317842e+00  9.393090e-03  3.356151e-02

---

    Code
      two_scurves(n = 200, num_noise = 0)
    Output
                    [,1]        [,2]          [,3]
        [1,] -0.60305328 1.513970708  2.022991e-01
        [2,]  0.62713926 1.208574185 -1.778907e+00
        [3,]  0.81572976 1.887608428 -1.578433e+00
        [4,]  0.69697108 1.150619867  1.717099e+00
        [5,]  0.60261467 1.573963160 -2.019677e-01
        [6,] -0.44507101 0.979716226 -1.895495e+00
        [7,]  0.57640467 1.163536638 -1.817164e+00
        [8,]  0.17201300 1.938378378  1.985095e+00
        [9,]  0.38343120 1.020099449 -7.643056e-02
       [10,]  0.93752770 0.848186683  1.347911e+00
       [11,]  0.13160633 0.764158309 -1.991302e+00
       [12,] -0.99995713 0.376332991  1.009260e+00
       [13,] -0.18142756 0.008816799 -1.983404e+00
       [14,]  0.22952990 1.394612064 -1.973302e+00
       [15,]  0.84604713 0.784938101 -4.668919e-01
       [16,]  0.09747179 1.720718462 -1.995238e+00
       [17,] -0.90832309 1.718485748 -1.418269e+00
       [18,]  0.99994845 1.541052536 -9.898467e-01
       [19,]  0.16397421 0.056478953 -1.353537e-02
       [20,] -0.03664860 1.770926193  1.999328e+00
       [21,] -0.91647434 0.030757740 -1.400093e+00
       [22,]  0.32704897 0.182344446 -5.499261e-02
       [23,]  0.99658336 1.249083577 -9.174070e-01
       [24,] -0.78020526 0.386190894 -1.625524e+00
       [25,]  0.99330832 1.363312311  1.115493e+00
       [26,] -0.90521699 0.869135932  5.750503e-01
       [27,]  0.38519775 1.522131730 -1.922834e+00
       [28,] -0.91432722 1.713665196  5.950238e-01
       [29,]  0.99716079 1.405067837 -1.075302e+00
       [30,] -0.98707083 1.099669202  8.397153e-01
       [31,]  0.14130261 1.195785810 -1.989966e+00
       [32,]  0.01023024 1.506601181 -5.233028e-05
       [33,]  0.03108031 1.842954344 -1.999517e+00
       [34,]  0.20577602 0.732664418  1.978599e+00
       [35,]  0.22019148 1.188861799 -2.454333e-02
       [36,] -0.71940437 0.263696851  1.694592e+00
       [37,] -0.86615948 1.908860170 -1.499768e+00
       [38,] -0.04845746 0.062536585 -1.998825e+00
       [39,] -0.57631837 1.731913370 -1.817225e+00
       [40,]  0.86847313 0.184721717 -1.495736e+00
       [41,]  0.77004904 0.617012171 -1.637985e+00
       [42,]  0.33343090 1.149262027 -5.722546e-02
       [43,] -0.23629005 0.449465975  1.971683e+00
       [44,] -0.68220152 0.299356702  1.731164e+00
       [45,] -0.95498891 1.841817780  7.033585e-01
       [46,]  0.62106425 1.637170752  1.783760e+00
       [47,] -0.53279458 1.712715269  1.537554e-01
       [48,] -0.82867550 0.789636117 -1.559729e+00
       [49,] -0.18325302 0.212106486 -1.983066e+00
       [50,]  0.56241226 0.026690016  1.826857e+00
       [51,] -0.93469137 1.317467782  6.445397e-01
       [52,] -0.56261008 1.679368130  1.732776e-01
       [53,] -0.90383590 1.103674038  1.427879e+00
       [54,]  0.98290804 0.882114554 -1.184097e+00
       [55,]  0.74097758 1.408018451 -1.671530e+00
       [56,]  0.36943535 1.605804428  1.929256e+00
       [57,]  0.39760496 1.505051773 -8.244330e-02
       [58,] -0.77938044 0.238144463 -1.626551e+00
       [59,] -0.04941023 0.655557580  1.221431e-03
       [60,]  0.96979772 1.105913892 -1.243911e+00
       [61,]  0.21947737 0.349411472  1.975618e+00
       [62,] -0.86433001 0.223799259  1.502925e+00
       [63,] -0.57427022 1.686432461 -1.818666e+00
       [64,] -0.70959729 0.933845343 -1.704607e+00
       [65,] -0.35216428 1.772948366 -1.935938e+00
       [66,]  0.74178596 0.412970412  1.670637e+00
       [67,]  0.23517040 1.674829439 -2.804584e-02
       [68,]  0.30217205 0.108269950  1.953253e+00
       [69,] -0.35341923 0.784442851 -1.935465e+00
       [70,] -0.10836475 0.488445224  1.994111e+00
       [71,]  0.52185667 0.133368262 -1.853033e+00
       [72,] -0.99947468 1.400219185  1.032409e+00
       [73,]  0.25588755 1.141751539 -1.966707e+00
       [74,]  0.67888226 0.215630172 -1.734247e+00
       [75,] -0.60449802 0.661634644  1.796607e+00
       [76,]  0.35024395 1.526160114 -6.334149e-02
       [77,] -0.85701717 0.181376279  1.515288e+00
       [78,] -0.05408968 1.913479391  1.998536e+00
       [79,] -0.82539243 1.473665772  4.354406e-01
       [80,] -0.44085460 1.561290836  1.897579e+00
       [81,] -0.98380388 1.442687864 -1.179248e+00
       [82,]  0.22579555 0.916289135 -1.974175e+00
       [83,] -0.49866929 0.268285465  1.866792e+00
       [84,] -0.99842240 0.124680266  9.438511e-01
       [85,]  0.04188207 0.643452152 -8.774390e-04
       [86,]  0.48316765 1.817222137 -1.244721e-01
       [87,] -0.17354247 0.139966871  1.984826e+00
       [88,] -0.99983718 0.445710137  1.018044e+00
       [89,]  0.11385478 1.089697591 -6.502597e-03
       [90,] -0.99007755 1.026490032 -1.140522e+00
       [91,] -0.28553145 1.631998343 -1.958369e+00
       [92,]  0.87124357 0.449838156  1.490851e+00
       [93,] -0.55314547 0.090281535  1.669153e-01
       [94,] -0.37644329 0.843740203  7.356034e-02
       [95,] -0.57615891 1.378183716  1.826623e-01
       [96,] -0.25516330 1.667676521 -1.966898e+00
       [97,]  0.25954042 1.287141010  1.965732e+00
       [98,] -0.71421084 0.038504738 -1.699931e+00
       [99,]  0.32728025 0.823097409  1.944927e+00
      [100,] -0.22771033 1.176628315  1.973729e+00
      [101,]  0.98892558 0.087169163  1.148412e+00
      [102,]  0.13740612 0.268383017  1.990515e+00
      [103,] -0.66825185 1.178429219  2.560649e-01
      [104,]  0.71766781 0.329731511 -3.036144e-01
      [105,]  0.82743573 0.585485986  1.561560e+00
      [106,]  0.99801775 0.839144383 -1.062933e+00
      [107,] -0.92604068 1.833204129  1.377424e+00
      [108,] -0.14846675 1.498886698  1.108260e-02
      [109,]  0.65288376 0.089276489 -1.757458e+00
      [110,]  0.70168368 1.343095946  1.712489e+00
      [111,]  0.08841382 0.652325992 -1.996084e+00
      [112,] -0.33027119 1.672562846  5.611391e-02
      [113,]  0.47767040 0.139355525 -1.878539e+00
      [114,] -0.99957246 1.670055923  9.707613e-01
      [115,]  0.98090969 0.612632196 -8.055362e-01
      [116,] -0.97664288 0.611149286  1.214869e+00
      [117,]  0.68846276 0.618184003 -2.747283e-01
      [118,] -0.72495225 1.608546997 -1.688799e+00
      [119,]  0.77373903 1.768485096 -3.664955e-01
      [120,]  0.63885304 0.306805071 -2.306712e-01
      [121,] -0.62469761 1.087080927 -1.780867e+00
      [122,]  0.98549035 1.202922498 -8.302686e-01
      [123,] -0.82499731 0.215397033  1.565137e+00
      [124,] -0.96251995 0.964632392  1.271211e+00
      [125,]  0.74637783 0.911959185 -1.665522e+00
      [126,] -0.90787197 1.772126134  5.807525e-01
      [127,]  0.98724005 1.552860437 -8.407609e-01
      [128,]  0.20904880 1.463593576 -2.209479e-02
      [129,] -0.45119120 1.798002221  1.892427e+00
      [130,]  0.99372365 0.495635085  1.111863e+00
      [131,] -0.99813759 0.456622513 -1.061003e+00
      [132,]  0.97179822 0.188263731 -7.641861e-01
      [133,]  0.62545089 0.076697989 -2.197365e-01
      [134,] -0.27241987 0.520627713  1.962178e+00
      [135,] -0.12406825 0.431289490  1.992274e+00
      [136,]  0.66333124 0.135526460  1.748326e+00
      [137,] -0.59629006 0.983110494 -1.802769e+00
      [138,]  0.35260568 0.137395004 -6.422800e-02
      [139,] -0.98619576 0.729723424  8.344164e-01
      [140,]  0.99828244 0.519298313  1.058585e+00
      [141,]  0.33054103 0.475570150 -1.943792e+00
      [142,]  0.99403745 1.507568763  1.109039e+00
      [143,] -0.98362232 0.196633140  1.180242e+00
      [144,]  0.73760225 1.296403734 -3.247645e-01
      [145,]  0.12588889 1.291397314 -7.955653e-03
      [146,]  0.99573088 0.144485847 -1.092304e+00
      [147,]  0.25192547 0.410391557 -3.225336e-02
      [148,]  0.65465440 0.786490273  1.755928e+00
      [149,] -0.56613089 1.902732538  1.756846e-01
      [150,]  0.32620909 0.092574335  1.945298e+00
      [151,] -0.15933069 1.756885453 -1.987225e+00
      [152,] -0.70005081 0.324280748  2.859070e-01
      [153,] -0.80062016 1.834545954 -1.599172e+00
      [154,]  0.77184509 0.254943973  1.635811e+00
      [155,] -0.19859573 1.592531102 -1.980081e+00
      [156,] -0.82182138 0.042343645  1.569745e+00
      [157,]  0.04124236 0.190437324  1.999149e+00
      [158,]  0.35056544 1.414165185  1.936538e+00
      [159,] -0.70438416 0.806571780  1.709819e+00
      [160,] -0.87533129 1.008542863  1.483524e+00
      [161,]  0.65454671 0.170386605 -1.756022e+00
      [162,] -0.66704900 1.052196551 -1.745014e+00
      [163,] -0.99432448 1.240900111 -1.106390e+00
      [164,] -0.92847813 1.303706737  1.371387e+00
      [165,]  0.72078240 1.809160742 -1.693161e+00
      [166,] -0.38588962 0.187053455 -1.922545e+00
      [167,]  0.87965480 0.091577793  1.475613e+00
      [168,]  0.98589157 1.465671603  1.167385e+00
      [169,]  0.42507133 0.679776855  1.905160e+00
      [170,] -0.73021788 0.807740299  1.683214e+00
      [171,] -0.71074044 1.672903239  2.965456e-01
      [172,] -0.59182234 1.735012847  1.806068e+00
      [173,]  0.99279809 1.999640650 -1.119800e+00
      [174,] -0.49866305 1.900491086 -1.866796e+00
      [175,]  0.83135091 0.348129116  1.555748e+00
      [176,] -0.57784659 0.715315748  1.816145e+00
      [177,]  0.36799582 1.837193044  1.929827e+00
      [178,]  0.93986521 1.547892871 -6.584544e-01
      [179,]  0.41612813 0.418081269  1.909306e+00
      [180,]  0.99371155 1.881522425 -8.880297e-01
      [181,] -0.95980979 1.504400608 -1.280651e+00
      [182,] -0.47316161 0.935968087 -1.880976e+00
      [183,] -0.73481232 1.668815269  3.217295e-01
      [184,] -0.43057850 1.201894378  1.902553e+00
      [185,]  0.44758598 0.389511471 -1.894241e+00
      [186,]  0.48474422 1.232119335 -1.253440e-01
      [187,] -0.09996510 0.241577500  1.994991e+00
      [188,]  0.19606677 1.631623207  1.980591e+00
      [189,] -0.32741044 0.999971105  5.511778e-02
      [190,] -0.96831227 0.043859514  7.502574e-01
      [191,]  0.25608442 1.357312052  1.966654e+00
      [192,]  0.44869639 0.834209821 -1.063157e-01
      [193,] -0.99517106 1.082844731 -1.098156e+00
      [194,]  0.33642894 1.575607107  1.941709e+00
      [195,]  0.57617845 1.935622364 -1.817324e+00
      [196,] -0.43252777 1.144975617 -1.901621e+00
      [197,] -0.66345348 1.477405285  2.517825e-01
      [198,] -0.82425071 1.557662486  1.566225e+00
      [199,]  0.79034955 0.528842322  1.612656e+00
      [200,] -0.98943256 0.818520688 -1.144994e+00
      [201,]  5.60305328 2.513970708  1.202299e+00
      [202,]  4.37286074 2.208574185 -7.789072e-01
      [203,]  4.18427024 2.887608428 -5.784332e-01
      [204,]  4.30302892 2.150619867  2.717099e+00
      [205,]  4.39738533 2.573963160  7.980323e-01
      [206,]  5.44507101 1.979716226 -8.954953e-01
      [207,]  4.42359533 2.163536638 -8.171644e-01
      [208,]  4.82798700 2.938378378  2.985095e+00
      [209,]  4.61656880 2.020099449  9.235694e-01
      [210,]  4.06247230 1.848186683  2.347911e+00
      [211,]  4.86839367 1.764158309 -9.913021e-01
      [212,]  5.99995713 1.376332991  2.009260e+00
      [213,]  5.18142756 1.008816799 -9.834043e-01
      [214,]  4.77047010 2.394612064 -9.733016e-01
      [215,]  4.15395287 1.784938101  5.331081e-01
      [216,]  4.90252821 2.720718462 -9.952383e-01
      [217,]  5.90832309 2.718485748 -4.182692e-01
      [218,]  4.00005155 2.541052536  1.015328e-02
      [219,]  4.83602579 1.056478953  9.864646e-01
      [220,]  5.03664860 2.770926193  2.999328e+00
      [221,]  5.91647434 1.030757740 -4.000935e-01
      [222,]  4.67295103 1.182344446  9.450074e-01
      [223,]  4.00341664 2.249083577  8.259296e-02
      [224,]  5.78020526 1.386190894 -6.255236e-01
      [225,]  4.00669168 2.363312311  2.115493e+00
      [226,]  5.90521699 1.869135932  1.575050e+00
      [227,]  4.61480225 2.522131730 -9.228341e-01
      [228,]  5.91432722 2.713665196  1.595024e+00
      [229,]  4.00283921 2.405067837 -7.530182e-02
      [230,]  5.98707083 2.099669202  1.839715e+00
      [231,]  4.85869739 2.195785810 -9.899664e-01
      [232,]  4.98976976 2.506601181  9.999477e-01
      [233,]  4.96891969 2.842954344 -9.995169e-01
      [234,]  4.79422398 1.732664418  2.978599e+00
      [235,]  4.77980852 2.188861799  9.754567e-01
      [236,]  5.71940437 1.263696851  2.694592e+00
      [237,]  5.86615948 2.908860170 -4.997677e-01
      [238,]  5.04845746 1.062536585 -9.988252e-01
      [239,]  5.57631837 2.731913370 -8.172253e-01
      [240,]  4.13152687 1.184721717 -4.957363e-01
      [241,]  4.22995096 1.617012171 -6.379847e-01
      [242,]  4.66656910 2.149262027  9.427745e-01
      [243,]  5.23629005 1.449465975  2.971683e+00
      [244,]  5.68220152 1.299356702  2.731164e+00
      [245,]  5.95498891 2.841817780  1.703359e+00
      [246,]  4.37893575 2.637170752  2.783760e+00
      [247,]  5.53279458 2.712715269  1.153755e+00
      [248,]  5.82867550 1.789636117 -5.597293e-01
      [249,]  5.18325302 1.212106486 -9.830658e-01
      [250,]  4.43758774 1.026690016  2.826857e+00
      [251,]  5.93469137 2.317467782  1.644540e+00
      [252,]  5.56261008 2.679368130  1.173278e+00
      [253,]  5.90383590 2.103674038  2.427879e+00
      [254,]  4.01709196 1.882114554 -1.840972e-01
      [255,]  4.25902242 2.408018451 -6.715298e-01
      [256,]  4.63056465 2.605804428  2.929256e+00
      [257,]  4.60239504 2.505051773  9.175567e-01
      [258,]  5.77938044 1.238144463 -6.265510e-01
      [259,]  5.04941023 1.655557580  1.001221e+00
      [260,]  4.03020228 2.105913892 -2.439106e-01
      [261,]  4.78052263 1.349411472  2.975618e+00
      [262,]  5.86433001 1.223799259  2.502925e+00
      [263,]  5.57427022 2.686432461 -8.186658e-01
      [264,]  5.70959729 1.933845343 -7.046075e-01
      [265,]  5.35216428 2.772948366 -9.359382e-01
      [266,]  4.25821404 1.412970412  2.670637e+00
      [267,]  4.76482960 2.674829439  9.719542e-01
      [268,]  4.69782795 1.108269950  2.953253e+00
      [269,]  5.35341923 1.784442851 -9.354650e-01
      [270,]  5.10836475 1.488445224  2.994111e+00
      [271,]  4.47814333 1.133368262 -8.530332e-01
      [272,]  5.99947468 2.400219185  2.032409e+00
      [273,]  4.74411245 2.141751539 -9.667066e-01
      [274,]  4.32111774 1.215630172 -7.342471e-01
      [275,]  5.60449802 1.661634644  2.796607e+00
      [276,]  4.64975605 2.526160114  9.366585e-01
      [277,]  5.85701717 1.181376279  2.515288e+00
      [278,]  5.05408968 2.913479391  2.998536e+00
      [279,]  5.82539243 2.473665772  1.435441e+00
      [280,]  5.44085460 2.561290836  2.897579e+00
      [281,]  5.98380388 2.442687864 -1.792482e-01
      [282,]  4.77420445 1.916289135 -9.741747e-01
      [283,]  5.49866929 1.268285465  2.866792e+00
      [284,]  5.99842240 1.124680266  1.943851e+00
      [285,]  4.95811793 1.643452152  9.991226e-01
      [286,]  4.51683235 2.817222137  8.755279e-01
      [287,]  5.17354247 1.139966871  2.984826e+00
      [288,]  5.99983718 1.445710137  2.018044e+00
      [289,]  4.88614522 2.089697591  9.934974e-01
      [290,]  5.99007755 2.026490032 -1.405221e-01
      [291,]  5.28553145 2.631998343 -9.583693e-01
      [292,]  4.12875643 1.449838156  2.490851e+00
      [293,]  5.55314547 1.090281535  1.166915e+00
      [294,]  5.37644329 1.843740203  1.073560e+00
      [295,]  5.57615891 2.378183716  1.182662e+00
      [296,]  5.25516330 2.667676521 -9.668980e-01
      [297,]  4.74045958 2.287141010  2.965732e+00
      [298,]  5.71421084 1.038504738 -6.999306e-01
      [299,]  4.67271975 1.823097409  2.944927e+00
      [300,]  5.22771033 2.176628315  2.973729e+00
      [301,]  4.01107442 1.087169163  2.148412e+00
      [302,]  4.86259388 1.268383017  2.990515e+00
      [303,]  5.66825185 2.178429219  1.256065e+00
      [304,]  4.28233219 1.329731511  6.963856e-01
      [305,]  4.17256427 1.585485986  2.561560e+00
      [306,]  4.00198225 1.839144383 -6.293312e-02
      [307,]  5.92604068 2.833204129  2.377424e+00
      [308,]  5.14846675 2.498886698  1.011083e+00
      [309,]  4.34711624 1.089276489 -7.574581e-01
      [310,]  4.29831632 2.343095946  2.712489e+00
      [311,]  4.91158618 1.652325992 -9.960838e-01
      [312,]  5.33027119 2.672562846  1.056114e+00
      [313,]  4.52232960 1.139355525 -8.785391e-01
      [314,]  5.99957246 2.670055923  1.970761e+00
      [315,]  4.01909031 1.612632196  1.944638e-01
      [316,]  5.97664288 1.611149286  2.214869e+00
      [317,]  4.31153724 1.618184003  7.252717e-01
      [318,]  5.72495225 2.608546997 -6.887991e-01
      [319,]  4.22626097 2.768485096  6.335045e-01
      [320,]  4.36114696 1.306805071  7.693288e-01
      [321,]  5.62469761 2.087080927 -7.808668e-01
      [322,]  4.01450965 2.202922498  1.697314e-01
      [323,]  5.82499731 1.215397033  2.565137e+00
      [324,]  5.96251995 1.964632392  2.271211e+00
      [325,]  4.25362217 1.911959185 -6.655225e-01
      [326,]  5.90787197 2.772126134  1.580752e+00
      [327,]  4.01275995 2.552860437  1.592391e-01
      [328,]  4.79095120 2.463593576  9.779052e-01
      [329,]  5.45119120 2.798002221  2.892427e+00
      [330,]  4.00627635 1.495635085  2.111863e+00
      [331,]  5.99813759 1.456622513 -6.100291e-02
      [332,]  4.02820178 1.188263731  2.358139e-01
      [333,]  4.37454911 1.076697989  7.802635e-01
      [334,]  5.27241987 1.520627713  2.962178e+00
      [335,]  5.12406825 1.431289490  2.992274e+00
      [336,]  4.33666876 1.135526460  2.748326e+00
      [337,]  5.59629006 1.983110494 -8.027691e-01
      [338,]  4.64739432 1.137395004  9.357720e-01
      [339,]  5.98619576 1.729723424  1.834416e+00
      [340,]  4.00171756 1.519298313  2.058585e+00
      [341,]  4.66945897 1.475570150 -9.437916e-01
      [342,]  4.00596255 2.507568763  2.109039e+00
      [343,]  5.98362232 1.196633140  2.180242e+00
      [344,]  4.26239775 2.296403734  6.752355e-01
      [345,]  4.87411111 2.291397314  9.920443e-01
      [346,]  4.00426912 1.144485847 -9.230397e-02
      [347,]  4.74807453 1.410391557  9.677466e-01
      [348,]  4.34534560 1.786490273  2.755928e+00
      [349,]  5.56613089 2.902732538  1.175685e+00
      [350,]  4.67379091 1.092574335  2.945298e+00
      [351,]  5.15933069 2.756885453 -9.872253e-01
      [352,]  5.70005081 1.324280748  1.285907e+00
      [353,]  5.80062016 2.834545954 -5.991722e-01
      [354,]  4.22815491 1.254943973  2.635811e+00
      [355,]  5.19859573 2.592531102 -9.800815e-01
      [356,]  5.82182138 1.042343645  2.569745e+00
      [357,]  4.95875764 1.190437324  2.999149e+00
      [358,]  4.64943456 2.414165185  2.936538e+00
      [359,]  5.70438416 1.806571780  2.709819e+00
      [360,]  5.87533129 2.008542863  2.483524e+00
      [361,]  4.34545329 1.170386605 -7.560216e-01
      [362,]  5.66704900 2.052196551 -7.450138e-01
      [363,]  5.99432448 2.240900111 -1.063900e-01
      [364,]  5.92847813 2.303706737  2.371387e+00
      [365,]  4.27921760 2.809160742 -6.931614e-01
      [366,]  5.38588962 1.187053455 -9.225450e-01
      [367,]  4.12034520 1.091577793  2.475613e+00
      [368,]  4.01410843 2.465671603  2.167385e+00
      [369,]  4.57492867 1.679776855  2.905160e+00
      [370,]  5.73021788 1.807740299  2.683214e+00
      [371,]  5.71074044 2.672903239  1.296546e+00
      [372,]  5.59182234 2.735012847  2.806068e+00
      [373,]  4.00720191 2.999640650 -1.197996e-01
      [374,]  5.49866305 2.900491086 -8.667959e-01
      [375,]  4.16864909 1.348129116  2.555748e+00
      [376,]  5.57784659 1.715315748  2.816145e+00
      [377,]  4.63200418 2.837193044  2.929827e+00
      [378,]  4.06013479 2.547892871  3.415456e-01
      [379,]  4.58387187 1.418081269  2.909306e+00
      [380,]  4.00628845 2.881522425  1.119703e-01
      [381,]  5.95980979 2.504400608 -2.806513e-01
      [382,]  5.47316161 1.935968087 -8.809756e-01
      [383,]  5.73481232 2.668815269  1.321730e+00
      [384,]  5.43057850 2.201894378  2.902553e+00
      [385,]  4.55241402 1.389511471 -8.942409e-01
      [386,]  4.51525578 2.232119335  8.746560e-01
      [387,]  5.09996510 1.241577500  2.994991e+00
      [388,]  4.80393323 2.631623207  2.980591e+00
      [389,]  5.32741044 1.999971105  1.055118e+00
      [390,]  5.96831227 1.043859514  1.750257e+00
      [391,]  4.74391558 2.357312052  2.966654e+00
      [392,]  4.55130361 1.834209821  8.936843e-01
      [393,]  5.99517106 2.082844731 -9.815576e-02
      [394,]  4.66357106 2.575607107  2.941709e+00
      [395,]  4.42382155 2.935622364 -8.173239e-01
      [396,]  5.43252777 2.144975617 -9.016206e-01
      [397,]  5.66345348 2.477405285  1.251782e+00
      [398,]  5.82425071 2.557662486  2.566225e+00
      [399,]  4.20965045 1.528842322  2.612656e+00
      [400,]  5.98943256 1.818520688 -1.449938e-01

# mirror_scurves() works

    Code
      mirror_scurves(n = 200, num_noise = 2, min_n = -0.05, max_n = 0.05)
    Output
                    [,1]        [,2]          [,3]          [,4]          [,5]
        [1,] -0.63409382 0.063774541 -1.773256e+00 -1.458899e-02 -1.393803e-02
        [2,]  0.60979065 1.249925162 -2.074375e-01  2.865623e-02 -2.225547e-02
        [3,] -0.77282163 1.780726119  1.634623e+00  2.609781e-02 -2.738212e-02
        [4,] -0.97598814 0.757715126  7.821763e-01  4.110739e-02  3.073480e-02
        [5,]  0.60165944 1.155540646  1.798753e+00  4.965122e-02 -2.495993e-02
        [6,]  0.23391154 1.866233288 -1.972258e+00  3.251858e-02 -4.024293e-02
        [7,] -0.59213043 0.807636847 -1.805842e+00 -2.281042e-02  4.621974e-02
        [8,] -0.31892865 0.191069238  5.222127e-02 -4.688578e-02 -3.932236e-02
        [9,]  0.98304320 1.994901470 -8.166259e-01  3.585914e-02  2.399021e-02
       [10,]  0.52746023 1.305306111 -1.504203e-01 -4.046627e-02 -4.876298e-02
       [11,] -0.54575151 0.268577042  1.620529e-01  1.089824e-02 -5.570777e-03
       [12,] -0.76238203 0.681617608  3.528728e-01  3.413554e-02  3.719361e-02
       [13,]  0.83018106 1.628871372  1.557494e+00  3.089505e-02  4.364063e-02
       [14,] -0.05256134 0.101190451  1.998618e+00 -4.024651e-02  3.907752e-02
       [15,]  0.99044093 1.578777892 -8.620625e-01  2.819042e-02  2.274678e-02
       [16,]  0.80008922 0.728091357 -4.001190e-01  3.771454e-02 -2.764111e-02
       [17,] -0.99342170 0.952620177  1.114513e+00  4.630252e-03  4.468815e-02
       [18,] -0.29058582 1.611445446  4.315107e-02  4.492376e-02  1.634977e-03
       [19,] -0.99990729 1.368739535 -1.013617e+00 -1.361151e-02 -2.401393e-02
       [20,] -0.76350898 0.080933786 -1.645797e+00  2.761497e-02  1.812660e-02
       [21,]  0.97168436 0.303877640 -7.637173e-01 -7.016805e-03 -4.922323e-02
       [22,] -0.58161788 0.915988121 -1.813462e+00 -7.230506e-03 -3.299203e-02
       [23,] -0.08179654 1.618599133  3.350952e-03 -1.352021e-02  6.474367e-03
       [24,]  0.95810815 1.466526459  1.286407e+00  4.457019e-02  4.223610e-02
       [25,]  0.81002386 0.222876150 -4.136031e-01  1.310034e-03 -3.448482e-02
       [26,] -0.67371532 0.279894869 -1.738991e+00  9.513795e-03  3.052665e-02
       [27,] -0.26847269 1.110955666  3.671270e-02 -3.003845e-02  2.311675e-02
       [28,]  0.81181813 0.784043477  1.583910e+00 -6.382821e-03 -1.942860e-02
       [29,] -0.96495110 0.407290157  1.262430e+00  2.444980e-02 -1.718890e-04
       [30,]  0.99615149 0.800643028 -9.123518e-01  2.677100e-02  3.404807e-02
       [31,]  0.98467740 1.129141585 -8.256141e-01 -4.704865e-02 -2.371948e-02
       [32,]  0.15116459 1.619091009  1.988509e+00  2.961780e-02  4.342598e-04
       [33,] -0.91400277 1.501779689  5.942920e-01 -3.370171e-02 -4.823518e-02
       [34,]  0.61208821 0.361318561  1.790789e+00 -1.654683e-02 -1.964920e-02
       [35,]  0.95132213 1.708069316 -6.918017e-01 -1.833225e-02  1.948357e-02
       [36,]  0.99299450 1.857192501  1.118161e+00  3.866709e-03 -1.592498e-02
       [37,]  0.99692836 1.688570697 -9.216811e-01  4.063287e-02  2.456669e-02
       [38,] -0.39838585 0.316740780  1.917218e+00 -3.401228e-02 -4.787787e-02
       [39,] -0.02975532 1.908132700 -1.999557e+00 -4.455656e-03  2.193019e-03
       [40,]  0.13251027 0.754789950  1.991182e+00 -2.337754e-02  4.167884e-02
       [41,] -0.65756705 0.954946357 -1.753396e+00 -6.600727e-03 -2.316105e-02
       [42,] -0.66178996 0.902697199  1.749689e+00 -7.430371e-03 -2.623009e-02
       [43,]  0.06864664 0.257909717  1.997641e+00  4.363294e-02  3.703178e-02
       [44,]  0.18066782 0.616219185 -1.645583e-02 -4.190935e-02  3.463169e-02
       [45,] -0.53663480 0.661056175  1.561854e-01 -3.425425e-02 -4.101954e-02
       [46,] -0.46717887 0.530509430  1.158372e-01  3.860183e-02 -1.660521e-02
       [47,]  0.64598602 1.929210094  1.763349e+00  7.435258e-03  3.055208e-02
       [48,]  0.72403491 1.280943904 -3.102367e-01 -4.040416e-02  2.456755e-02
       [49,]  0.95838467 1.055488120 -7.145200e-01  4.276738e-02  3.454551e-02
       [50,]  0.69780794 0.560436827 -2.837151e-01 -2.994692e-02  3.508595e-04
       [51,]  0.97949914 0.970802149 -7.985517e-01  4.456985e-02  3.405702e-03
       [52,] -0.76712559 1.653604885 -1.641497e+00  1.082111e-02  1.186254e-03
       [53,]  0.40244559 1.139052992 -8.455610e-02  1.241861e-02  1.096035e-02
       [54,] -0.18113170 0.018862059  1.983459e+00  1.631652e-02 -2.121938e-02
       [55,]  0.48699748 1.748582728 -1.265966e-01 -3.040836e-03  2.175540e-02
       [56,] -0.71736749 0.196266359 -1.696695e+00  4.027878e-02  1.917075e-02
       [57,] -0.21661629 0.243520937  1.976257e+00  9.351035e-03 -4.423345e-02
       [58,] -0.45758849 1.276028467 -1.889164e+00  1.717753e-02  2.195092e-02
       [59,] -0.55047369 0.716383994 -1.834853e+00  7.135615e-03  4.953112e-02
       [60,] -0.99419990 0.677786445 -1.107548e+00  3.335375e-02 -1.138406e-02
       [61,] -0.66771783 0.086013095  2.555855e-01 -3.431115e-03 -1.550899e-02
       [62,]  0.19022187 1.345622776  1.981741e+00 -1.866506e-02  4.010219e-02
       [63,] -0.17441078 1.444418599  1.984673e+00  2.138503e-02 -1.634947e-02
       [64,]  0.12352264 0.023972705  1.992342e+00 -4.667769e-02  4.253979e-02
       [65,]  0.97212372 0.850826656 -7.655315e-01  3.253958e-02 -4.808981e-02
       [66,]  0.94858297 1.668513428 -6.834714e-01 -2.804652e-02 -3.081084e-02
       [67,]  0.72095834 1.711205878 -1.692978e+00 -9.009592e-03  7.190514e-03
       [68,] -0.85775561 0.066013470 -1.514058e+00  2.988130e-02 -4.127902e-02
       [69,]  0.84482271 0.575445720 -4.649537e-01  7.058739e-03  2.404599e-02
       [70,]  0.83675633 0.425235970  1.547575e+00 -1.708714e-02  1.933766e-02
       [71,] -0.99977917 1.976261157  9.789856e-01 -2.566097e-02 -4.239964e-02
       [72,]  0.89762366 1.508296627 -1.440763e+00 -3.205063e-02  1.849773e-02
       [73,] -0.72342249 1.899215475  3.095944e-01 -2.594132e-02  1.989845e-02
       [74,]  0.69053782 1.658431338 -1.723296e+00  3.803132e-02  1.169297e-02
       [75,] -0.07613472 0.919466956 -1.997098e+00  4.379304e-02 -2.322755e-02
       [76,] -0.61473001 0.714307189 -1.788738e+00 -1.434154e-02  1.927021e-02
       [77,]  0.92609278 1.659275169 -1.377296e+00 -4.449161e-03  3.201269e-02
       [78,]  0.61462550 0.010710677  1.788819e+00 -7.503827e-03  8.195556e-03
       [79,] -0.22119842 1.721395517  1.975229e+00 -4.656778e-02  3.135465e-02
       [80,] -0.38332199 0.594214020  1.923615e+00 -2.710841e-02 -2.442750e-02
       [81,] -0.79441275 0.267338136  1.607378e+00  2.600811e-02  1.517884e-02
       [82,]  0.49691144 1.598290628  1.867801e+00 -3.284313e-02  3.514090e-02
       [83,]  0.54378297 0.287826222  1.839226e+00 -4.479017e-02 -2.150824e-02
       [84,]  0.71724226 0.384631082 -1.696824e+00 -3.177405e-02 -2.728485e-03
       [85,] -0.96460709 0.546936116 -1.263691e+00  1.214109e-02 -3.871202e-02
       [86,] -0.21540610 0.702272893 -1.976525e+00 -2.545728e-03 -2.278382e-02
       [87,] -0.56843312 1.069517132 -1.822729e+00 -3.369623e-02 -2.512407e-02
       [88,] -0.09545236 0.569871100  1.995434e+00 -3.942831e-02  4.649326e-02
       [89,]  0.56793327 0.361250622  1.823075e+00  1.072001e-02 -1.995078e-02
       [90,]  0.97235848 1.743206203 -7.665070e-01 -4.184796e-02  2.565149e-02
       [91,]  0.39500403 0.003964251 -1.918679e+00 -4.625760e-02  4.058669e-02
       [92,]  0.24121023 0.744558516 -2.952711e-02 -2.384936e-02 -2.873166e-03
       [93,] -0.61685902 0.882445178  2.129263e-01 -2.029594e-02 -4.442756e-02
       [94,] -0.36354115 0.484774913  6.842186e-02 -3.089043e-05  4.911115e-02
       [95,] -0.28515728 0.453154247 -1.958481e+00 -2.164460e-02  4.165463e-02
       [96,] -0.17648281 1.707843470  1.984304e+00  7.280862e-03  3.419861e-02
       [97,]  0.93854228 0.638782745 -6.548357e-01 -5.159603e-03  8.630894e-03
       [98,] -0.99476748 1.088968290  8.978351e-01  4.571919e-02 -1.077493e-02
       [99,]  0.63840919 1.942947816 -1.769697e+00  4.371184e-02 -1.501543e-02
      [100,]  0.48191627 1.359759802  1.876217e+00 -8.465952e-03 -3.249849e-02
      [101,] -0.99846041 0.205947322 -1.055469e+00  9.797570e-03  3.576007e-02
      [102,]  0.78290531 1.581526350 -3.778591e-01 -2.422641e-02  1.850679e-02
      [103,]  0.78292246 1.844720363 -3.778807e-01  3.277202e-02 -2.710531e-02
      [104,]  0.50889106 0.571379955 -1.391691e-01 -9.997107e-03 -2.235682e-02
      [105,] -0.26364404 0.001133419 -1.964620e+00 -3.069320e-02 -3.600592e-02
      [106,]  0.96356863 0.286296412 -7.325388e-01  1.476614e-02  1.070241e-02
      [107,] -0.83919128 1.031274604  1.543836e+00 -1.839283e-02 -1.818586e-02
      [108,]  0.99161779 0.753206508  1.129206e+00  2.645821e-02 -2.815670e-02
      [109,] -0.38092869 0.431321371 -1.924604e+00  1.278195e-02  3.828808e-03
      [110,]  0.53698730 0.298340388 -1.564097e-01 -4.227686e-02  4.094278e-02
      [111,] -0.91413020 0.293121752  5.945793e-01 -9.606105e-03 -3.250933e-02
      [112,]  0.98955811 1.846285003 -8.558655e-01 -2.830282e-02  2.053256e-02
      [113,]  0.61100720 0.896075070 -2.083750e-01 -4.181241e-02  3.559308e-02
      [114,] -0.90405033 0.221061511  5.725740e-01  1.311135e-02 -4.878065e-02
      [115,]  0.76141910 0.826848178  1.648260e+00  1.880957e-02 -4.481919e-02
      [116,]  0.95433302 1.464081183 -1.298745e+00  1.712295e-02  4.397552e-02
      [117,]  0.07728123 0.508617444  1.997009e+00  7.884755e-03 -3.610309e-02
      [118,] -0.96624270 0.368221651  7.423665e-01  4.200629e-02  2.131414e-02
      [119,] -0.40049252 1.454689750  8.369997e-02  2.877043e-02 -3.636798e-03
      [120,] -0.27244919 0.267010221 -1.962170e+00  3.228527e-02 -3.402189e-02
      [121,]  0.75884487 1.315697334 -3.487286e-01  2.788319e-02 -3.049437e-02
      [122,]  0.38374880 1.140271035  1.923438e+00 -1.741983e-02  8.520503e-03
      [123,]  0.93398247 1.416398077 -1.357319e+00  5.182130e-03 -3.672661e-02
      [124,] -0.79037523 0.621550838  3.873769e-01 -2.974713e-02 -2.642170e-02
      [125,]  0.64403155 1.676432175 -2.350011e-01  2.027644e-02 -9.144743e-03
      [126,] -0.55080799 0.078015211 -1.834632e+00  6.945097e-03  5.949574e-03
      [127,] -0.96895750 1.894756693  7.527727e-01 -2.858230e-03 -2.816194e-02
      [128,] -0.01271875 1.544994786  8.088654e-05  4.814338e-02  1.726960e-03
      [129,]  0.55632584 0.678057181  1.830964e+00 -1.638557e-02 -2.569834e-02
      [130,] -0.74055366 1.928896648 -1.671997e+00 -4.239687e-02 -4.967059e-02
      [131,]  0.97149605 1.358698701 -1.237056e+00  2.032662e-02  5.135249e-03
      [132,] -0.03175129 0.585234926  1.999496e+00  4.524067e-03 -2.735784e-02
      [133,] -0.85330302 1.074887576 -1.521415e+00  1.712918e-02 -1.159155e-02
      [134,]  0.24193139 0.762832400  1.970293e+00  4.000003e-02  2.640640e-02
      [135,]  0.89591845 1.127480770 -1.444219e+00 -3.129462e-02  1.985293e-02
      [136,]  0.82098919 0.404269010 -1.570944e+00 -1.696542e-02 -2.438598e-04
      [137,]  0.39307978 0.133034837 -1.919504e+00 -2.599024e-02 -5.309682e-03
      [138,]  0.12470062 0.672934750  1.992194e+00  2.685868e-02 -3.622295e-02
      [139,]  0.73704309 1.719839212 -1.675846e+00  3.175927e-02 -1.938526e-02
      [140,]  0.83528486 0.258196992  1.549817e+00 -2.017552e-02  9.325156e-03
      [141,] -0.97514970 0.007235975  1.221547e+00  1.430562e-02 -2.487195e-02
      [142,]  0.99613085 1.228903851 -9.121175e-01 -4.388218e-02  4.730527e-02
      [143,] -0.95891056 0.684627399  7.162915e-01  4.704672e-02  2.389774e-02
      [144,]  0.91081911 0.034549879 -1.412806e+00 -4.432870e-03 -2.647772e-02
      [145,]  0.33995330 1.834892436 -1.940442e+00 -3.661782e-02 -1.890590e-02
      [146,] -0.47539149 1.981520003 -1.879774e+00  8.528756e-03 -3.497542e-02
      [147,]  0.88089315 0.713166462 -5.266848e-01 -7.837044e-03  4.571855e-02
      [148,]  0.54649709 0.220612736  1.837461e+00 -3.644674e-02  1.080535e-02
      [149,] -0.41747708 0.898956143 -1.908687e+00  3.336327e-02 -4.276782e-02
      [150,] -0.72859424 0.323019431  3.150544e-01 -1.907975e-02  1.553904e-02
      [151,]  0.57113737 1.014415488  1.820854e+00 -1.471168e-03 -1.026275e-02
      [152,] -0.50647982 1.717122592 -1.862252e+00 -1.342903e-02 -2.543897e-02
      [153,]  0.85019884 0.313134466 -4.735383e-01  3.520064e-02 -1.780995e-02
      [154,] -0.82760113 1.761825189  1.561317e+00 -2.381260e-02 -1.053365e-02
      [155,]  0.29718557 0.964696032 -4.518026e-02 -2.661871e-02 -2.969802e-02
      [156,]  0.97809302 1.542461636 -1.208168e+00  3.555762e-02 -1.318234e-02
      [157,] -0.63383238 0.692651781 -1.773470e+00  3.595247e-02 -2.211034e-02
      [158,] -0.88400645 0.128416669  1.467475e+00 -1.364102e-02 -1.949560e-02
      [159,]  0.99333294 0.985922315 -1.115281e+00  4.875386e-02  3.431024e-02
      [160,]  0.72229206 0.914751434  1.691588e+00  2.493871e-02 -3.547910e-02
      [161,]  0.40129481 1.614117147 -1.915949e+00 -4.896922e-03 -4.555309e-02
      [162,] -0.98915344 0.655636163  1.146886e+00 -3.970057e-02  4.446336e-02
      [163,]  0.73329695 1.689129653  1.679909e+00  8.724967e-03 -2.781911e-02
      [164,]  0.89629380 0.708948566 -1.443461e+00  1.597159e-02 -1.002056e-02
      [165,]  0.30494791 1.048128242 -4.763097e-02 -2.019766e-02  2.079151e-02
      [166,] -0.95898518 1.941090359  7.165438e-01  9.139048e-03  1.940213e-02
      [167,]  0.93634987 0.140737269 -6.489318e-01  3.028368e-02 -4.202857e-02
      [168,]  0.63886572 1.628961627  1.769318e+00  1.788580e-02  1.437366e-02
      [169,]  0.50824008 0.061485993 -1.387846e-01 -4.290069e-02  4.711666e-02
      [170,] -0.92930587 1.134437323  1.369311e+00 -2.202454e-02  1.110588e-03
      [171,] -0.36543977 0.269858563  1.930835e+00  6.666061e-03  3.239017e-02
      [172,] -0.80603579 1.296185236  4.081332e-01  4.398104e-02  1.339229e-02
      [173,] -0.89057089 0.423682514  1.454844e+00  2.984306e-02  4.645296e-02
      [174,] -0.92995201 0.212181083  6.323191e-01  4.668091e-03  1.192731e-02
      [175,] -0.96350046 0.126009492  7.322933e-01 -1.147877e-02  2.116185e-02
      [176,]  0.94640858 0.069564044 -1.322972e+00 -2.931105e-02  1.631644e-02
      [177,] -0.97118343 0.417215534 -1.238333e+00 -3.496157e-02  1.546603e-02
      [178,] -0.31916776 1.229762960  5.230177e-02  5.097572e-04 -6.941579e-04
      [179,] -0.89659331 0.610342328 -1.442855e+00 -1.107564e-02  2.659954e-02
      [180,]  0.88896600 0.029302091  1.457973e+00  3.444004e-02 -1.646715e-02
      [181,] -0.29874975 0.805601112  1.954331e+00  1.721028e-03  4.339491e-02
      [182,] -0.14444904 0.910433781  1.048776e-02  5.106072e-03 -2.145939e-02
      [183,] -0.18191331 1.732923050  1.983315e+00 -9.471303e-03  5.977730e-03
      [184,] -0.97480745 0.209889768  7.769519e-01  2.284583e-02 -3.318530e-02
      [185,] -0.08500213 0.892250139 -1.996381e+00 -3.711272e-02 -1.249937e-02
      [186,] -0.83248837 1.116069258 -1.554043e+00  4.431580e-02  6.530065e-03
      [187,] -0.99957968 1.121950002  9.710094e-01  1.383906e-02 -4.114174e-02
      [188,] -0.89523134 0.531653158  1.445602e+00 -3.990231e-02 -2.478450e-02
      [189,] -0.19256939 1.375472712  1.981283e+00  1.393104e-02  4.352686e-02
      [190,]  0.62374970 0.115741799  1.781624e+00 -4.668946e-03 -4.589231e-02
      [191,] -0.95680152 0.161251259  1.290742e+00  1.337010e-02  4.617009e-03
      [192,]  0.70109296 0.002198028 -2.869301e-01 -3.080920e-02  4.507646e-02
      [193,] -0.86285974 1.219482131  4.945566e-01  1.190440e-02  5.940151e-03
      [194,] -0.72866045 0.850496149  3.151249e-01  2.176235e-02 -8.188367e-03
      [195,]  0.40878766 0.389574041  1.912630e+00  3.808644e-03 -3.046013e-02
      [196,] -0.58016631 0.655314586  1.814498e+00 -2.022534e-02 -2.082963e-03
      [197,] -0.94205777 0.918608937  1.335451e+00 -3.642897e-03 -3.047816e-02
      [198,]  0.06597645 1.785906083 -1.997821e+00  5.561239e-03  4.257658e-02
      [199,] -0.57474209 1.674522376 -1.818335e+00  2.585751e-02 -1.141599e-02
      [200,]  0.94814365 1.380196982  1.317842e+00 -1.580620e-02 -2.337407e-02
      [201,]  2.63409382 0.063774541 -1.773256e+00  1.216545e-02  3.390966e-02
      [202,]  1.39020935 1.249925162 -2.074375e-01 -2.438039e-02 -4.143774e-02
      [203,]  2.77282163 1.780726119  1.634623e+00  3.692567e-02 -3.741529e-02
      [204,]  2.97598814 0.757715126  7.821763e-01 -1.229900e-02  4.039443e-02
      [205,]  1.39834056 1.155540646  1.798753e+00  4.542733e-02  2.845354e-02
      [206,]  1.76608846 1.866233288 -1.972258e+00  1.067751e-02  1.434015e-02
      [207,]  2.59213043 0.807636847 -1.805842e+00 -3.728084e-02  1.508975e-02
      [208,]  2.31892865 0.191069238  5.222127e-02 -4.634579e-02 -2.946663e-02
      [209,]  1.01695680 1.994901470 -8.166259e-01 -3.505162e-02 -2.687273e-02
      [210,]  1.47253977 1.305306111 -1.504203e-01  4.885832e-02  2.450101e-02
      [211,]  2.54575151 0.268577042  1.620529e-01  4.737772e-02  3.236095e-02
      [212,]  2.76238203 0.681617608  3.528728e-01 -1.044061e-02 -2.834071e-02
      [213,]  1.16981894 1.628871372  1.557494e+00 -4.555401e-02  1.017609e-02
      [214,]  2.05256134 0.101190451  1.998618e+00 -1.465659e-02 -4.951010e-03
      [215,]  1.00955907 1.578777892 -8.620625e-01  1.518818e-02 -9.329137e-03
      [216,]  1.19991078 0.728091357 -4.001190e-01  9.794076e-03  9.235702e-03
      [217,]  2.99342170 0.952620177  1.114513e+00  2.090481e-03  1.424448e-02
      [218,]  2.29058582 1.611445446  4.315107e-02  1.672968e-02  2.765936e-02
      [219,]  2.99990729 1.368739535 -1.013617e+00 -1.053083e-02 -2.357522e-02
      [220,]  2.76350898 0.080933786 -1.645797e+00  2.569068e-02 -9.247106e-04
      [221,]  1.02831564 0.303877640 -7.637173e-01  1.951988e-02  2.226533e-02
      [222,]  2.58161788 0.915988121 -1.813462e+00  2.975835e-02  1.087636e-02
      [223,]  2.08179654 1.618599133  3.350952e-03  1.109935e-02 -4.905825e-03
      [224,]  1.04189185 1.466526459  1.286407e+00 -1.491552e-02 -2.455052e-02
      [225,]  1.18997614 0.222876150 -4.136031e-01  1.618895e-02 -1.645280e-03
      [226,]  2.67371532 0.279894869 -1.738991e+00  4.736626e-02 -2.338030e-02
      [227,]  2.26847269 1.110955666  3.671270e-02 -2.745094e-02 -4.603940e-02
      [228,]  1.18818187 0.784043477  1.583910e+00 -4.158819e-03  3.328674e-02
      [229,]  2.96495110 0.407290157  1.262430e+00  3.366253e-02  4.064574e-02
      [230,]  1.00384851 0.800643028 -9.123518e-01 -3.562754e-02 -1.298184e-02
      [231,]  1.01532260 1.129141585 -8.256141e-01 -2.016836e-02 -1.381245e-03
      [232,]  1.84883541 1.619091009  1.988509e+00 -3.974189e-03 -9.914179e-03
      [233,]  2.91400277 1.501779689  5.942920e-01 -1.890066e-02 -2.530526e-03
      [234,]  1.38791179 0.361318561  1.790789e+00 -3.394537e-02 -2.729615e-02
      [235,]  1.04867787 1.708069316 -6.918017e-01  3.954843e-02  4.977361e-02
      [236,]  1.00700550 1.857192501  1.118161e+00 -3.515784e-02 -3.738483e-02
      [237,]  1.00307164 1.688570697 -9.216811e-01 -1.184551e-02 -1.781895e-02
      [238,]  2.39838585 0.316740780  1.917218e+00  2.892848e-03  2.909667e-02
      [239,]  2.02975532 1.908132700 -1.999557e+00  4.160459e-02  3.765714e-02
      [240,]  1.86748973 0.754789950  1.991182e+00 -1.335511e-02 -1.222253e-02
      [241,]  2.65756705 0.954946357 -1.753396e+00  3.629767e-02 -2.075209e-02
      [242,]  2.66178996 0.902697199  1.749689e+00  3.141726e-02  4.898746e-02
      [243,]  1.93135336 0.257909717  1.997641e+00  1.774895e-02 -3.192730e-02
      [244,]  1.81933218 0.616219185 -1.645583e-02 -8.120899e-03  2.347345e-02
      [245,]  2.53663480 0.661056175  1.561854e-01  1.586619e-02  3.927989e-02
      [246,]  2.46717887 0.530509430  1.158372e-01  9.185939e-03  4.121712e-02
      [247,]  1.35401398 1.929210094  1.763349e+00 -2.909539e-02 -3.928497e-02
      [248,]  1.27596509 1.280943904 -3.102367e-01  2.053609e-02  3.702536e-02
      [249,]  1.04161533 1.055488120 -7.145200e-01 -8.063634e-03  1.453956e-02
      [250,]  1.30219206 0.560436827 -2.837151e-01  1.553382e-02  1.511670e-02
      [251,]  1.02050086 0.970802149 -7.985517e-01  2.602863e-02 -2.085086e-02
      [252,]  2.76712559 1.653604885 -1.641497e+00 -4.460973e-02  2.631276e-02
      [253,]  1.59755441 1.139052992 -8.455610e-02  4.520893e-02  3.924439e-02
      [254,]  2.18113170 0.018862059  1.983459e+00  2.327186e-03  3.962608e-02
      [255,]  1.51300252 1.748582728 -1.265966e-01 -3.853751e-02  3.601795e-02
      [256,]  2.71736749 0.196266359 -1.696695e+00 -7.380333e-03 -2.132409e-02
      [257,]  2.21661629 0.243520937  1.976257e+00 -2.232958e-02 -4.799574e-02
      [258,]  2.45758849 1.276028467 -1.889164e+00 -6.065673e-03 -3.955065e-02
      [259,]  2.55047369 0.716383994 -1.834853e+00 -1.259044e-02 -3.353678e-02
      [260,]  2.99419990 0.677786445 -1.107548e+00  4.332718e-02  3.749058e-03
      [261,]  2.66771783 0.086013095  2.555855e-01  2.363263e-02  2.561923e-02
      [262,]  1.80977813 1.345622776  1.981741e+00 -2.158810e-02 -4.328054e-02
      [263,]  2.17441078 1.444418599  1.984673e+00 -1.234432e-03 -2.657243e-02
      [264,]  1.87647736 0.023972705  1.992342e+00  3.786748e-02 -2.482937e-03
      [265,]  1.02787628 0.850826656 -7.655315e-01 -5.989409e-03  2.067488e-02
      [266,]  1.05141703 1.668513428 -6.834714e-01  4.697274e-02 -2.909830e-02
      [267,]  1.27904166 1.711205878 -1.692978e+00 -4.611238e-02  5.261940e-03
      [268,]  2.85775561 0.066013470 -1.514058e+00  5.639224e-04  1.225310e-03
      [269,]  1.15517729 0.575445720 -4.649537e-01 -3.845493e-02 -2.573979e-02
      [270,]  1.16324367 0.425235970  1.547575e+00 -8.162953e-03 -4.920211e-02
      [271,]  2.99977917 1.976261157  9.789856e-01  4.392665e-02  3.828112e-03
      [272,]  1.10237634 1.508296627 -1.440763e+00  2.709454e-02 -4.840133e-02
      [273,]  2.72342249 1.899215475  3.095944e-01 -1.836716e-02  1.622421e-02
      [274,]  1.30946218 1.658431338 -1.723296e+00  6.381873e-03  4.705459e-02
      [275,]  2.07613472 0.919466956 -1.997098e+00 -1.990309e-02 -5.583441e-03
      [276,]  2.61473001 0.714307189 -1.788738e+00  2.730781e-02 -1.856189e-02
      [277,]  1.07390722 1.659275169 -1.377296e+00  4.226218e-02 -3.931910e-02
      [278,]  1.38537450 0.010710677  1.788819e+00  4.664999e-02 -2.130964e-02
      [279,]  2.22119842 1.721395517  1.975229e+00  2.116798e-02  2.342741e-02
      [280,]  2.38332199 0.594214020  1.923615e+00 -4.309416e-02  2.933642e-02
      [281,]  2.79441275 0.267338136  1.607378e+00 -1.920677e-02 -2.671146e-02
      [282,]  1.50308856 1.598290628  1.867801e+00 -2.242898e-02 -2.874434e-03
      [283,]  1.45621703 0.287826222  1.839226e+00  4.191774e-02 -4.335716e-02
      [284,]  1.28275774 0.384631082 -1.696824e+00  3.674067e-03  3.560783e-02
      [285,]  2.96460709 0.546936116 -1.263691e+00 -4.443457e-02 -4.759485e-02
      [286,]  2.21540610 0.702272893 -1.976525e+00 -1.860181e-02 -2.414846e-02
      [287,]  2.56843312 1.069517132 -1.822729e+00  2.175452e-02 -3.752585e-02
      [288,]  2.09545236 0.569871100  1.995434e+00 -2.180254e-02 -4.680808e-02
      [289,]  1.43206673 0.361250622  1.823075e+00  4.092405e-02  3.778814e-02
      [290,]  1.02764152 1.743206203 -7.665070e-01 -1.156094e-02  4.903727e-02
      [291,]  1.60499597 0.003964251 -1.918679e+00  4.391131e-02  1.696616e-03
      [292,]  1.75878977 0.744558516 -2.952711e-02  3.421685e-02  1.757738e-02
      [293,]  2.61685902 0.882445178  2.129263e-01  4.220810e-02 -1.058579e-02
      [294,]  2.36354115 0.484774913  6.842186e-02 -4.022145e-02  3.779881e-02
      [295,]  2.28515728 0.453154247 -1.958481e+00  4.296581e-02  9.174128e-03
      [296,]  2.17648281 1.707843470  1.984304e+00 -4.524026e-02 -4.528655e-02
      [297,]  1.06145772 0.638782745 -6.548357e-01 -2.511152e-02 -2.627506e-02
      [298,]  2.99476748 1.088968290  8.978351e-01 -2.906693e-02  2.480230e-02
      [299,]  1.36159081 1.942947816 -1.769697e+00  2.489058e-03  1.863678e-02
      [300,]  1.51808373 1.359759802  1.876217e+00  1.890632e-02  4.428247e-02
      [301,]  2.99846041 0.205947322 -1.055469e+00  2.927220e-02  3.309084e-02
      [302,]  1.21709469 1.581526350 -3.778591e-01  4.092765e-02  6.205570e-04
      [303,]  1.21707754 1.844720363 -3.778807e-01  3.048572e-02  1.274938e-02
      [304,]  1.49110894 0.571379955 -1.391691e-01  3.307067e-02  2.556577e-02
      [305,]  2.26364404 0.001133419 -1.964620e+00  3.749385e-02 -2.704463e-03
      [306,]  1.03643137 0.286296412 -7.325388e-01 -3.411267e-02 -1.715678e-02
      [307,]  2.83919128 1.031274604  1.543836e+00 -3.205123e-02  2.553369e-02
      [308,]  1.00838221 0.753206508  1.129206e+00  3.857820e-02 -1.342221e-02
      [309,]  2.38092869 0.431321371 -1.924604e+00 -2.676152e-02 -2.135242e-02
      [310,]  1.46301270 0.298340388 -1.564097e-01  2.005807e-02 -4.435638e-02
      [311,]  2.91413020 0.293121752  5.945793e-01 -3.963579e-02 -3.480150e-02
      [312,]  1.01044189 1.846285003 -8.558655e-01 -4.464460e-02  7.342764e-03
      [313,]  1.38899280 0.896075070 -2.083750e-01  3.259540e-02 -7.514273e-03
      [314,]  2.90405033 0.221061511  5.725740e-01  4.315758e-02  1.997895e-02
      [315,]  1.23858090 0.826848178  1.648260e+00 -4.323491e-02  2.137183e-02
      [316,]  1.04566698 1.464081183 -1.298745e+00 -1.448548e-02 -8.705977e-03
      [317,]  1.92271877 0.508617444  1.997009e+00  2.217300e-02  1.731751e-02
      [318,]  2.96624270 0.368221651  7.423665e-01 -1.027064e-02 -4.477979e-02
      [319,]  2.40049252 1.454689750  8.369997e-02  4.496821e-02  4.190433e-02
      [320,]  2.27244919 0.267010221 -1.962170e+00  2.655916e-02  2.007988e-02
      [321,]  1.24115513 1.315697334 -3.487286e-01 -8.054416e-03 -3.115944e-02
      [322,]  1.61625120 1.140271035  1.923438e+00 -4.392374e-02 -2.308626e-02
      [323,]  1.06601753 1.416398077 -1.357319e+00 -2.359525e-02  3.330740e-02
      [324,]  2.79037523 0.621550838  3.873769e-01 -1.092390e-02  4.415502e-02
      [325,]  1.35596845 1.676432175 -2.350011e-01  4.630102e-02 -3.834558e-02
      [326,]  2.55080799 0.078015211 -1.834632e+00  2.662198e-02  2.309174e-02
      [327,]  2.96895750 1.894756693  7.527727e-01 -4.263518e-03 -8.338904e-03
      [328,]  2.01271875 1.544994786  8.088654e-05 -2.611584e-02  3.812055e-02
      [329,]  1.44367416 0.678057181  1.830964e+00  4.355451e-02  3.733654e-05
      [330,]  2.74055366 1.928896648 -1.671997e+00 -1.124803e-02 -4.724280e-02
      [331,]  1.02850395 1.358698701 -1.237056e+00 -2.867090e-02 -1.894036e-02
      [332,]  2.03175129 0.585234926  1.999496e+00  1.485437e-02  7.934875e-03
      [333,]  2.85330302 1.074887576 -1.521415e+00  4.124495e-02  2.471494e-02
      [334,]  1.75806861 0.762832400  1.970293e+00 -3.849647e-02 -9.015889e-03
      [335,]  1.10408155 1.127480770 -1.444219e+00 -4.035356e-02 -2.119069e-03
      [336,]  1.17901081 0.404269010 -1.570944e+00  4.438101e-02  2.862516e-02
      [337,]  1.60692022 0.133034837 -1.919504e+00  1.914029e-02 -4.937218e-02
      [338,]  1.87529938 0.672934750  1.992194e+00 -8.827151e-03  1.189991e-03
      [339,]  1.26295691 1.719839212 -1.675846e+00  6.906394e-03 -1.052345e-02
      [340,]  1.16471514 0.258196992  1.549817e+00 -2.500496e-02  1.419472e-02
      [341,]  2.97514970 0.007235975  1.221547e+00  3.486415e-02 -3.895420e-02
      [342,]  1.00386915 1.228903851 -9.121175e-01  3.207366e-02  1.607776e-02
      [343,]  2.95891056 0.684627399  7.162915e-01  1.476420e-02  3.519951e-02
      [344,]  1.08918089 0.034549879 -1.412806e+00 -1.487132e-03 -4.306235e-02
      [345,]  1.66004670 1.834892436 -1.940442e+00 -3.114883e-02 -2.677924e-02
      [346,]  2.47539149 1.981520003 -1.879774e+00  3.930624e-02  3.370115e-02
      [347,]  1.11910685 0.713166462 -5.266848e-01 -1.292091e-02 -7.628256e-03
      [348,]  1.45350291 0.220612736  1.837461e+00 -3.438110e-02  1.474725e-03
      [349,]  2.41747708 0.898956143 -1.908687e+00  3.673330e-02  2.119039e-02
      [350,]  2.72859424 0.323019431  3.150544e-01 -7.785790e-03  1.268381e-02
      [351,]  1.42886263 1.014415488  1.820854e+00  3.775987e-02  1.346007e-02
      [352,]  2.50647982 1.717122592 -1.862252e+00 -2.817780e-02 -1.548746e-02
      [353,]  1.14980116 0.313134466 -4.735383e-01  1.064854e-02 -2.307818e-02
      [354,]  2.82760113 1.761825189  1.561317e+00  4.422468e-02  4.217972e-02
      [355,]  1.70281443 0.964696032 -4.518026e-02  4.409485e-03  4.829483e-02
      [356,]  1.02190698 1.542461636 -1.208168e+00  2.765841e-02  2.072083e-02
      [357,]  2.63383238 0.692651781 -1.773470e+00  6.641598e-03  3.700059e-02
      [358,]  2.88400645 0.128416669  1.467475e+00 -2.512449e-02 -2.682958e-02
      [359,]  1.00666706 0.985922315 -1.115281e+00 -4.955630e-02  5.010260e-03
      [360,]  1.27770794 0.914751434  1.691588e+00 -3.146839e-03  2.138814e-02
      [361,]  1.59870519 1.614117147 -1.915949e+00  9.831291e-03  3.384213e-02
      [362,]  2.98915344 0.655636163  1.146886e+00 -2.714389e-02 -2.381642e-02
      [363,]  1.26670305 1.689129653  1.679909e+00 -4.002474e-02 -3.741723e-02
      [364,]  1.10370620 0.708948566 -1.443461e+00  3.417797e-02 -2.485847e-02
      [365,]  1.69505209 1.048128242 -4.763097e-02  5.691283e-03 -1.459736e-03
      [366,]  2.95898518 1.941090359  7.165438e-01  2.159807e-02 -4.685443e-03
      [367,]  1.06365013 0.140737269 -6.489318e-01 -8.071225e-03 -4.021027e-02
      [368,]  1.36113428 1.628961627  1.769318e+00  4.391317e-03  4.312391e-02
      [369,]  1.49175992 0.061485993 -1.387846e-01 -4.771512e-03  1.495112e-02
      [370,]  2.92930587 1.134437323  1.369311e+00  1.587071e-02 -1.122955e-02
      [371,]  2.36543977 0.269858563  1.930835e+00  3.635973e-02  4.721409e-02
      [372,]  2.80603579 1.296185236  4.081332e-01 -1.133370e-02 -4.704446e-02
      [373,]  2.89057089 0.423682514  1.454844e+00  2.288790e-02  6.842718e-03
      [374,]  2.92995201 0.212181083  6.323191e-01 -6.661088e-03  1.286648e-02
      [375,]  2.96350046 0.126009492  7.322933e-01 -3.594665e-02 -3.359787e-02
      [376,]  1.05359142 0.069564044 -1.322972e+00 -3.459761e-02 -4.484048e-02
      [377,]  2.97118343 0.417215534 -1.238333e+00 -5.795360e-03 -4.241089e-02
      [378,]  2.31916776 1.229762960  5.230177e-02  1.656536e-02 -3.371412e-02
      [379,]  2.89659331 0.610342328 -1.442855e+00  1.015206e-02 -1.659019e-02
      [380,]  1.11103400 0.029302091  1.457973e+00 -4.870286e-02 -2.000044e-02
      [381,]  2.29874975 0.805601112  1.954331e+00 -1.152507e-02  1.690339e-02
      [382,]  2.14444904 0.910433781  1.048776e-02 -4.444306e-02 -9.961860e-03
      [383,]  2.18191331 1.732923050  1.983315e+00 -8.271111e-03 -2.888342e-02
      [384,]  2.97480745 0.209889768  7.769519e-01  3.604335e-02 -2.930204e-02
      [385,]  2.08500213 0.892250139 -1.996381e+00  4.192450e-02 -4.338725e-02
      [386,]  2.83248837 1.116069258 -1.554043e+00  3.463579e-02  1.025363e-03
      [387,]  2.99957968 1.121950002  9.710094e-01  5.629439e-03  6.947431e-03
      [388,]  2.89523134 0.531653158  1.445602e+00  3.736544e-03 -3.107307e-02
      [389,]  2.19256939 1.375472712  1.981283e+00  1.467698e-02 -2.983059e-02
      [390,]  1.37625030 0.115741799  1.781624e+00  2.188860e-03 -3.587464e-03
      [391,]  2.95680152 0.161251259  1.290742e+00  2.250117e-03  3.662836e-02
      [392,]  1.29890704 0.002198028 -2.869301e-01 -8.365604e-03 -2.557130e-02
      [393,]  2.86285974 1.219482131  4.945566e-01 -2.348013e-02 -4.820601e-02
      [394,]  2.72866045 0.850496149  3.151249e-01 -1.505425e-02 -4.970583e-02
      [395,]  1.59121234 0.389574041  1.912630e+00 -1.848556e-02  1.212139e-02
      [396,]  2.58016631 0.655314586  1.814498e+00  3.956056e-02  3.294325e-02
      [397,]  2.94205777 0.918608937  1.335451e+00 -3.476416e-02  1.258265e-02
      [398,]  1.93402355 1.785906083 -1.997821e+00  4.016556e-02 -1.569915e-04
      [399,]  2.57474209 1.674522376 -1.818335e+00 -3.392490e-02 -1.541384e-02
      [400,]  1.05185635 1.380196982  1.317842e+00  9.393090e-03  3.356151e-02

---

    Code
      mirror_scurves(n = 200, num_noise = 0)
    Output
                    [,1]        [,2]          [,3]
        [1,] -0.60305328 1.513970708  2.022991e-01
        [2,]  0.62713926 1.208574185 -1.778907e+00
        [3,]  0.81572976 1.887608428 -1.578433e+00
        [4,]  0.69697108 1.150619867  1.717099e+00
        [5,]  0.60261467 1.573963160 -2.019677e-01
        [6,] -0.44507101 0.979716226 -1.895495e+00
        [7,]  0.57640467 1.163536638 -1.817164e+00
        [8,]  0.17201300 1.938378378  1.985095e+00
        [9,]  0.38343120 1.020099449 -7.643056e-02
       [10,]  0.93752770 0.848186683  1.347911e+00
       [11,]  0.13160633 0.764158309 -1.991302e+00
       [12,] -0.99995713 0.376332991  1.009260e+00
       [13,] -0.18142756 0.008816799 -1.983404e+00
       [14,]  0.22952990 1.394612064 -1.973302e+00
       [15,]  0.84604713 0.784938101 -4.668919e-01
       [16,]  0.09747179 1.720718462 -1.995238e+00
       [17,] -0.90832309 1.718485748 -1.418269e+00
       [18,]  0.99994845 1.541052536 -9.898467e-01
       [19,]  0.16397421 0.056478953 -1.353537e-02
       [20,] -0.03664860 1.770926193  1.999328e+00
       [21,] -0.91647434 0.030757740 -1.400093e+00
       [22,]  0.32704897 0.182344446 -5.499261e-02
       [23,]  0.99658336 1.249083577 -9.174070e-01
       [24,] -0.78020526 0.386190894 -1.625524e+00
       [25,]  0.99330832 1.363312311  1.115493e+00
       [26,] -0.90521699 0.869135932  5.750503e-01
       [27,]  0.38519775 1.522131730 -1.922834e+00
       [28,] -0.91432722 1.713665196  5.950238e-01
       [29,]  0.99716079 1.405067837 -1.075302e+00
       [30,] -0.98707083 1.099669202  8.397153e-01
       [31,]  0.14130261 1.195785810 -1.989966e+00
       [32,]  0.01023024 1.506601181 -5.233028e-05
       [33,]  0.03108031 1.842954344 -1.999517e+00
       [34,]  0.20577602 0.732664418  1.978599e+00
       [35,]  0.22019148 1.188861799 -2.454333e-02
       [36,] -0.71940437 0.263696851  1.694592e+00
       [37,] -0.86615948 1.908860170 -1.499768e+00
       [38,] -0.04845746 0.062536585 -1.998825e+00
       [39,] -0.57631837 1.731913370 -1.817225e+00
       [40,]  0.86847313 0.184721717 -1.495736e+00
       [41,]  0.77004904 0.617012171 -1.637985e+00
       [42,]  0.33343090 1.149262027 -5.722546e-02
       [43,] -0.23629005 0.449465975  1.971683e+00
       [44,] -0.68220152 0.299356702  1.731164e+00
       [45,] -0.95498891 1.841817780  7.033585e-01
       [46,]  0.62106425 1.637170752  1.783760e+00
       [47,] -0.53279458 1.712715269  1.537554e-01
       [48,] -0.82867550 0.789636117 -1.559729e+00
       [49,] -0.18325302 0.212106486 -1.983066e+00
       [50,]  0.56241226 0.026690016  1.826857e+00
       [51,] -0.93469137 1.317467782  6.445397e-01
       [52,] -0.56261008 1.679368130  1.732776e-01
       [53,] -0.90383590 1.103674038  1.427879e+00
       [54,]  0.98290804 0.882114554 -1.184097e+00
       [55,]  0.74097758 1.408018451 -1.671530e+00
       [56,]  0.36943535 1.605804428  1.929256e+00
       [57,]  0.39760496 1.505051773 -8.244330e-02
       [58,] -0.77938044 0.238144463 -1.626551e+00
       [59,] -0.04941023 0.655557580  1.221431e-03
       [60,]  0.96979772 1.105913892 -1.243911e+00
       [61,]  0.21947737 0.349411472  1.975618e+00
       [62,] -0.86433001 0.223799259  1.502925e+00
       [63,] -0.57427022 1.686432461 -1.818666e+00
       [64,] -0.70959729 0.933845343 -1.704607e+00
       [65,] -0.35216428 1.772948366 -1.935938e+00
       [66,]  0.74178596 0.412970412  1.670637e+00
       [67,]  0.23517040 1.674829439 -2.804584e-02
       [68,]  0.30217205 0.108269950  1.953253e+00
       [69,] -0.35341923 0.784442851 -1.935465e+00
       [70,] -0.10836475 0.488445224  1.994111e+00
       [71,]  0.52185667 0.133368262 -1.853033e+00
       [72,] -0.99947468 1.400219185  1.032409e+00
       [73,]  0.25588755 1.141751539 -1.966707e+00
       [74,]  0.67888226 0.215630172 -1.734247e+00
       [75,] -0.60449802 0.661634644  1.796607e+00
       [76,]  0.35024395 1.526160114 -6.334149e-02
       [77,] -0.85701717 0.181376279  1.515288e+00
       [78,] -0.05408968 1.913479391  1.998536e+00
       [79,] -0.82539243 1.473665772  4.354406e-01
       [80,] -0.44085460 1.561290836  1.897579e+00
       [81,] -0.98380388 1.442687864 -1.179248e+00
       [82,]  0.22579555 0.916289135 -1.974175e+00
       [83,] -0.49866929 0.268285465  1.866792e+00
       [84,] -0.99842240 0.124680266  9.438511e-01
       [85,]  0.04188207 0.643452152 -8.774390e-04
       [86,]  0.48316765 1.817222137 -1.244721e-01
       [87,] -0.17354247 0.139966871  1.984826e+00
       [88,] -0.99983718 0.445710137  1.018044e+00
       [89,]  0.11385478 1.089697591 -6.502597e-03
       [90,] -0.99007755 1.026490032 -1.140522e+00
       [91,] -0.28553145 1.631998343 -1.958369e+00
       [92,]  0.87124357 0.449838156  1.490851e+00
       [93,] -0.55314547 0.090281535  1.669153e-01
       [94,] -0.37644329 0.843740203  7.356034e-02
       [95,] -0.57615891 1.378183716  1.826623e-01
       [96,] -0.25516330 1.667676521 -1.966898e+00
       [97,]  0.25954042 1.287141010  1.965732e+00
       [98,] -0.71421084 0.038504738 -1.699931e+00
       [99,]  0.32728025 0.823097409  1.944927e+00
      [100,] -0.22771033 1.176628315  1.973729e+00
      [101,]  0.98892558 0.087169163  1.148412e+00
      [102,]  0.13740612 0.268383017  1.990515e+00
      [103,] -0.66825185 1.178429219  2.560649e-01
      [104,]  0.71766781 0.329731511 -3.036144e-01
      [105,]  0.82743573 0.585485986  1.561560e+00
      [106,]  0.99801775 0.839144383 -1.062933e+00
      [107,] -0.92604068 1.833204129  1.377424e+00
      [108,] -0.14846675 1.498886698  1.108260e-02
      [109,]  0.65288376 0.089276489 -1.757458e+00
      [110,]  0.70168368 1.343095946  1.712489e+00
      [111,]  0.08841382 0.652325992 -1.996084e+00
      [112,] -0.33027119 1.672562846  5.611391e-02
      [113,]  0.47767040 0.139355525 -1.878539e+00
      [114,] -0.99957246 1.670055923  9.707613e-01
      [115,]  0.98090969 0.612632196 -8.055362e-01
      [116,] -0.97664288 0.611149286  1.214869e+00
      [117,]  0.68846276 0.618184003 -2.747283e-01
      [118,] -0.72495225 1.608546997 -1.688799e+00
      [119,]  0.77373903 1.768485096 -3.664955e-01
      [120,]  0.63885304 0.306805071 -2.306712e-01
      [121,] -0.62469761 1.087080927 -1.780867e+00
      [122,]  0.98549035 1.202922498 -8.302686e-01
      [123,] -0.82499731 0.215397033  1.565137e+00
      [124,] -0.96251995 0.964632392  1.271211e+00
      [125,]  0.74637783 0.911959185 -1.665522e+00
      [126,] -0.90787197 1.772126134  5.807525e-01
      [127,]  0.98724005 1.552860437 -8.407609e-01
      [128,]  0.20904880 1.463593576 -2.209479e-02
      [129,] -0.45119120 1.798002221  1.892427e+00
      [130,]  0.99372365 0.495635085  1.111863e+00
      [131,] -0.99813759 0.456622513 -1.061003e+00
      [132,]  0.97179822 0.188263731 -7.641861e-01
      [133,]  0.62545089 0.076697989 -2.197365e-01
      [134,] -0.27241987 0.520627713  1.962178e+00
      [135,] -0.12406825 0.431289490  1.992274e+00
      [136,]  0.66333124 0.135526460  1.748326e+00
      [137,] -0.59629006 0.983110494 -1.802769e+00
      [138,]  0.35260568 0.137395004 -6.422800e-02
      [139,] -0.98619576 0.729723424  8.344164e-01
      [140,]  0.99828244 0.519298313  1.058585e+00
      [141,]  0.33054103 0.475570150 -1.943792e+00
      [142,]  0.99403745 1.507568763  1.109039e+00
      [143,] -0.98362232 0.196633140  1.180242e+00
      [144,]  0.73760225 1.296403734 -3.247645e-01
      [145,]  0.12588889 1.291397314 -7.955653e-03
      [146,]  0.99573088 0.144485847 -1.092304e+00
      [147,]  0.25192547 0.410391557 -3.225336e-02
      [148,]  0.65465440 0.786490273  1.755928e+00
      [149,] -0.56613089 1.902732538  1.756846e-01
      [150,]  0.32620909 0.092574335  1.945298e+00
      [151,] -0.15933069 1.756885453 -1.987225e+00
      [152,] -0.70005081 0.324280748  2.859070e-01
      [153,] -0.80062016 1.834545954 -1.599172e+00
      [154,]  0.77184509 0.254943973  1.635811e+00
      [155,] -0.19859573 1.592531102 -1.980081e+00
      [156,] -0.82182138 0.042343645  1.569745e+00
      [157,]  0.04124236 0.190437324  1.999149e+00
      [158,]  0.35056544 1.414165185  1.936538e+00
      [159,] -0.70438416 0.806571780  1.709819e+00
      [160,] -0.87533129 1.008542863  1.483524e+00
      [161,]  0.65454671 0.170386605 -1.756022e+00
      [162,] -0.66704900 1.052196551 -1.745014e+00
      [163,] -0.99432448 1.240900111 -1.106390e+00
      [164,] -0.92847813 1.303706737  1.371387e+00
      [165,]  0.72078240 1.809160742 -1.693161e+00
      [166,] -0.38588962 0.187053455 -1.922545e+00
      [167,]  0.87965480 0.091577793  1.475613e+00
      [168,]  0.98589157 1.465671603  1.167385e+00
      [169,]  0.42507133 0.679776855  1.905160e+00
      [170,] -0.73021788 0.807740299  1.683214e+00
      [171,] -0.71074044 1.672903239  2.965456e-01
      [172,] -0.59182234 1.735012847  1.806068e+00
      [173,]  0.99279809 1.999640650 -1.119800e+00
      [174,] -0.49866305 1.900491086 -1.866796e+00
      [175,]  0.83135091 0.348129116  1.555748e+00
      [176,] -0.57784659 0.715315748  1.816145e+00
      [177,]  0.36799582 1.837193044  1.929827e+00
      [178,]  0.93986521 1.547892871 -6.584544e-01
      [179,]  0.41612813 0.418081269  1.909306e+00
      [180,]  0.99371155 1.881522425 -8.880297e-01
      [181,] -0.95980979 1.504400608 -1.280651e+00
      [182,] -0.47316161 0.935968087 -1.880976e+00
      [183,] -0.73481232 1.668815269  3.217295e-01
      [184,] -0.43057850 1.201894378  1.902553e+00
      [185,]  0.44758598 0.389511471 -1.894241e+00
      [186,]  0.48474422 1.232119335 -1.253440e-01
      [187,] -0.09996510 0.241577500  1.994991e+00
      [188,]  0.19606677 1.631623207  1.980591e+00
      [189,] -0.32741044 0.999971105  5.511778e-02
      [190,] -0.96831227 0.043859514  7.502574e-01
      [191,]  0.25608442 1.357312052  1.966654e+00
      [192,]  0.44869639 0.834209821 -1.063157e-01
      [193,] -0.99517106 1.082844731 -1.098156e+00
      [194,]  0.33642894 1.575607107  1.941709e+00
      [195,]  0.57617845 1.935622364 -1.817324e+00
      [196,] -0.43252777 1.144975617 -1.901621e+00
      [197,] -0.66345348 1.477405285  2.517825e-01
      [198,] -0.82425071 1.557662486  1.566225e+00
      [199,]  0.79034955 0.528842322  1.612656e+00
      [200,] -0.98943256 0.818520688 -1.144994e+00
      [201,]  2.60305328 1.513970708  2.022991e-01
      [202,]  1.37286074 1.208574185 -1.778907e+00
      [203,]  1.18427024 1.887608428 -1.578433e+00
      [204,]  1.30302892 1.150619867  1.717099e+00
      [205,]  1.39738533 1.573963160 -2.019677e-01
      [206,]  2.44507101 0.979716226 -1.895495e+00
      [207,]  1.42359533 1.163536638 -1.817164e+00
      [208,]  1.82798700 1.938378378  1.985095e+00
      [209,]  1.61656880 1.020099449 -7.643056e-02
      [210,]  1.06247230 0.848186683  1.347911e+00
      [211,]  1.86839367 0.764158309 -1.991302e+00
      [212,]  2.99995713 0.376332991  1.009260e+00
      [213,]  2.18142756 0.008816799 -1.983404e+00
      [214,]  1.77047010 1.394612064 -1.973302e+00
      [215,]  1.15395287 0.784938101 -4.668919e-01
      [216,]  1.90252821 1.720718462 -1.995238e+00
      [217,]  2.90832309 1.718485748 -1.418269e+00
      [218,]  1.00005155 1.541052536 -9.898467e-01
      [219,]  1.83602579 0.056478953 -1.353537e-02
      [220,]  2.03664860 1.770926193  1.999328e+00
      [221,]  2.91647434 0.030757740 -1.400093e+00
      [222,]  1.67295103 0.182344446 -5.499261e-02
      [223,]  1.00341664 1.249083577 -9.174070e-01
      [224,]  2.78020526 0.386190894 -1.625524e+00
      [225,]  1.00669168 1.363312311  1.115493e+00
      [226,]  2.90521699 0.869135932  5.750503e-01
      [227,]  1.61480225 1.522131730 -1.922834e+00
      [228,]  2.91432722 1.713665196  5.950238e-01
      [229,]  1.00283921 1.405067837 -1.075302e+00
      [230,]  2.98707083 1.099669202  8.397153e-01
      [231,]  1.85869739 1.195785810 -1.989966e+00
      [232,]  1.98976976 1.506601181 -5.233028e-05
      [233,]  1.96891969 1.842954344 -1.999517e+00
      [234,]  1.79422398 0.732664418  1.978599e+00
      [235,]  1.77980852 1.188861799 -2.454333e-02
      [236,]  2.71940437 0.263696851  1.694592e+00
      [237,]  2.86615948 1.908860170 -1.499768e+00
      [238,]  2.04845746 0.062536585 -1.998825e+00
      [239,]  2.57631837 1.731913370 -1.817225e+00
      [240,]  1.13152687 0.184721717 -1.495736e+00
      [241,]  1.22995096 0.617012171 -1.637985e+00
      [242,]  1.66656910 1.149262027 -5.722546e-02
      [243,]  2.23629005 0.449465975  1.971683e+00
      [244,]  2.68220152 0.299356702  1.731164e+00
      [245,]  2.95498891 1.841817780  7.033585e-01
      [246,]  1.37893575 1.637170752  1.783760e+00
      [247,]  2.53279458 1.712715269  1.537554e-01
      [248,]  2.82867550 0.789636117 -1.559729e+00
      [249,]  2.18325302 0.212106486 -1.983066e+00
      [250,]  1.43758774 0.026690016  1.826857e+00
      [251,]  2.93469137 1.317467782  6.445397e-01
      [252,]  2.56261008 1.679368130  1.732776e-01
      [253,]  2.90383590 1.103674038  1.427879e+00
      [254,]  1.01709196 0.882114554 -1.184097e+00
      [255,]  1.25902242 1.408018451 -1.671530e+00
      [256,]  1.63056465 1.605804428  1.929256e+00
      [257,]  1.60239504 1.505051773 -8.244330e-02
      [258,]  2.77938044 0.238144463 -1.626551e+00
      [259,]  2.04941023 0.655557580  1.221431e-03
      [260,]  1.03020228 1.105913892 -1.243911e+00
      [261,]  1.78052263 0.349411472  1.975618e+00
      [262,]  2.86433001 0.223799259  1.502925e+00
      [263,]  2.57427022 1.686432461 -1.818666e+00
      [264,]  2.70959729 0.933845343 -1.704607e+00
      [265,]  2.35216428 1.772948366 -1.935938e+00
      [266,]  1.25821404 0.412970412  1.670637e+00
      [267,]  1.76482960 1.674829439 -2.804584e-02
      [268,]  1.69782795 0.108269950  1.953253e+00
      [269,]  2.35341923 0.784442851 -1.935465e+00
      [270,]  2.10836475 0.488445224  1.994111e+00
      [271,]  1.47814333 0.133368262 -1.853033e+00
      [272,]  2.99947468 1.400219185  1.032409e+00
      [273,]  1.74411245 1.141751539 -1.966707e+00
      [274,]  1.32111774 0.215630172 -1.734247e+00
      [275,]  2.60449802 0.661634644  1.796607e+00
      [276,]  1.64975605 1.526160114 -6.334149e-02
      [277,]  2.85701717 0.181376279  1.515288e+00
      [278,]  2.05408968 1.913479391  1.998536e+00
      [279,]  2.82539243 1.473665772  4.354406e-01
      [280,]  2.44085460 1.561290836  1.897579e+00
      [281,]  2.98380388 1.442687864 -1.179248e+00
      [282,]  1.77420445 0.916289135 -1.974175e+00
      [283,]  2.49866929 0.268285465  1.866792e+00
      [284,]  2.99842240 0.124680266  9.438511e-01
      [285,]  1.95811793 0.643452152 -8.774390e-04
      [286,]  1.51683235 1.817222137 -1.244721e-01
      [287,]  2.17354247 0.139966871  1.984826e+00
      [288,]  2.99983718 0.445710137  1.018044e+00
      [289,]  1.88614522 1.089697591 -6.502597e-03
      [290,]  2.99007755 1.026490032 -1.140522e+00
      [291,]  2.28553145 1.631998343 -1.958369e+00
      [292,]  1.12875643 0.449838156  1.490851e+00
      [293,]  2.55314547 0.090281535  1.669153e-01
      [294,]  2.37644329 0.843740203  7.356034e-02
      [295,]  2.57615891 1.378183716  1.826623e-01
      [296,]  2.25516330 1.667676521 -1.966898e+00
      [297,]  1.74045958 1.287141010  1.965732e+00
      [298,]  2.71421084 0.038504738 -1.699931e+00
      [299,]  1.67271975 0.823097409  1.944927e+00
      [300,]  2.22771033 1.176628315  1.973729e+00
      [301,]  1.01107442 0.087169163  1.148412e+00
      [302,]  1.86259388 0.268383017  1.990515e+00
      [303,]  2.66825185 1.178429219  2.560649e-01
      [304,]  1.28233219 0.329731511 -3.036144e-01
      [305,]  1.17256427 0.585485986  1.561560e+00
      [306,]  1.00198225 0.839144383 -1.062933e+00
      [307,]  2.92604068 1.833204129  1.377424e+00
      [308,]  2.14846675 1.498886698  1.108260e-02
      [309,]  1.34711624 0.089276489 -1.757458e+00
      [310,]  1.29831632 1.343095946  1.712489e+00
      [311,]  1.91158618 0.652325992 -1.996084e+00
      [312,]  2.33027119 1.672562846  5.611391e-02
      [313,]  1.52232960 0.139355525 -1.878539e+00
      [314,]  2.99957246 1.670055923  9.707613e-01
      [315,]  1.01909031 0.612632196 -8.055362e-01
      [316,]  2.97664288 0.611149286  1.214869e+00
      [317,]  1.31153724 0.618184003 -2.747283e-01
      [318,]  2.72495225 1.608546997 -1.688799e+00
      [319,]  1.22626097 1.768485096 -3.664955e-01
      [320,]  1.36114696 0.306805071 -2.306712e-01
      [321,]  2.62469761 1.087080927 -1.780867e+00
      [322,]  1.01450965 1.202922498 -8.302686e-01
      [323,]  2.82499731 0.215397033  1.565137e+00
      [324,]  2.96251995 0.964632392  1.271211e+00
      [325,]  1.25362217 0.911959185 -1.665522e+00
      [326,]  2.90787197 1.772126134  5.807525e-01
      [327,]  1.01275995 1.552860437 -8.407609e-01
      [328,]  1.79095120 1.463593576 -2.209479e-02
      [329,]  2.45119120 1.798002221  1.892427e+00
      [330,]  1.00627635 0.495635085  1.111863e+00
      [331,]  2.99813759 0.456622513 -1.061003e+00
      [332,]  1.02820178 0.188263731 -7.641861e-01
      [333,]  1.37454911 0.076697989 -2.197365e-01
      [334,]  2.27241987 0.520627713  1.962178e+00
      [335,]  2.12406825 0.431289490  1.992274e+00
      [336,]  1.33666876 0.135526460  1.748326e+00
      [337,]  2.59629006 0.983110494 -1.802769e+00
      [338,]  1.64739432 0.137395004 -6.422800e-02
      [339,]  2.98619576 0.729723424  8.344164e-01
      [340,]  1.00171756 0.519298313  1.058585e+00
      [341,]  1.66945897 0.475570150 -1.943792e+00
      [342,]  1.00596255 1.507568763  1.109039e+00
      [343,]  2.98362232 0.196633140  1.180242e+00
      [344,]  1.26239775 1.296403734 -3.247645e-01
      [345,]  1.87411111 1.291397314 -7.955653e-03
      [346,]  1.00426912 0.144485847 -1.092304e+00
      [347,]  1.74807453 0.410391557 -3.225336e-02
      [348,]  1.34534560 0.786490273  1.755928e+00
      [349,]  2.56613089 1.902732538  1.756846e-01
      [350,]  1.67379091 0.092574335  1.945298e+00
      [351,]  2.15933069 1.756885453 -1.987225e+00
      [352,]  2.70005081 0.324280748  2.859070e-01
      [353,]  2.80062016 1.834545954 -1.599172e+00
      [354,]  1.22815491 0.254943973  1.635811e+00
      [355,]  2.19859573 1.592531102 -1.980081e+00
      [356,]  2.82182138 0.042343645  1.569745e+00
      [357,]  1.95875764 0.190437324  1.999149e+00
      [358,]  1.64943456 1.414165185  1.936538e+00
      [359,]  2.70438416 0.806571780  1.709819e+00
      [360,]  2.87533129 1.008542863  1.483524e+00
      [361,]  1.34545329 0.170386605 -1.756022e+00
      [362,]  2.66704900 1.052196551 -1.745014e+00
      [363,]  2.99432448 1.240900111 -1.106390e+00
      [364,]  2.92847813 1.303706737  1.371387e+00
      [365,]  1.27921760 1.809160742 -1.693161e+00
      [366,]  2.38588962 0.187053455 -1.922545e+00
      [367,]  1.12034520 0.091577793  1.475613e+00
      [368,]  1.01410843 1.465671603  1.167385e+00
      [369,]  1.57492867 0.679776855  1.905160e+00
      [370,]  2.73021788 0.807740299  1.683214e+00
      [371,]  2.71074044 1.672903239  2.965456e-01
      [372,]  2.59182234 1.735012847  1.806068e+00
      [373,]  1.00720191 1.999640650 -1.119800e+00
      [374,]  2.49866305 1.900491086 -1.866796e+00
      [375,]  1.16864909 0.348129116  1.555748e+00
      [376,]  2.57784659 0.715315748  1.816145e+00
      [377,]  1.63200418 1.837193044  1.929827e+00
      [378,]  1.06013479 1.547892871 -6.584544e-01
      [379,]  1.58387187 0.418081269  1.909306e+00
      [380,]  1.00628845 1.881522425 -8.880297e-01
      [381,]  2.95980979 1.504400608 -1.280651e+00
      [382,]  2.47316161 0.935968087 -1.880976e+00
      [383,]  2.73481232 1.668815269  3.217295e-01
      [384,]  2.43057850 1.201894378  1.902553e+00
      [385,]  1.55241402 0.389511471 -1.894241e+00
      [386,]  1.51525578 1.232119335 -1.253440e-01
      [387,]  2.09996510 0.241577500  1.994991e+00
      [388,]  1.80393323 1.631623207  1.980591e+00
      [389,]  2.32741044 0.999971105  5.511778e-02
      [390,]  2.96831227 0.043859514  7.502574e-01
      [391,]  1.74391558 1.357312052  1.966654e+00
      [392,]  1.55130361 0.834209821 -1.063157e-01
      [393,]  2.99517106 1.082844731 -1.098156e+00
      [394,]  1.66357106 1.575607107  1.941709e+00
      [395,]  1.42382155 1.935622364 -1.817324e+00
      [396,]  2.43252777 1.144975617 -1.901621e+00
      [397,]  2.66345348 1.477405285  2.517825e-01
      [398,]  2.82425071 1.557662486  1.566225e+00
      [399,]  1.20965045 0.528842322  1.612656e+00
      [400,]  2.98943256 0.818520688 -1.144994e+00

# two_scurve_hole() works

    Code
      two_scurve_hole(n = 200, num_noise = 2, min_n = -0.05, max_n = 0.05)
    Output
                      [,1]       [,2]         [,3]          [,4]          [,5]
        [1,] -6.340938e-01 1.98822308 -1.773256117  0.0468112729  1.458899e-02
        [2,]  6.097906e-01 1.19084207 -0.207437470 -0.0124962581 -2.865623e-02
        [3,] -7.728216e-01 1.19084792  1.634623293 -0.0390363060 -2.609781e-02
        [4,] -9.759881e-01 1.11329627  0.782176312  0.0121142437 -4.110739e-02
        [5,]  6.016594e-01 1.72328295  1.798752727 -0.0077770323 -4.965122e-02
        [6,]  2.339115e-01 1.27587685 -1.972257884 -0.0433116644 -3.251858e-02
        [7,] -5.921304e-01 0.54464748 -1.805842141  0.0096181576  2.281042e-02
        [8,] -3.189286e-01 0.02749521  0.052221271  0.0404465381  4.688578e-02
        [9,]  9.830432e-01 1.74959711 -0.816625894 -0.0497450735 -3.585914e-02
       [10,]  5.274602e-01 1.12029180 -0.150420279 -0.0152653055  4.046627e-02
       [11,] -5.457515e-01 0.75524998  0.162052931  0.0365711479 -1.089824e-02
       [12,] -7.623820e-01 1.30264013  0.352872777  0.0159191196 -3.413554e-02
       [13,]  8.301811e-01 1.13949024  1.557493862 -0.0314435686 -3.089505e-02
       [14,] -5.256134e-02 0.76038637  1.998617697  0.0449404774  4.024651e-02
       [15,]  9.904409e-01 0.14966866 -0.862062479 -0.0289388946 -2.819042e-02
       [16,]  8.000892e-01 1.39771197 -0.400118980  0.0135954321 -3.771454e-02
       [17,] -9.934217e-01 0.31691738  1.114513430  0.0023689911 -4.630252e-03
       [18,] -2.905858e-01 0.72196182  0.043151066 -0.0305722723 -4.492376e-02
       [19,] -9.999073e-01 0.91255936 -1.013616793 -0.0184369768  1.361151e-02
       [20,] -7.635090e-01 1.72522245 -1.645797206  0.0459533107 -2.761497e-02
       [21,]  9.716844e-01 1.18282396 -0.763717301  0.0348061180  7.016805e-03
       [22,] -5.816179e-01 0.24975524 -1.813462130  0.0042005939  7.230506e-03
       [23,] -8.179654e-02 1.41087269  0.003350952 -0.0309299566  1.352021e-02
       [24,]  9.581082e-01 0.80659040  1.286406640 -0.0233263229 -4.457019e-02
       [25,]  8.100239e-01 1.14849298 -0.413603085  0.0388561925 -1.310034e-03
       [26,] -6.737153e-01 1.79045356 -1.738990979  0.0360052565 -9.513795e-03
       [27,] -2.684727e-01 0.71967963  0.036712704 -0.0055477833  3.003845e-02
       [28,]  8.118181e-01 0.99730093  1.583910379  0.0107978261  6.382821e-03
       [29,] -9.649511e-01 0.20814043  1.262429739  0.0296354921 -2.444980e-02
       [30,]  9.961515e-01 1.84362445 -0.912351785  0.0099678486 -2.677100e-02
       [31,]  9.846774e-01 1.38412160 -0.825614148 -0.0064570792  4.704865e-02
       [32,]  1.511646e-01 0.34007230  1.988508607 -0.0309545504 -2.961780e-02
       [33,] -9.140028e-01 1.88360282  0.594292048 -0.0250889844  3.370171e-02
       [34,]  6.120882e-01 0.28147940  1.790789497  0.0319340720  1.654683e-02
       [35,]  9.513221e-01 1.43101242 -0.691801670 -0.0354034658  1.833225e-02
       [36,]  9.929945e-01 1.46228171  1.118160592 -0.0428596250 -3.866709e-03
       [37,]  9.969284e-01 1.58093975 -0.921681082 -0.0344285349 -4.063287e-02
       [38,] -3.983858e-01 0.30680197  1.917217921  0.0341629610  3.401228e-02
       [39,] -2.975532e-02 1.49081430 -1.999557212 -0.0454066350  4.455656e-03
       [40,]  1.325103e-01 0.12353514  1.991181633  0.0122605025  2.337754e-02
       [41,] -6.575670e-01 0.61925959 -1.753396031  0.0022526822  6.600727e-03
       [42,] -6.617900e-01 1.31466000  1.749689302  0.0048651400  7.430371e-03
       [43,]  6.864664e-02 0.72770988  1.997641037  0.0371045142 -4.363294e-02
       [44,]  1.806678e-01 1.42363410 -0.016455828  0.0191890407  4.190935e-02
       [45,] -5.366348e-01 1.59305915  0.156185395  0.0169471913  3.425425e-02
       [46,] -4.671789e-01 1.77179572  0.115837174  0.0234745285 -3.860183e-02
       [47,]  6.459860e-01 1.22870479  1.763349243 -0.0464605047 -7.435258e-03
       [48,]  7.240349e-01 0.21064063 -0.310236677 -0.0140471952  4.040416e-02
       [49,]  9.583847e-01 1.75805706 -0.714520008 -0.0027744060 -4.276738e-02
       [50,]  6.978079e-01 0.82678269 -0.283715084  0.0219781587  2.994692e-02
       [51,]  9.794991e-01 0.20433490 -0.798551679  0.0014598926 -4.456985e-02
       [52,] -7.671256e-01 1.77936902 -1.641496947 -0.0326802443 -1.082111e-02
       [53,]  4.024456e-01 1.21567890 -0.084556095 -0.0069526496 -1.241861e-02
       [54,] -1.811317e-01 0.54019666  1.983458848  0.0490568970 -1.631652e-02
       [55,]  4.869975e-01 1.06403200 -0.126596628 -0.0374291364  3.040836e-03
       [56,] -7.173675e-01 1.37783345 -1.696694971  0.0401866821 -4.027878e-02
       [57,] -2.166163e-01 1.81234607  1.976256822  0.0378239532 -9.351035e-03
       [58,] -4.575885e-01 0.56344260 -1.889164089 -0.0138014233 -1.717753e-02
       [59,] -5.504737e-01 1.35785120 -1.834852511  0.0141808003 -7.135615e-03
       [60,] -9.941999e-01 0.16205910 -1.107547980  0.0161106778 -3.335375e-02
       [61,] -6.677178e-01 1.57904019  0.255585528  0.0456993452  3.431115e-03
       [62,]  1.902219e-01 0.63538332  1.981741126 -0.0172811388  1.866506e-02
       [63,] -1.744108e-01 0.15865368  1.984672981 -0.0222209299 -2.138503e-02
       [64,]  1.235226e-01 1.43083296  1.992341754  0.0488013647  4.667769e-02
       [65,]  9.721237e-01 1.06575937 -0.765531495  0.0074586672 -3.253958e-02
       [66,]  9.485830e-01 0.72765404 -0.683471419 -0.0334256714  2.804652e-02
       [67,]  7.209583e-01 1.25721234 -1.692978403 -0.0355602939  9.009592e-03
       [68,] -8.577556e-01 0.18626929 -1.514057690  0.0466993265 -2.988130e-02
       [69,]  8.448227e-01 1.11313583 -0.464953655  0.0212277140 -7.058739e-03
       [70,]  8.367563e-01 0.58639582  1.547575430  0.0287382015  1.708714e-02
       [71,] -9.997792e-01 0.41272092  0.978985596 -0.0488130579  2.566097e-02
       [72,]  8.976237e-01 0.80107257 -1.440762701 -0.0254148313  3.205063e-02
       [73,] -7.234225e-01 0.56646323  0.309594394 -0.0449607738  2.594132e-02
       [74,]  6.905378e-01 0.74656543 -1.723296291 -0.0329215669 -3.803132e-02
       [75,] -7.613472e-02 0.72417720 -1.997097540  0.0040266522 -4.379304e-02
       [76,] -6.147300e-01 1.40312127 -1.788737612  0.0142846406  1.434154e-02
       [77,]  9.260928e-01 1.94893263 -1.377295857 -0.0329637585  4.449161e-03
       [78,]  6.146255e-01 0.93106444  1.788819052  0.0494644662  7.503827e-03
       [79,] -2.211984e-01 1.90264380  1.975228824 -0.0360697758  4.656778e-02
       [80,] -3.833220e-01 0.10094962  1.923614773  0.0202892990  2.710841e-02
       [81,] -7.944128e-01 0.39771306  1.607378285  0.0366330932 -2.600811e-02
       [82,]  4.969114e-01 0.96923935  1.867801255 -0.0299145314  3.284313e-02
       [83,]  5.437830e-01 0.37215268  1.839225885  0.0356086889  4.479017e-02
       [84,]  7.172423e-01 0.71440046 -1.696823892  0.0307684459  3.177405e-02
       [85,] -9.646071e-01 1.68472647 -1.263691396  0.0226531942 -1.214109e-02
       [86,] -2.154061e-01 1.87538966 -1.976524558  0.0148863554  2.545728e-03
       [87,] -5.684331e-01 0.67281952 -1.822729471 -0.0034758566  3.369623e-02
       [88,] -9.545236e-02 0.56865985  1.995433999  0.0215064450  3.942831e-02
       [89,]  5.679333e-01 0.37445470  1.823074601  0.0319374689 -1.072001e-02
       [90,]  9.723585e-01 0.19040564 -0.766506968 -0.0371603101  4.184796e-02
       [91,]  3.950040e-01 0.60406527 -1.918679388  0.0498017874  4.625760e-02
       [92,]  2.412102e-01 1.16486948 -0.029527114  0.0127720742  2.384936e-02
       [93,] -6.168590e-01 0.77911405  0.212926340  0.0058777411  2.029594e-02
       [94,] -3.635411e-01 0.82676218  0.068421859  0.0257612543  3.089043e-05
       [95,] -2.851573e-01 0.24396778 -1.958480737  0.0273422876  2.164460e-02
       [96,] -1.764828e-01 0.46467497  1.984303722 -0.0353921735 -7.280862e-03
       [97,]  9.385423e-01 0.59407428 -0.654835709  0.0180608628  5.159603e-03
       [98,] -9.947675e-01 1.65265585  0.897835108 -0.0044484145 -4.571919e-02
       [99,]  6.384092e-01 1.79659842 -1.769697155 -0.0471473908 -4.371184e-02
      [100,]  4.819163e-01 0.06863880  1.876217272 -0.0179879901  8.465952e-03
      [101,]  3.659062e-01 2.98822308 -0.773256117  0.0397026339 -9.797570e-03
      [102,]  1.609791e+00 2.19084207  0.792562530 -0.0290763175  2.422641e-02
      [103,]  2.271784e-01 2.19084792  2.634623293 -0.0422360181 -3.277202e-02
      [104,]  2.401186e-02 2.11329627  1.782176312  0.0214310022  9.997107e-03
      [105,]  1.601659e+00 2.72328295  2.798752727  0.0499433291  3.069320e-02
      [106,]  1.233912e+00 2.27587685 -0.972257884  0.0356851794 -1.476614e-02
      [107,]  4.078696e-01 1.54464748 -0.805842141 -0.0015637302  1.839283e-02
      [108,]  6.810714e-01 1.02749521  1.052221271  0.0123396746 -2.645821e-02
      [109,]  1.983043e+00 2.74959711  0.183374106  0.0284339315 -1.278195e-02
      [110,]  1.527460e+00 2.12029180  0.849579721  0.0350829806  4.227686e-02
      [111,]  4.542485e-01 1.75524998  1.162052931  0.0353439124  9.606105e-03
      [112,]  2.376180e-01 2.30264013  1.352872777 -0.0423142502  2.830282e-02
      [113,]  1.830181e+00 2.13949024  2.557493862  0.0051962465  4.181241e-02
      [114,]  9.474387e-01 1.76038637  2.998617697  0.0389469245 -1.311135e-02
      [115,]  1.990441e+00 1.14966866  0.137937521  0.0086575911 -1.880957e-02
      [116,]  1.800089e+00 2.39771197  0.599881020 -0.0232040592 -1.712295e-02
      [117,]  6.578300e-03 1.31691738  2.114513430  0.0245691278 -7.884755e-03
      [118,]  7.094142e-01 1.72196182  1.043151066  0.0315889175 -4.200629e-02
      [119,]  9.271282e-05 1.91255936 -0.013616793 -0.0227344875 -2.877043e-02
      [120,]  2.364910e-01 2.72522245 -0.645797206  0.0366494890 -3.228527e-02
      [121,]  1.971684e+00 2.18282396  0.236282699 -0.0157848667 -2.788319e-02
      [122,]  4.183821e-01 1.24975524 -0.813462130 -0.0070135517  1.741983e-02
      [123,]  9.182035e-01 2.41087269  1.003350952 -0.0208199039 -5.182130e-03
      [124,]  1.958108e+00 1.80659040  2.286406640  0.0189224581  2.974713e-02
      [125,]  1.810024e+00 2.14849298  0.586396915 -0.0338216087 -2.027644e-02
      [126,]  3.262847e-01 2.79045356 -0.738990979  0.0460992394 -6.945097e-03
      [127,]  7.315273e-01 1.71967963  1.036712704 -0.0447378346  2.858230e-03
      [128,]  1.811818e+00 1.99730093  2.583910379 -0.0272497393 -4.814338e-02
      [129,]  3.504890e-02 1.20814043  2.262429739  0.0160971409  1.638557e-02
      [130,]  1.996151e+00 2.84362445  0.087648215 -0.0464448324  4.239687e-02
      [131,]  1.984677e+00 2.38412160  0.174385852 -0.0179349351 -2.032662e-02
      [132,]  1.151165e+00 1.34007230  2.988508607  0.0207382537 -4.524067e-03
      [133,]  8.599723e-02 2.88360282  1.594292048 -0.0037443788 -1.712918e-02
      [134,]  1.612088e+00 1.28147940  2.790789497  0.0118583800 -4.000003e-02
      [135,]  1.951322e+00 2.43101242  0.308198330 -0.0063740385  3.129462e-02
      [136,]  1.992994e+00 2.46228171  2.118160592  0.0297865495  1.696542e-02
      [137,]  1.996928e+00 2.58093975  0.078318918  0.0433482581  2.599024e-02
      [138,]  6.016142e-01 1.30680197  2.917217921  0.0163532625 -2.685868e-02
      [139,]  9.702447e-01 2.49081430 -0.999557212 -0.0359919606 -3.175927e-02
      [140,]  1.132510e+00 1.12353514  2.991181633  0.0370901504  2.017552e-02
      [141,]  3.424330e-01 1.61925959 -0.753396031  0.0496382012 -1.430562e-02
      [142,]  3.382100e-01 2.31466000  2.749689302 -0.0114451926  4.388218e-02
      [143,]  1.068647e+00 1.72770988  2.997641037  0.0157686300 -4.704672e-02
      [144,]  1.180668e+00 2.42363410  0.983544172  0.0482725061  4.432870e-03
      [145,]  4.633652e-01 2.59305915  1.156185395 -0.0417446218  3.661782e-02
      [146,]  5.328211e-01 2.77179572  1.115837174 -0.0490760001 -8.528756e-03
      [147,]  1.645986e+00 2.22870479  2.763349243  0.0143416769  7.837044e-03
      [148,]  1.724035e+00 1.21064063  0.689763323  0.0389693632  3.644674e-02
      [149,]  1.958385e+00 2.75805706  0.285479992  0.0050521928 -3.336327e-02
      [150,]  1.697808e+00 1.82678269  0.716284916  0.0338490285  1.907975e-02
      [151,]  1.979499e+00 1.20433490  0.201448321 -0.0007207744  1.471168e-03
      [152,]  2.328744e-01 2.77936902 -0.641496947 -0.0358561296  1.342903e-02
      [153,]  1.402446e+00 2.21567890  0.915443905  0.0343432767 -3.520064e-02
      [154,]  8.188683e-01 1.54019666  2.983458848 -0.0380912595  2.381260e-02
      [155,]  1.486997e+00 2.06403200  0.873403372  0.0017651984  2.661871e-02
      [156,]  2.826325e-01 2.37783345 -0.696694971 -0.0271230818 -3.555762e-02
      [157,]  7.833837e-01 2.81234607  2.976256822  0.0153674109 -3.595247e-02
      [158,]  5.424115e-01 1.56344260 -0.889164089  0.0435791666  1.364102e-02
      [159,]  4.495263e-01 2.35785120 -0.834852511  0.0007038843 -4.875386e-02
      [160,]  5.800105e-03 1.16205910 -0.107547980  0.0042624283 -2.493871e-02
      [161,]  3.322822e-01 2.57904019  1.255585528 -0.0307058573  4.896922e-03
      [162,]  1.190222e+00 1.63538332  2.981741126  0.0172181919  3.970057e-02
      [163,]  8.255892e-01 1.15865368  2.984672981 -0.0344564827 -8.724967e-03
      [164,]  1.123523e+00 2.43083296  2.992341754  0.0145525717 -1.597159e-02
      [165,]  1.972124e+00 2.06575937  0.234468505 -0.0024064121  2.019766e-02
      [166,]  1.948583e+00 1.72765404  0.316528581 -0.0470545179 -9.139048e-03
      [167,]  1.720958e+00 2.25721234 -0.692978403  0.0429631366 -3.028368e-02
      [168,]  1.422444e-01 1.18626929 -0.514057690 -0.0314480813 -1.788580e-02
      [169,]  1.844823e+00 2.11313583  0.535046345  0.0469257004  4.290069e-02
      [170,]  1.836756e+00 1.58639582  2.547575430 -0.0067218661  2.202454e-02
      [171,]  2.208270e-04 1.41272092  1.978985596  0.0365070718 -6.666061e-03
      [172,]  1.897624e+00 1.80107257 -0.440762701 -0.0148092618 -4.398104e-02
      [173,]  2.765775e-01 1.56646323  1.309594394  0.0288158743 -2.984306e-02
      [174,]  1.690538e+00 1.74656543 -0.723296291  0.0393909458 -4.668091e-03
      [175,]  9.238653e-01 1.72417720 -0.997097540  0.0436995254  1.147877e-02
      [176,]  3.852700e-01 2.40312127 -0.788737612  0.0465217978  2.931105e-02
      [177,]  1.926093e+00 2.94893263 -0.377295857  0.0291392233  3.496157e-02
      [178,]  1.614625e+00 1.93106444  2.788819052 -0.0114881480 -5.097572e-04
      [179,]  7.788016e-01 2.90264380  2.975228824  0.0194828836  1.107564e-02
      [180,]  6.166780e-01 1.10094962  2.923614773  0.0485348954 -3.444004e-02
      [181,]  2.055872e-01 1.39771306  2.607378285  0.0097199444 -1.721028e-03
      [182,]  1.496911e+00 1.96923935  2.867801255  0.0044783109 -5.106072e-03
      [183,]  1.543783e+00 1.37215268  2.839225885 -0.0366461525  9.471303e-03
      [184,]  1.717242e+00 1.71440046 -0.696823892  0.0395055116 -2.284583e-02
      [185,]  3.539291e-02 2.68472647 -0.263691396  0.0053874930  3.711272e-02
      [186,]  7.845939e-01 2.87538966 -0.976524558 -0.0058034629 -4.431580e-02
      [187,]  4.315669e-01 1.67281952 -0.822729471 -0.0060975001 -1.383906e-02
      [188,]  9.045476e-01 1.56865985  2.995433999  0.0234173421  3.990231e-02
      [189,]  1.567933e+00 1.37445470  2.823074601 -0.0187736356 -1.393104e-02
      [190,]  1.972358e+00 1.19040564  0.233493032  0.0442129100  4.668946e-03
      [191,]  1.395004e+00 1.60406527 -0.918679388  0.0419374371 -1.337010e-02
      [192,]  1.241210e+00 2.16486948  0.970472886  0.0498900986  3.080920e-02
      [193,]  3.831410e-01 1.77911405  1.212926340 -0.0109741065 -1.190440e-02
      [194,]  6.364589e-01 1.82676218  1.068421859  0.0074751925 -2.176235e-02
      [195,]  7.148427e-01 1.24396778 -0.958480737  0.0305212979 -3.808644e-03
      [196,]  8.235172e-01 1.46467497  2.984303722  0.0172342707  2.022534e-02
      [197,]  1.938542e+00 1.59407428  0.345164291  0.0040695532  3.642897e-03
      [198,]  5.232522e-03 2.65265585  1.897835108 -0.0392953042 -5.561239e-03
      [199,]  1.638409e+00 2.79659842 -0.769697155 -0.0337261188 -2.585751e-02
      [200,]  1.481916e+00 1.06863880  2.876217272 -0.0190098491  1.580620e-02

---

    Code
      two_scurve_hole(n = 200, num_noise = 0)
    Output
                      [,1]       [,2]         [,3]
        [1,] -9.113560e-01 0.41455600  0.588380885
        [2,]  7.471711e-01 0.18144704 -1.664631734
        [3,]  3.321384e-01 0.39028557  1.943230673
        [4,]  9.164647e-01 0.33858666 -0.599884459
        [5,]  9.085635e-01 0.25012305  1.417746870
        [6,] -8.448753e-01 1.68225335  0.465036694
        [7,] -3.635202e-01 1.64102452 -1.931586324
        [8,] -9.412779e-01 0.22843599 -1.337632809
        [9,] -1.612378e-01 1.53523036 -1.986915589
       [10,]  9.942166e-01 0.59883851  1.107393291
       [11,]  9.696150e-01 1.79271577  1.244635852
       [12,]  8.327212e-01 1.89289195 -0.446307413
       [13,] -9.134861e-01 0.34809208 -1.406869920
       [14,]  9.821089e-01 0.13684835 -0.811686341
       [15,] -9.903074e-01 1.86469817  0.861106804
       [16,] -7.974577e-01 1.28970960  0.396625133
       [17,] -1.957510e-01 0.55654002  0.019346372
       [18,] -9.999824e-01 1.20541273  1.005938738
       [19,]  8.373990e-01 0.10063581 -0.453407984
       [20,] -6.596125e-01 0.46881681  1.751605891
       [21,] -9.640613e-01 1.16108832  1.265679941
       [22,] -3.305954e-01 1.87847471  1.943772574
       [23,] -8.654708e-01 1.47190500  0.499040672
       [24,]  9.864115e-01 1.21847799 -0.835706455
       [25,] -9.989866e-01 0.07397965  0.954991273
       [26,]  9.693503e-01 0.46756031  1.245682576
       [27,]  5.264350e-01 1.08527036 -1.850215368
       [28,]  3.820000e-01 1.52231678 -0.075837676
       [29,]  3.102142e-02 0.12890981  1.999518720
       [30,] -2.145428e-01 1.22496069 -1.976714599
       [31,]  9.460336e-01 1.57341804 -1.324068462
       [32,]  3.658617e-01 0.70291252 -0.069330769
       [33,]  9.779164e-01 0.17510091 -1.208996337
       [34,] -5.765130e-02 1.76992939 -1.998336781
       [35,]  5.528318e-01 1.80707118  1.833292885
       [36,] -1.711098e-01 0.11237985 -1.985251959
       [37,]  8.985320e-01 0.61719410 -0.561092004
       [38,] -2.692792e-01 1.17654302  0.036937842
       [39,]  7.029576e-01 0.86187211  1.711231748
       [40,]  9.516887e-01 1.50009911 -0.692935435
       [41,]  2.757622e-01 0.30271701  1.961225875
       [42,] -1.796062e-01 0.35852684  1.983738593
       [43,] -9.948022e-01 0.70471592  1.101826334
       [44,]  6.928087e-01 1.02974263 -0.278878558
       [45,] -9.971555e-01 1.62297656  0.924628074
       [46,] -7.615844e-01 0.21387518  0.351934223
       [47,]  3.888815e-01 1.25841821 -1.921287802
       [48,] -9.342363e-01 1.68762204  1.356654757
       [49,]  6.889066e-01 0.26533407 -0.275149919
       [50,] -9.943057e-01 1.15571579  0.893434806
       [51,] -6.353427e-01 0.24480262  1.772230279
       [52,] -8.737090e-01 1.56355594 -1.486449025
       [53,]  8.997728e-01 0.78702929  1.436358666
       [54,] -2.175777e-01 0.11550640  0.023957006
       [55,] -4.710509e-01 0.91181031 -1.882106028
       [56,]  6.408308e-01 0.44683170 -0.232317877
       [57,]  8.609222e-01 0.86716804 -1.508736643
       [58,]  5.410425e-01 1.50248988 -0.159004726
       [59,]  9.271078e-01 1.99112607 -0.625205232
       [60,]  8.086759e-01 1.06293679  1.588254440
       [61,] -7.921173e-01 0.80337418  1.610368887
       [62,]  8.943437e-01 1.54287781 -1.447380440
       [63,]  1.160802e-01 1.80049480 -0.006760160
       [64,]  4.144453e-01 0.31644055  1.910074239
       [65,]  5.349837e-01 0.88617434 -0.155137623
       [66,]  9.595738e-01 0.56803864  1.281457174
       [67,] -9.336233e-01 1.16142450 -1.358256340
       [68,] -5.312342e-02 0.91217366  0.001412046
       [69,] -4.641715e-01 1.09543025 -1.885745322
       [70,]  6.956614e-01 0.68258579 -0.281630155
       [71,]  8.406038e-01 0.27280546  1.541650490
       [72,] -5.546917e-01 1.22667403  1.832055986
       [73,]  9.871846e-01 0.54224197 -1.159582318
       [74,] -5.658612e-01 1.13322177  0.175499483
       [75,]  9.538393e-01 1.71893300 -1.300317533
       [76,] -5.378561e-01 1.69195215  1.843036674
       [77,]  7.456594e-01 1.11590720  1.666327289
       [78,]  9.505696e-01 0.66869274  1.310511679
       [79,] -9.113522e-01 0.79695870  1.411627407
       [80,] -7.955631e-01 1.97405724 -1.605870763
       [81,]  9.714806e-01 1.23050150 -1.237119174
       [82,]  8.561183e-01 1.88886116 -1.516779821
       [83,]  7.236394e-01 1.16542223  1.690178256
       [84,] -3.393940e-01 0.27913296  0.059355706
       [85,] -8.655595e-01 0.16150991 -1.500806143
       [86,]  9.834143e-01 0.30728423 -1.181373536
       [87,] -8.872170e-01 0.88741122  1.461352321
       [88,]  8.851198e-01 0.92526913 -1.465363169
       [89,]  6.559254e-01 0.70646036  1.754825739
       [90,]  8.864385e-01 0.95622280 -0.537153557
       [91,]  8.398195e-01 0.95499765  1.542865689
       [92,]  8.317352e-02 1.16731209  1.996535080
       [93,]  7.422533e-01 1.46960261  1.670119474
       [94,] -6.045415e-01 1.30108509 -1.796573634
       [95,]  7.881759e-01 1.36971127  1.615450085
       [96,] -9.010574e-01 0.20878873 -1.433699926
       [97,]  6.996357e-01 1.69528311 -1.714499789
       [98,]  3.913508e-01 0.19668888 -1.920241587
       [99,] -2.324424e-01 1.67849808  0.027389846
      [100,] -9.778047e-01 0.81213819  1.209518632
      [101,]  8.864403e-02 1.41455600  1.588380885
      [102,]  1.747171e+00 1.18144704 -0.664631734
      [103,]  1.332138e+00 1.39028557  2.943230673
      [104,]  1.916465e+00 1.33858666  0.400115541
      [105,]  1.908563e+00 1.25012305  2.417746870
      [106,]  1.551247e-01 2.68225335  1.465036694
      [107,]  6.364798e-01 2.64102452 -0.931586324
      [108,]  5.872210e-02 1.22843599 -0.337632809
      [109,]  8.387622e-01 2.53523036 -0.986915589
      [110,]  1.994217e+00 1.59883851  2.107393291
      [111,]  1.969615e+00 2.79271577  2.244635852
      [112,]  1.832721e+00 2.89289195  0.553692587
      [113,]  8.651389e-02 1.34809208 -0.406869920
      [114,]  1.982109e+00 1.13684835  0.188313659
      [115,]  9.692634e-03 2.86469817  1.861106804
      [116,]  2.025423e-01 2.28970960  1.396625133
      [117,]  8.042490e-01 1.55654002  1.019346372
      [118,]  1.763446e-05 2.20541273  2.005938738
      [119,]  1.837399e+00 1.10063581  0.546592016
      [120,]  3.403875e-01 1.46881681  2.751605891
      [121,]  3.593871e-02 2.16108832  2.265679941
      [122,]  6.694046e-01 2.87847471  2.943772574
      [123,]  1.345292e-01 2.47190500  1.499040672
      [124,]  1.986411e+00 2.21847799  0.164293545
      [125,]  1.013406e-03 1.07397965  1.954991273
      [126,]  1.969350e+00 1.46756031  2.245682576
      [127,]  1.526435e+00 2.08527036 -0.850215368
      [128,]  1.382000e+00 2.52231678  0.924162324
      [129,]  1.031021e+00 1.12890981  2.999518720
      [130,]  7.854572e-01 2.22496069 -0.976714599
      [131,]  1.946034e+00 2.57341804 -0.324068462
      [132,]  1.365862e+00 1.70291252  0.930669231
      [133,]  1.977916e+00 1.17510091 -0.208996337
      [134,]  9.423487e-01 2.76992939 -0.998336781
      [135,]  1.552832e+00 2.80707118  2.833292885
      [136,]  8.288902e-01 1.11237985 -0.985251959
      [137,]  1.898532e+00 1.61719410  0.438907996
      [138,]  7.307208e-01 2.17654302  1.036937842
      [139,]  1.702958e+00 1.86187211  2.711231748
      [140,]  1.951689e+00 2.50009911  0.307064565
      [141,]  1.275762e+00 1.30271701  2.961225875
      [142,]  8.203938e-01 1.35852684  2.983738593
      [143,]  5.197810e-03 1.70471592  2.101826334
      [144,]  1.692809e+00 2.02974263  0.721121442
      [145,]  2.844509e-03 2.62297656  1.924628074
      [146,]  2.384156e-01 1.21387518  1.351934223
      [147,]  1.388881e+00 2.25841821 -0.921287802
      [148,]  6.576374e-02 2.68762204  2.356654757
      [149,]  1.688907e+00 1.26533407  0.724850081
      [150,]  5.694283e-03 2.15571579  1.893434806
      [151,]  3.646573e-01 1.24480262  2.772230279
      [152,]  1.262910e-01 2.56355594 -0.486449025
      [153,]  1.899773e+00 1.78702929  2.436358666
      [154,]  7.824223e-01 1.11550640  1.023957006
      [155,]  5.289491e-01 1.91181031 -0.882106028
      [156,]  1.640831e+00 1.44683170  0.767682123
      [157,]  1.860922e+00 1.86716804 -0.508736643
      [158,]  1.541042e+00 2.50248988  0.840995274
      [159,]  1.927108e+00 2.99112607  0.374794768
      [160,]  1.808676e+00 2.06293679  2.588254440
      [161,]  2.078827e-01 1.80337418  2.610368887
      [162,]  1.894344e+00 2.54287781 -0.447380440
      [163,]  1.116080e+00 2.80049480  0.993239840
      [164,]  1.414445e+00 1.31644055  2.910074239
      [165,]  1.534984e+00 1.88617434  0.844862377
      [166,]  1.959574e+00 1.56803864  2.281457174
      [167,]  6.637674e-02 2.16142450 -0.358256340
      [168,]  9.468766e-01 1.91217366  1.001412046
      [169,]  5.358285e-01 2.09543025 -0.885745322
      [170,]  1.695661e+00 1.68258579  0.718369845
      [171,]  1.840604e+00 1.27280546  2.541650490
      [172,]  4.453083e-01 2.22667403  2.832055986
      [173,]  1.987185e+00 1.54224197 -0.159582318
      [174,]  4.341388e-01 2.13322177  1.175499483
      [175,]  1.953839e+00 2.71893300 -0.300317533
      [176,]  4.621439e-01 2.69195215  2.843036674
      [177,]  1.745659e+00 2.11590720  2.666327289
      [178,]  1.950570e+00 1.66869274  2.310511679
      [179,]  8.864778e-02 1.79695870  2.411627407
      [180,]  2.044369e-01 2.97405724 -0.605870763
      [181,]  1.971481e+00 2.23050150 -0.237119174
      [182,]  1.856118e+00 2.88886116 -0.516779821
      [183,]  1.723639e+00 2.16542223  2.690178256
      [184,]  6.606060e-01 1.27913296  1.059355706
      [185,]  1.344405e-01 1.16150991 -0.500806143
      [186,]  1.983414e+00 1.30728423 -0.181373536
      [187,]  1.127830e-01 1.88741122  2.461352321
      [188,]  1.885120e+00 1.92526913 -0.465363169
      [189,]  1.655925e+00 1.70646036  2.754825739
      [190,]  1.886438e+00 1.95622280  0.462846443
      [191,]  1.839820e+00 1.95499765  2.542865689
      [192,]  1.083174e+00 2.16731209  2.996535080
      [193,]  1.742253e+00 2.46960261  2.670119474
      [194,]  3.954585e-01 2.30108509 -0.796573634
      [195,]  1.788176e+00 2.36971127  2.615450085
      [196,]  9.894264e-02 1.20878873 -0.433699926
      [197,]  1.699636e+00 2.69528311 -0.714499789
      [198,]  1.391351e+00 1.19668888 -0.920241587
      [199,]  7.675576e-01 2.67849808  1.027389846
      [200,]  2.219535e-02 1.81213819  2.209518632

