% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cff_write_misc.R
\name{cff_write_bib}
\alias{cff_write_bib}
\alias{cff_write_citation}
\title{Export \strong{R} objects to different file types}
\usage{
cff_write_bib(
  x,
  file = tempfile(fileext = ".bib"),
  append = FALSE,
  verbose = TRUE,
  ascii = FALSE,
  ...
)

cff_write_citation(
  x,
  file = tempfile("CITATION_"),
  append = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{A \code{\link{bibentry}} or a \code{\link{cff}} object.}

\item{file}{Name of the file to be created. If \code{NULL} it would display the
lines to be written.}

\item{append}{Whether to append the entries to an existing file or not.}

\item{verbose}{Display informative messages}

\item{ascii}{Whether to write the entries using ASCII characters only or not.}

\item{...}{
  Arguments passed on to \code{\link[=as_bibentry.cff]{as_bibentry.cff}}, \code{\link[=as_bibentry.cff_ref]{as_bibentry.cff_ref}}, \code{\link[=as_bibentry.cff_ref_lst]{as_bibentry.cff_ref_lst}}
  \describe{
    \item{\code{what}}{Fields to extract from a full \code{cff} object. The value could be:
\itemize{
\item \code{preferred}: This would create a single entry with the main citation
info of the package (key \code{preferred-citation}).
\item \code{references}: Extract all the entries of \code{references} key.
\item \code{all}: A combination of the previous two options. This would extract
both the \code{preferred-citation} and the \code{references} key.
}

See \code{vignette("crosswalk", package = "cffr")}.}
  }}
}
\value{
Writes the corresponding file specified on the \code{file} parameter.
}
\description{
Export \strong{R} objects representing citations to specific file types:
\itemize{
\item \code{\link[=cff_write_bib]{cff_write_bib()}} creates a \code{.bib} file.
\item \code{\link[=cff_write_citation]{cff_write_citation()}} creates a \strong{R} citation file as explained in
Section 1.9 CITATION files of \emph{Writing R Extensions} (R Core Team 2023).
}
}
\details{
When \code{x} is a \code{cff} object it would be converted to \code{Bibtex} using
\code{\link[=toBibtex.cff]{toBibtex.cff()}}.

For security reasons, if the file already exists the function would create
a backup copy on the same directory.
}
\examples{

bib <- bibentry("Misc",
  title = "My title",
  author = "Fran Pérez"
)

my_temp_bib <- tempfile(fileext = ".bib")

cff_write_bib(bib, file = my_temp_bib)

cat(readLines(my_temp_bib), sep = "\n")

cff_write_bib(bib, file = my_temp_bib, ascii = TRUE, append = TRUE)

cat(readLines(my_temp_bib), sep = "\n")

# Create a CITATION file

# Use a system file
f <- system.file("examples/preferred-citation-book.cff", package = "cffr")
a_cff <- cff_read(f)

out <- file.path(tempdir(), "CITATION")
cff_write_citation(a_cff, file = out)

# Check by reading, use meta object
meta <- packageDescription("cffr")
meta$Encoding <- "UTF-8"

utils::readCitationFile(out, meta)
}
\references{
\itemize{
\item R Core Team (2023). \emph{Writing R Extensions}.
\url{https://cran.r-project.org/doc/manuals/r-release/R-exts.html}
}
}
\seealso{
\code{vignette("bibtex_cff", "cffr")}, \code{\link[knitr:write_bib]{knitr::write_bib()}} and the
following packages:
\itemize{
\item \CRANpkg{bibtex}.
\item \CRANpkg{RefManageR}
\item \CRANpkg{rbibutils}
}

Other functions for working with BibTeX format:
\code{\link{as_bibentry}()},
\code{\link{cff_read}()},
\code{\link{cff_read_bib_text}()},
\code{\link{encoded_utf_to_latex}()}

Other functions for creating external files:
\code{\link{cff_write}()}
}
\concept{bibtex}
\concept{writing}
