% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chkpt_stan.R
\name{chkpt_stan}
\alias{chkpt_stan}
\title{Checkpoint Sampling: Stan}
\usage{
chkpt_stan(
  model_code,
  data,
  iter_warmup = 1000,
  iter_sampling = 1000,
  iter_per_chkpt = 100,
  iter_typical = 150,
  parallel_chains = 2,
  threads_per = 1,
  chkpt_progress = TRUE,
  control = NULL,
  seed = 1,
  path,
  ...
)
}
\arguments{
\item{model_code}{Character string corresponding to the Stan model.}

\item{data}{A named list of R objects (like for RStan).
Further details can be found in \code{\link[cmdstanr]{sample}}.}

\item{iter_warmup}{(positive integer) The number of warmup iterations to run
per chain (defaults to 1000).}

\item{iter_sampling}{(positive integer) The number of post-warmup iterations
to run per chain (defaults to 1000).}

\item{iter_per_chkpt}{(positive integer). The number of iterations per
checkpoint. Note that \code{iter_sampling} is divided
by \code{iter_per_chkpt} to determine the number of
checkpoints. This must result in an integer
(if not, there will be an error).}

\item{iter_typical}{(positive integer) The number of iterations in the
initial warmup, which finds the so-called typical set.
This is an initial phase, and not included in
\code{iter_warmup}. Note that a large enough value
is required to ensure converge (defaults to 150).}

\item{parallel_chains}{(positive integer) The \emph{maximum number} of MCMC
chains to run in parallel. If parallel_chains is not
specified then the default is to look for the option
\code{mc.cores}, which can be set for an entire R session by
\code{options(mc.cores=value)}. If the \code{mc.cores}
option has not been set then the default is \code{1}.}

\item{threads_per}{(positive integer) Number of threads to use in within-chain
parallelization (defaults to \code{1}).}

\item{chkpt_progress}{logical. Should the \code{chkptstanr} progress
be printed (defaults to \code{TRUE}) ? If set to
\code{FALSE}, the standard \code{cmdstanr} progress
bar is printed for each checkpoint
(which does not actually keep track of
checkpointing progress)}

\item{control}{A named list of parameters to control the sampler's behavior.
It defaults to NULL so all the default values are used.
For a comprehensive overview see \code{\link[rstan]{stan}}.}

\item{seed}{(positive integer). The seed for random number generation to
make results reproducible.}

\item{path}{Character string. The path to the folder, that is used for
saving the checkpoints.}

\item{...}{Currently ignored.}
}
\value{
An objet of class \code{chkpt_stan}
}
\description{
Fit Bayesian  models using Stan with checkpointing.
}
\examples{
\dontrun{

# path for storing checkpoint info
path <- create_folder(folder_name = "chkpt_folder_fit1")

stan_code <- make_stancode(bf(formula = count ~ zAge + zBase * Trt + (1|patient),
                              family = poisson()),
                           data = epilepsy)
stan_data <- make_standata(bf(formula = count ~ zAge + zBase * Trt + (1|patient),
                              family = poisson()),
                           data = epilepsy)

# "random" intercept
fit1 <- chkpt_stan(model_code = stan_code, 
                   data = stan_data,
                   iter_warmup = 1000,
                   iter_sampling = 1000,
                   iter_per_chkpt = 250,
                   path = path)

draws <- combine_chkpt_draws(object = fit1)

posterior::summarise_draws(draws)


# eight schools example
 
# path for storing checkpoint info
path <- create_folder(parent_folder = "chkpt_folder_fit2")

stan_code <- "
data {
 int<lower=0> n;
  real y[n]; 
  real<lower=0> sigma[n]; 
}
parameters {
  real mu;
  real<lower=0> tau; 
  vector[n] eta; 
}
transformed parameters {
  vector[n] theta; 
  theta = mu + tau * eta; 
}
model {
  target += normal_lpdf(eta | 0, 1); 
  target += normal_lpdf(y | theta, sigma);  
}
"
stan_data <- schools.data <- list(
  n = 8,
  y = c(28,  8, -3,  7, -1,  1, 18, 12),
  sigma = c(15, 10, 16, 11,  9, 11, 10, 18)
)

fit2 <- chkpt_stan(model_code = stan_code, 
                   data = stan_data,
                   iter_warmup = 1000,
                   iter_sampling = 1000,
                   iter_per_chkpt = 250,
                   path = path)

draws <- combine_chkpt_draws(object = fit2)

posterior::summarise_draws(draws)
}
}
