% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridding.R
\name{par_pad_grid}
\alias{par_pad_grid}
\title{Get a set of computational grids}
\usage{
par_pad_grid(
  input,
  mode = c("grid", "grid_advanced", "grid_quantile"),
  nx = 10L,
  ny = 10L,
  grid_min_features = 30L,
  padding = NULL,
  unit = NULL,
  quantiles = NULL,
  merge_max = NULL,
  return_wkt = FALSE,
  ...
)
}
\arguments{
\item{input}{sf or Spat* object.}

\item{mode}{character(1). Mode of region construction.
One of
\itemize{
\item \code{"grid"} (simple grid regardless of the number of features in each grid)
\item \code{"grid_advanced"} (merging adjacent grids with
smaller number of features than \code{grid_min_features}).
The argument \code{grid_min_features} should be specified.
\item \code{"grid_quantile"} (x and y quantiles): an argument \code{quantiles} should
be specified.
}}

\item{nx}{integer(1). The number of grids along x-axis.}

\item{ny}{integer(1). The number of grids along y-axis.}

\item{grid_min_features}{integer(1). A threshold to merging adjacent grids}

\item{padding}{numeric(1). A extrusion factor to make buffer to
clip actual datasets. Depending on the length unit of the CRS of input.}

\item{unit}{character(1). The length unit for padding (optional).
\code{units::set_units} is used for padding when \code{sf} object is used.
See \href{https://CRAN.R-project.org/package=units/vignettes/measurement_units_in_R.html}{link}
for the list of acceptable unit forms.}

\item{quantiles}{numeric. Quantiles for \code{grid_quantile} mode.}

\item{merge_max}{integer(1). Maximum number of grids to merge
per merged set.}

\item{return_wkt}{logical(1). Return WKT format. When \code{TRUE},
the return value will be a list of two WKT strings.}

\item{...}{arguments passed to the internal function}
}
\value{
A list of two,
\itemize{
\item \code{original}: exhaustive (filling completely) and non-overlapping
grid polygons in the class of input
\item \code{padded}: a square buffer of each polygon in
\code{original}. Used for computation.
}
}
\description{
Using input points, the bounding box is split to
the predefined numbers of columns and rows.
Each grid will be buffered by the radius.
}
\examples{
lastpar <- par(mfrow = c(1, 1))
# data
library(sf)
options(sf_use_s2 = FALSE)
ncpath <- system.file("shape/nc.shp", package = "sf")
nc <- read_sf(ncpath)
nc <- st_transform(nc, "EPSG:5070")

# run: nx and ny should strictly be integers
nc_comp_region <-
  par_pad_grid(
    nc,
    mode = "grid",
    nx = 4L, ny = 2L,
    padding = 10000)
par(mfcol = c(1, 2))
plot(nc_comp_region$original$geometry)
plot(nc_comp_region$padded$geometry)

nc_comp_region_wkt <-
  par_pad_grid(
    nc,
    mode = "grid",
    nx = 4L, ny = 2L,
    padding = 10000,
    return_wkt = TRUE)
nc_comp_region_wkt$original
nc_comp_region_wkt$padded

par(lastpar)
}
\seealso{
Other Parallelization: 
\code{\link{par_cut_coords}()},
\code{\link{par_grid}()},
\code{\link{par_grid_mirai}()},
\code{\link{par_hierarchy}()},
\code{\link{par_hierarchy_mirai}()},
\code{\link{par_make_grid}()},
\code{\link{par_merge_grid}()},
\code{\link{par_multirasters}()},
\code{\link{par_multirasters_mirai}()},
\code{\link{par_pad_balanced}()},
\code{\link{par_split_list}()}
}
\author{
Insang Song
}
\concept{Parallelization}
