% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regressions.r
\name{regression_fit}
\alias{regression_fit}
\title{Obtain regression results}
\usage{
regression_fit(
  data,
  y,
  predictor,
  time = NULL,
  covars = NULL,
  rcs_knots = NULL,
  returned = c("full", "predictor_split", "predictor_combined")
)
}
\arguments{
\item{data}{A data frame.}

\item{y}{A character string of the outcome variable. The variable should be binary or numeric and determines
the type of model to be used. If the variable is binary, logistic or cox regression is used. If the variable is
numeric, linear regression is used.}

\item{predictor}{A character string of the predictor variable.}

\item{time}{A character string of the time variable. If \code{NULL}, linear or logistic regression is used.
Otherwise, Cox proportional hazards regression is used.}

\item{covars}{A character vector of covariate names.}

\item{rcs_knots}{The number of rcs knots. If \code{NULL}, a linear model would be fitted instead.}

\item{returned}{The return mode of this function.
\itemize{
\item \code{"full"}: return the full regression result.
\item \code{"predictor_split"}: return the regression parameter of the predictor, could have multiple lines.
\item \code{"predictor_combined"}: return the regression parameter of the predictor, test the predictor as a whole and
takes only one line.
}}
}
\value{
A list containing the regression ratio and p-value of the predictor. If \code{rcs_knots} is not \code{NULL},
the list contains the overall p-value and the nonlinear p-value of the rcs model. If \code{return_full_result}
is \code{TRUE}, the complete result of the regression model is returned.
}
\description{
This function fit the regression of a predictor in a
linear, logistic, or Cox proportional hazards model.
}
\examples{
data(cancer, package = "survival")
regression_fit(data = cancer, y = "status", predictor = "age", time = "time", rcs_knots = 4)
}
