% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quarterly-year-quarter-day.R
\name{year-quarter-day-setters}
\alias{year-quarter-day-setters}
\alias{set_year.clock_year_quarter_day}
\alias{set_quarter.clock_year_quarter_day}
\alias{set_day.clock_year_quarter_day}
\alias{set_hour.clock_year_quarter_day}
\alias{set_minute.clock_year_quarter_day}
\alias{set_second.clock_year_quarter_day}
\alias{set_millisecond.clock_year_quarter_day}
\alias{set_microsecond.clock_year_quarter_day}
\alias{set_nanosecond.clock_year_quarter_day}
\title{Setters: year-quarter-day}
\usage{
\method{set_year}{clock_year_quarter_day}(x, value, ...)

\method{set_quarter}{clock_year_quarter_day}(x, value, ...)

\method{set_day}{clock_year_quarter_day}(x, value, ...)

\method{set_hour}{clock_year_quarter_day}(x, value, ...)

\method{set_minute}{clock_year_quarter_day}(x, value, ...)

\method{set_second}{clock_year_quarter_day}(x, value, ...)

\method{set_millisecond}{clock_year_quarter_day}(x, value, ...)

\method{set_microsecond}{clock_year_quarter_day}(x, value, ...)

\method{set_nanosecond}{clock_year_quarter_day}(x, value, ...)
}
\arguments{
\item{x}{\verb{[clock_year_quarter_day]}

A year-quarter-day vector.}

\item{value}{\verb{[integer / "last"]}

The value to set the component to.

For \code{set_day()}, this can also be \code{"last"} to adjust to the last
day of the current fiscal quarter.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
\code{x} with the component set.
}
\description{
These are year-quarter-day methods for the
\link[=clock-setters]{setter generics}.
\itemize{
\item \code{set_year()} sets the fiscal year.
\item \code{set_quarter()} sets the fiscal quarter of the year.
Valid values are in the range of \verb{[1, 4]}.
\item \code{set_day()} sets the day of the fiscal quarter.
Valid values are in the range of \verb{[1, 92]}.
\item There are sub-daily setters for setting more precise components.
}
}
\examples{
library(magrittr)

# Quarter precision vector
x <- year_quarter_day(2019, 1:4)
x

# Promote to day precision by setting the day
x <- set_day(x, 1)
x

# Or set to the last day of the quarter
x <- set_day(x, "last")
x

# What year-month-day is this?
as_year_month_day(x)

# Set to an invalid day of the quarter
# (not all quarters have 92 days)
invalid <- set_day(x, 92)
invalid

# Here are the invalid ones
invalid[invalid_detect(invalid)]

# Resolve the invalid dates by choosing the previous/next valid moment
invalid_resolve(invalid, invalid = "previous")
invalid_resolve(invalid, invalid = "next")

# Or resolve by "overflowing" by the number of days that you have
# gone past the last valid day
invalid_resolve(invalid, invalid = "overflow")

# This is similar to
days <- get_day(invalid) - 1L
invalid \%>\%
  set_day(1) \%>\%
  as_naive_time() \%>\%
  add_days(days) \%>\%
  as_year_quarter_day()
}
