% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glimpse_contrasts.R
\name{.get_reference_levels}
\alias{.get_reference_levels}
\title{Get reference levels from a (possibly set) list of contrasts}
\usage{
.get_reference_levels(contrast_list, list_params = NULL, formulas = NULL)
}
\arguments{
\item{contrast_list}{List of contrasts, does not need to be named}

\item{list_params}{Optional list of parameters, see \code{\link[=.make_parameters]{.make_parameters()}}, if
NULL, then the reference level is determined from the contrast matrix
directly.}

\item{formulas}{Optional list of formulas, needed if \code{params} are passed.
Used to get the correct environment for evaluating expressions in \code{params}.
If NULL, then the reference level is determiend from the contrast matrix
directly.}
}
\value{
Character vector of reference levels. If a contrast matrix is not
specified for row names, the character value will denote the integer index
of the row for the reference level (usually 1).
}
\description{
Given a list of contrast matrices, if the contrast matrices were explicitly
generated via formulas and they have already had their parameters parsed, use
the parameters to look up the reference level for each contrast matrix. If
the parameters have not been computed (usually because the contrasts are
using the defaults) then look up the reference level manually.
}
\keyword{internal}
