% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convolution_assoc.R
\name{CONVOLUTION_assoc}
\alias{CONVOLUTION_assoc}
\alias{new_CONVOLUTION_assoc}
\alias{new_SUM_assoc}
\alias{new_SUBTRACTION_assoc}
\alias{new_MULTIPLICATION_assoc}
\alias{new_DIVISION_assoc}
\title{Convolution with association of dimensions}
\usage{
new_CONVOLUTION_assoc(dist1, dist2, op)

new_SUM_assoc(dist1, dist2)

new_SUBTRACTION_assoc(dist1, dist2)

new_MULTIPLICATION_assoc(dist1, dist2)

new_DIVISION_assoc(dist1, dist2)
}
\arguments{
\item{dist1}{an object of class \code{\link{DISTRIBUTION}}}

\item{dist2}{and object of class \code{\link{DISTRIBUTION}}}

\item{op}{one of `+`,`-`,`*`,`/`}
}
\value{
an object of class \code{\link{DISTRIBUTION}}
}
\description{
In case of different dimensions of the distribution
this function perform the operation on the common distributions and
add without modifications the other dimensions of the distribution.
}
\details{
If distribution A have dimensions a and b and distribution B have dimensions
b and c, the A + B would produce a distribution with dimensions
a, c,  b+b,
}
\section{Functions}{
\itemize{
\item \code{new_SUM_assoc()}: Sum of distributions

\item \code{new_SUBTRACTION_assoc()}: Subtraction of distributions

\item \code{new_MULTIPLICATION_assoc()}: Multiplication of distributions

\item \code{new_DIVISION_assoc()}: Division of distributions

}}
\examples{
x1 <- new_MULTINORMAL(c(0,1), matrix(c(1,0.5,0.5,1),ncol=2), p_dimnames = c("A","B"))
x2 <- new_MULTINORMAL(c(10,1), matrix(c(1,0.4,0.4,1),ncol=2), p_dimnames = c("B","C"))
new_CONVOLUTION_assoc(x1,x2, `+`)
new_SUM_assoc(x1,x2)
new_SUBTRACTION_assoc(x1,x2)
new_MULTIPLICATION_assoc(x1,x2)
new_DIVISION_assoc(x1,x2)
}
\author{
John J. Aponte
}
