% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MatSelect.R
\name{MatSelect}
\alias{MatSelect}
\title{Select Variable Subsets with Low Correlation or Association (Matrix Interface)}
\usage{
MatSelect(mat, threshold = 0.7, method = NULL, force_in = NULL, ...)
}
\arguments{
\item{mat}{A numeric, symmetric matrix with 1s on the diagonal (e.g. correlation matrix).
Column names (if present) are used to label output variables.}

\item{threshold}{A numeric scalar in (0, 1). Maximum allowed absolute pairwise value.
Defaults to \code{0.7}.}

\item{method}{Character. Selection algorithm to use. One of \code{"els"} or
\code{"bron-kerbosch"}. If not specified, the function chooses automatically:
\code{"els"} when \code{force_in} is provided, otherwise \code{"bron-kerbosch"}.}

\item{force_in}{Optional integer vector of 1-based column indices to force into every subset.}

\item{...}{Additional arguments passed to the backend, e.g., \code{use_pivot} (logical)
for enabling pivoting in Bron–Kerbosch (ignored by ELS).}
}
\value{
An object of class \code{\link{CorrCombo}}, containing all valid subsets and their
correlation statistics.
}
\description{
Identifies all maximal subsets of variables from a symmetric matrix (typically a correlation matrix)
such that all pairwise absolute values stay below a specified threshold. Implements exact algorithms
such as Eppstein–Löffler–Strash (ELS) and Bron–Kerbosch (with or without pivoting).
}
\examples{
set.seed(42)
mat <- matrix(rnorm(100), ncol = 10)
colnames(mat) <- paste0("V", 1:10)
cmat <- cor(mat)

# Default method (Bron-Kerbosch)
res1 <- MatSelect(cmat, threshold = 0.5)

# Bron–Kerbosch without pivot
res2 <- MatSelect(cmat, threshold = 0.5, method = "bron-kerbosch", use_pivot = FALSE)

# Bron–Kerbosch with pivoting
res3 <- MatSelect(cmat, threshold = 0.5, method = "bron-kerbosch", use_pivot = TRUE)

# Force variable 1 into every subset (with warning if too correlated)
res4 <- MatSelect(cmat, threshold = 0.5, force_in = 1)

}
