% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/weight.R
\name{weightVariables<-}
\alias{weightVariables<-}
\alias{is.weightVariable<-}
\alias{modifyWeightVariables}
\alias{weightVariables<-,CrunchDataset-method}
\alias{is.weightVariable}
\alias{is.weightVariable<-,NumericVariable-method}
\title{Change which variables can be set as a dataset's weight.}
\usage{
weightVariables(x) <- value

is.weightVariable(x) <- value

modifyWeightVariables(x, vars, type = "append")

\S4method{weightVariables}{CrunchDataset}(x) <- value

is.weightVariable(x)

\S4method{is.weightVariable}{NumericVariable}(x) <- value
}
\arguments{
\item{x}{a CrunchDataset}

\item{value}{For the \code{weightVariables()} and \code{is.weightVariable} setters the
variables to append to a dataset's weightVariables.}

\item{vars}{Variables to add or remove  this can be a numeric Crunch variable,
list of numeric Crunch variables or a character vector with the aliases of
numeric Crunch variables. Setting vars to \code{NULL} clears a datasets \code{weightVariables}}

\item{type}{a character string determining how the weightVariables
will be modified:
\itemize{
\item \code{"append"} : add \code{vars} to the current weight variables
\item \code{"remove"} : remove \code{vars} from the current list of weight variables
\item \code{"replace"}: replace the current weight variables with \code{vars}
}}
}
\value{
a CrunchDataset
}
\description{
\code{modifyWeightVariables} allows you to change the variables which are eligible
to be used as a dataset's weight. You can also add variables to the weight variables
catalog by assignment with \code{weightVariables(ds) <- "weight"} or
\code{is.weightVariable(ds$weight) <- TRUE}.
}
\details{
Editors can change which variables can be set as the weighting variable
for a dataset. For instance if several weights have been calculated they
can let the user choose which of those variables to use a weight, but prevent
the user from choosing other variables as weight. This function allows you
to change the \code{weightVariables} of a dataset.
}
\examples{
\dontrun{
modifyweightVariables(ds, "weight", "append")
weightVariables(ds) <- list(ds$weight, ds$weight2)
weightVariables(ds) <- NULL
weightVariables(ds) <- c("weight", "weight2")
is.weightVariables(ds$weight) <- TRUE
}
}
