% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clinicaltrials_gov_version.R
\name{clinicaltrials_gov_version}
\alias{clinicaltrials_gov_version}
\title{Download a registry entry version from ClinicalTrials.gov}
\usage{
clinicaltrials_gov_version(nctid, versionno = 0)
}
\arguments{
\item{nctid}{A character string including a well-formed
ClinicalTrials.gov NCT Number, e.g. "NCT00942747". (A
capitalized "NCT" followed by eight numerals with no spaces or
hyphens.)}

\item{versionno}{An integer version number, e.g. 3, where 0 is the
earliest version of the trial in question, 1 is the next most
recent, etc. (Please note that this differs from the convention
used in cthist v. <= 1.4.2, in which 1 is the earliest version
of the trial in question.) If no version number is specified,
the first version will be downloaded. If -1 (negative one) is
specified, the latest version will be downloaded.}
}
\value{
A list containing the overall status, enrolment, start
date, start date precision (month or day) primary completion
date, primary completion date precision (month or day), primary
completion date type, minimum age, maximum age, sex, accepts
healthy volunteers, inclusion/exclusion criteria, outcome
measures, overall contacts, central contacts, responsible
party, lead sponsor, collaborators, locations, reason why the
trial stopped (if provided), whether results are posted,
references data, organization identifiers and other secondary
trial identifiers.
}
\description{
Download a registry entry version from ClinicalTrials.gov
}
\examples{

\donttest{
version <- clinicaltrials_gov_version("NCT00942747", 1)
}
}
