% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{print.ctsmTMB.fit}
\alias{print.ctsmTMB.fit}
\title{Basic print of objects ctsmTMB fit objects}
\usage{
\method{print}{ctsmTMB.fit}(x, ...)
}
\arguments{
\item{x}{a ctsmTMB fit object}

\item{...}{additional arguments}
}
\value{
Print of ctsmTMB fit object
}
\description{
Basic print of objects ctsmTMB fit objects
}
\examples{
library(ctsmTMB)
model <- ctsmTMB$new()

# create model
model$addSystem(dx ~ theta * (mu+u-x) * dt + sigma_x*dw)
model$addObs(y ~ x)
model$setVariance(y ~ sigma_y^2)
model$addInput(u)
model$setParameter(
  theta   = c(initial = 1, lower=1e-5, upper=50),
  mu      = c(initial=1.5, lower=0, upper=5),
  sigma_x = c(initial=1, lower=1e-10, upper=30),
  sigma_y = 1e-2
)
model$setInitialState(list(1,1e-1))

# fit model to data
fit <- model$estimate(Ornstein)

# print fit
print(fit)
}
