% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_api_functions.R
\name{cvd_time_period_list}
\alias{cvd_time_period_list}
\title{List available time periods for CVD indicators}
\usage{
cvd_time_period_list(indicator_type_id = NULL)
}
\arguments{
\item{indicator_type_id}{Optional integer. If provided, restricts the returned time periods to those containing data of the given indicator type.}
}
\value{
A tibble containing details of available time periods with the following columns:
\describe{
\item{EndDate}{POSIXct. End date of the reporting period (e.g., "2025-06-30").}
\item{IndicatorTypeID}{Integer. Unique identifier for the indicator type (e.g., 1 = Standard, 2 = Outcomes).}
\item{IndicatorTypeName}{Character. Descriptive name of the indicator type (e.g., "Standard", "Outcomes").}
\item{StartDate}{POSIXct. Start date of the reporting period. Typically set to a default baseline (e.g., "1900-01-01").}
\item{TimePeriodID}{Integer. Unique identifier for the time period.}
\item{TimePeriodName}{Character. Display label for the time period (e.g., "To June 2025", "Apr 2024 – Mar 2025").}
}
If no data is found, returns a tibble describing the error.
}
\description{
Retrieves all available reporting periods from the CVDPREVENT API. Optionally, you can filter periods by a specific indicator type (e.g., standard, outcome) using the \code{indicator_type_id} parameter.
}
\details{
This function is often used to determine valid values for time period parameters in other API queries. It is a building block for most higher-level data retrieval functions in this package.
}
\note{
This function may take longer than 5 seconds to complete due to API response time.
}
\section{API Documentation}{

See the \href{https://bmchealthdocs.atlassian.net/wiki/spaces/CP/pages/317882369/CVDPREVENT+API+Documentation#\%2FtimePeriod}{CVDPREVENT API documentation: Time period} for endpoint details.
}

\examples{
# NB, the following examples are not tested because they take longer than
# expected to return the results

# List all available time periods
\donttest{cvd_time_period_list()}

# List time periods with data for a specific indicator type (e.g., Standard)
\donttest{cvd_time_period_list(indicator_type_id = 1)}

}
\seealso{
\code{\link[=cvd_indicator_types]{cvd_indicator_types()}}, \code{\link[=cvd_time_period_system_levels]{cvd_time_period_system_levels()}}
}
