% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classoFlex.R
\name{classo.path}
\alias{classo.path}
\title{fit a complex-valued lasso for a path of lambda values}
\usage{
classo.path(
  x,
  y,
  weights = NULL,
  standardize = FALSE,
  lambda = NULL,
  nlambda = 100,
  lambda.min.ratio = ifelse(nobs < nvars, 0.01, 1e-04),
  intercept = FALSE,
  thresh = 1e-10,
  maxit = 1e+05,
  trace.it = 0,
  ...
)
}
\arguments{
\item{x}{Complex-valued input matrix, of dimension nobs by nvar;
each row is an observation vector.}

\item{y}{Complex-valued response variable, nobs dimensional vector.}

\item{weights}{Observation weights. Default is 1 for each observation.}

\item{standardize}{Logical flag for x variable standardize beforehand; i.e. for n and p by nobs and nvar,
\deqn{\|X_j\|=\sqrt{n} \textrm{for all }j=1,\ldots,p}
is satisfied for the input x. Default is \code{FALSE}.}

\item{lambda}{A user supplied \code{lambda} sequence. Default is \code{NULL}.}

\item{nlambda}{The number of \code{lambda} values. Default is 100.}

\item{lambda.min.ratio}{If \code{nobs} < \code{nvars}, the default is 0.01.}

\item{intercept}{Should intercept be set to zero (default=FALSE) or fitted (FALSE)? This default is reversed from \code{glmnet} package.}

\item{thresh}{Convergence threshold for coordinate descent. Each inner
coordinate-descent loop continues until the maximum change in the objective after any
coefficient update is less than thresh times the null deviance. Default value is \code{1e-10}.}

\item{maxit}{Maximum number of iterations of outer loop. Default 10,000.}

\item{trace.it}{Controls how much information is printed to screen. Default is
\code{trace.it=0} (no information printed). If \code{trace.it=1}, a progress
bar is displayed. If \code{trace.it=2}, some information about the fitting
procedure is printed to the console as the model is being fitted.}

\item{\dots}{Other arguments that can be passed to \code{classo}}
}
\value{
An object with class "classofit" and "classo".
\item{a0}{Intercept sequence of length \code{length(lambda)}.}
\item{beta}{A \code{nvars x length(lambda)} matrix of coefficients, stored in
sparse matrix format.}
\item{df}{The number of nonzero coefficients for each value of lambda.}
\item{dim}{Dimension of coefficient matrix.}
\item{lambda}{The actual sequence of lambda values used. When alpha=0, the
largest lambda reported does not quite give the zero coefficients reported
(lambda=inf would in principle). Instead, the largest lambda for alpha=0.001
is used, and the sequence of lambda values is derived from this.}
\item{dev.ratio}{The fraction of (null) deviance explained. The deviance
calculations incorporate weights if present in the model. The deviance is
defined to be 2*(loglike_sat - loglike), where loglike_sat is the log-likelihood
for the saturated model (a model with a free parameter per observation).
Hence dev.ratio=1-dev/nulldev.}
\item{nulldev}{Null deviance (per observation). This is defined to be
2*(loglike_sat -loglike(Null)). The null model refers to the intercept model.}
\item{npasses}{Total passes over the data summed over all lambda values.}
\item{jerr}{Error flag, for warnings and errors (largely for internal
debugging).}
\item{call}{The call that produced this object.}
\item{family}{Family used for the model.}
\item{nobs}{Number of observations.}
}
\description{
Fit a complex-valued lasso formulation for a path of lambda values.
\code{classo.path} solves the Lasso problem for a path of lambda values.
}
