% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{get_text}
\alias{get_text}
\title{Get text}
\usage{
get_text(
  object,
  type = "sync",
  save_to_file = FALSE,
  dest_dir = getwd(),
  outfile_stem = NULL
)
}
\arguments{
\item{object}{either a HTTP response object from
\code{dai_sync()} or the path to a JSON file from
\code{dai_async()}.}

\item{type}{one of "sync" or "async", depending on
the function used to process the original document.}

\item{save_to_file}{boolean; whether to save the text as a .txt file}

\item{dest_dir}{folder path for the .txt output file if \code{save_to_file = TRUE}}

\item{outfile_stem}{string to form the stem of the
.txt output file}
}
\value{
a string (if \code{save_to_file = FALSE})
}
\description{
Extracts the text OCRed by Document AI (DAI)
}
\examples{
\dontrun{
text <- get_text(dai_sync("file.pdf"))

text <- get_text("file.json", type = "async", save_to_file = TRUE)
}
}
