% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obspredplot.r
\name{obspredplot}
\alias{obspredplot}
\title{Observed versus predicted values plot.}
\usage{
obspredplot(
  y.obs = y.obs,
  y.pred = y.pred,
  col = "black",
  linecol = "red",
  eng = TRUE,
  xlab = NULL,
  ylab = NULL,
  xlim = NULL,
  ylim = NULL,
  coef.max.val = 1.1,
  ...
)
}
\arguments{
\item{y.obs}{observed values of the variable of interest}

\item{y.pred}{predicted values of the variable of interest}

\item{col}{A string specifying the color of the data points. The
default is "black".}

\item{linecol}{A string specifying the straight line color. The
default is set to "red".}

\item{eng}{logical; if \code{TRUE} (by default), the language of the
statistics will be in English; if "FALSE" will be in Spanish.}

\item{xlab}{(optional) A string specifying X-axis label.}

\item{ylab}{(optional) A string specifying Y-axis label.}

\item{xlim}{(optional) A range (min,max) for the limits
of the X-axis.  By default is set to be 0 and the maximum
value of the both observed and predicted values, multiplied by
the option \code{coef.max.val}.}

\item{ylim}{(optional) A range (min,max) for the limits
of the Y-axis. By default is set to be 0 and the maximum
value of the both observed and predicted values, multiplied by
the option \code{coef.max.val}.}

\item{coef.max.val}{(optional) A number to be used for
multiplying the maximum vale of the variable (either the
observed or the predicted values). By default is set to \code{1.1}.}

\item{...}{other graphical parameters (see par and
section 'Details' below).}
}
\value{
The function returns the above described graph.
}
\description{
Creates a scatterplot between the observed values and
the predicted ones from a fitted model.
}
\details{
Notice that the straight-line is draw using
an intercept=0, and a slope=1.

Commonly used graphical parameters are:
\code{col} The colors for lines and points. Multiple colors can be specified so that each point can be given its own color. If there are fewer colors than points they are recycled in the standard fashion. Lines will all be plotted in the first colour specified.
\code{bg} a vector of background colors for open plot symbols, see points. Note: this is not the same setting as par("bg").
\code{pch} a vector of plotting characters or symbols: see points.
\code{cex} a numerical vector giving the amount by which plotting characters and symbols should be scaled relative to the default.
This works as a multiple of par("cex"). NULL and NA are
equivalent to 1.0. Note that this does not
affect annotation: see below.
\code{lty} a vector of line types, see \code{par}.
\code{cex.main}, \code{col.lab}, \code{font.sub}, etc settings for main- and sub-title and axis annotation, see title and \code{par}.
\code{lwd} a vector of line widths, see \code{par}.
}
\examples{
df <- datana::maple
head(df)
m1<-lm(leaf~dbh,data=df)
# Example 1, a residual plot
obspredplot(y.obs=df$leaf,y.pred=fitted(m1))
}
\references{
\itemize{
\item Salas-Eljatib C. 2021. Análisis de datos con el programa
estadístico R:
una introducción aplicada.
Ediciones Universidad Mayor. Santiago, Chile. 170 p.
\url{https://eljatib.com}
}

\itemize{
\item Piñeiro G, Perelman S, Guerschman JP, Paruelo JM. 2008.
How to evaluate models: Observed vs. predicted or
predicted vs. observed? Ecological Modelling 216(3-4):316-322
\doi{10.1016/j.ecolmodel.2008.05.006}
}
}
\author{
Christian Salas-Eljatib
}
