% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoundingCovariateEffects.R
\name{feasible_point_search}
\alias{feasible_point_search}
\title{Method for finding initial points of the EAM algorithm}
\usage{
feasible_point_search(
  test.fun,
  hyperparams,
  verbose,
  picturose = FALSE,
  parallel = FALSE
)
}
\arguments{
\item{test.fun}{Function that takes a parameter vector as a first argument
and returns the test statistic, as well as the critical value.}

\item{hyperparams}{List of hyperparameters.}

\item{verbose}{Verbosity parameter.}

\item{picturose}{Picturosity flag. If \code{TRUE}, a plot illustrating the
workings of the algorithm will updated during runtime. Default is
\code{picturose = FALSE}.}

\item{parallel}{Flag for whether or not parallel computing should be used.
Default is \code{parallel = FALSE}.}
}
\value{
Results of the initial feasible point search.
}
\description{
Also called the 'initialization' step in KMS19, this method
tries to find at least one initial feasible point, which is required to run
the EAM algorithm.
ToDo: Investigate whether the feasible point search of Bei (2024) is better.
If so, implement it.
}
\references{
Kaido et al. (2019). Confidence intervals for projections of
partially identified parameters. Econometrica. 87(4):1397-1432.
}
