% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune.R
\name{show_best_desirability}
\alias{show_best_desirability}
\alias{select_best_desirability}
\title{Investigate best tuning parameters}
\usage{
show_best_desirability(x, ..., n = 5, eval_time = NULL)

select_best_desirability(x, ..., eval_time = NULL)
}
\arguments{
\item{x}{The results of \code{\link[tune:tune_grid]{tune_grid()}} or \code{\link[tune:tune_bayes]{tune_bayes()}}.}

\item{...}{One or more desirability selectors to configure the optimization.}

\item{n}{An integer for the number of top results/rows to return.}

\item{eval_time}{A single numeric time point where dynamic event time
metrics should be chosen (e.g., the time-dependent ROC curve, etc). The
values should be consistent with the values used to create \code{x}. The \code{NULL}
default will automatically use the first evaluation time used by \code{x}.}
}
\value{
\code{\link[=show_best_desirability]{show_best_desirability()}} returns a tibble with \code{n} rows while
\code{\link[=select_best_desirability]{select_best_desirability()}} returns a single row. When showing the results,
the metrics are presented in "wide format" (one column per metric) and there
are new columns for the corresponding desirability values (each starts with
\code{.d_}).
}
\description{
Analogs to \code{\link[tune:show_best]{tune::show_best()}} and \code{\link[tune:show_best]{tune::select_best()}} that can
simultaneously optimize multiple metrics or characteristics using
desirability functions.
}
\details{
Desirability functions might help when selecting the best model
based on more than one performance metric. The user creates a desirability
function to map values of a metric to a \verb{[0, 1]} range where 1.0 is most
desirable and zero is unacceptable. After constructing these for the metric
of interest, the overall desirability is computed using the geometric mean
of the individual desirabilities.

The verbs that can be used in \code{...} (and their arguments) are:
\itemize{
\item \code{maximize()} when larger values are better, such as the area under the ROC
score.
\item \code{minimize()} for metrics such as RMSE or the Brier score.
\item \code{target()} for cases when a specific value of the metric is important.
\item \code{constrain()} is used when there is a range of values that are equally
desirable.
\item \code{categories()} is for situations where we want to set desirability for
qualitative columns.
}

Except for \code{categories()}, these functions have arguments \code{low} and \code{high} to
set the ranges of the metrics. For example, using:

\preformatted{
  minimize(rmse, low = 0.1, high = 2.0)
}

means that values above 2.0 are unacceptable and that an RMSE of 0.1 is the
best possible outcome.

There is also an argument that can be used to state how important a metric is
in the optimization. By default, using \code{scale = 1} means that desirability
linearly changes between \code{low} and \code{high}. Using a \code{scale} value greater
than 1 will make it more difficult to satisfy the criterion when suboptimal
values are evaluated. Conversely, a value less than one will diminish the
influence of that metric. The \code{categories()} does not have a scaling
argument while \code{target()} has two (\code{scale_low} and \code{scale_high}) for ranges
on either side of the \code{target}.

Here is an example that optimizes RMSE and the concordance correlation
coefficient (a.k.a. "ccc"), with more emphasis on the former:

\preformatted{
  minimize(rmse, low = 0.10, high = 2.00, scale = 3.0),
  maximize(ccc,  low = 0.00, high = 1.00) # scale defaults to 1.0
}

If \code{low}, \code{high}, or \code{target} are not specified, the observed data are used
to estimate their values. For the previous example, if we were to use

\preformatted{
  minimize(rmse, low = 0.10, high = 2.00, scale = 3.0),
  maximize(ccc)
}

and the concordance correlation coefficient statistics ranged from 0.21 to
0.35, the actual goals would  end up as:

\preformatted{
  minimize(rmse, low = 0.10, high = 2.00, scale = 3.0),
  maximize(ccc,  low = 0.21, high = 0.35)
}

More than one variable can be used in a term as long as R can parse and
execute the expression. For example, you could define the Youden's J
statistic using

\preformatted{
  maximize(sensitivity + specificity - 1)
}

(although there is a function for this metric in the \pkg{yardstick} package).

If the columns of the data set have missing values, their corresponding
desirability will be missing. The overall desirability computation excludes
missing values.

We advise not referencing global values or inline functions inside of these
verbs.

Also note that there may be more than \code{n} values returned when showing the
results; there may be more than one model configuration that has identical
overall desirability.
}
\examples{
# use pre-tuned results to demonstrate:
if (rlang::is_installed("tune")) {

  show_best_desirability(
    tune::ames_iter_search,
    maximize(rsq),
    minimize(rmse, scale = 3)
  )

  select_best_desirability(
    tune::ames_iter_search,
    maximize(rsq),
    minimize(rmse, scale = 3)
  )
}

}
\references{
Derringer, G. and Suich, R. (1980), Simultaneous Optimization of
Several Response Variables. \emph{Journal of Quality Technology}, 12, 214-219.

Bartz-Beielstein, T. (2025). Multi-Objective Optimization and Hyperparameter
Tuning With Desirability Functions. arXiv preprint arXiv:2503.23595.
}
\seealso{
\code{\link[=d_max]{d_max()}}, \code{\link[=d_overall]{d_overall()}}
}
