% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/laplace.dist.test.R
\name{laplace.dist.test}
\alias{laplace.dist.test}
\title{Wrapper for the 'laplace.test' function from the 'lawstat' package}
\usage{
laplace.dist.test(y, print_tables = TRUE)
}
\arguments{
\item{y}{A numeric vector containing the sample data.}

\item{print_tables}{A boolean variable that indicates whether tables with critical values will be printed or not.}
}
\value{
The result of the laplace.test function.
}
\description{
This function is a wrapper for the 'laplace.test' function from the 'lawstat' package.
The advantage of using this function instead of the 'laplace.test' function of the
'lawstat' package is that this function shows the tables with the critical values
of the statistics provided by Puig and Stephens (2000). This makes interpretation of the results easier.
}
\examples{
\donttest{
normal_sample = rnorm(100, 0, 10)
laplace_sample = rlaplace(100, 0, 10)
laplace.dist.test(normal_sample)
laplace.dist.test(laplace_sample)
}

}
\references{
Puig, P. and Stephens, M. A. (2000). Tests of fit for the Laplace distribution, with applications.
\emph{Technometrics}, \strong{42}(4), 417-424. \doi{10.2307/1270952}.
}
\seealso{
\code{\link[lawstat]{laplace.test}} Goodness-of-fit Test Statistics for the Laplace Distribution from package \code{lawstat}.
}
