% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha_hull.R
\name{alphahull}
\alias{alphahull}
\title{alpha-shape calculation}
\usage{
alphahull(X, alpha = NULL)
}
\arguments{
\item{X}{a planar point pattern (\link[spatstat.geom:ppp.object]{spatstat.geom::ppp.object}).}

\item{alpha}{a smoothing parameter to delimit concave polygons.}
}
\value{
A window, i.e. a \link[spatstat.geom:owin.object]{spatstat.geom::owin.object}.
}
\description{
Calculate a window containing all points of a point pattern.
The window is not convex but as close as possible to the points.
}
\details{
The typical use of this function is to define a narrow window around
a point pattern that has been created with a default, rectangle window.

The window is built by the \code{\link[alphahull:ashape]{alphahull::ashape()}} function and then transformed
into a \link[spatstat.geom:owin.object]{spatstat.geom::owin.object}.
The \code{alpha} parameter determines the smallest size of zones excluded from the window.
If it is not specified, a first attempt is 1/256 of the diameter of the existing window of \code{X}.
If the shape cannot be calculated, \code{alpha} is doubled and a new attempt is made.
}
\examples{
# Simulate a point pattern
if (require(spatstat.random)) {
  X <- rpoispp(50)
  plot(X)
  # Calculate its border
  X$window <- alphahull(X)
  plot(X)
}
}
\seealso{
\link[spatstat.geom:convexhull]{spatstat.geom::convexhull}
}
