% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/door_summary.R
\name{door_summary}
\alias{door_summary}
\title{Summarize individual level data into summary level data}
\usage{
door_summary(
  data,
  trtVar,
  doorVar,
  trtCodes,
  trtLabels = NULL,
  compVars = NULL,
  decreasing = FALSE
)
}
\arguments{
\item{data}{Data frame that includes DOOR outcome variable and
treatment variable at individual level}

\item{trtVar}{Variable name of treatments}

\item{doorVar}{Variable name of DOOR outcome; the doorVar should be numeric}

\item{trtCodes}{A numeric vector contains the codes for interventions in \code{trtVar}, ordered by \code{c(trt, ctr)}}

\item{trtLabels}{An optional vector contains the intervention labels for \code{trtCodes}, ordered by \code{c(trt, ctr)}}

\item{compVars}{An optional character vector of variable names of DOOR components}

\item{decreasing}{A logical value indicating the order of desirability of the DOOR levels. By default,
smaller value represents better outcomes}
}
\value{
An object of DOOR outcome distribution summary
}
\description{
Transform an individual level dataset that contains DOOR outcome variable and
treatment/intervention variable to summary level. By default, the levels of
the DOOR outcome is ordered from 1 to K.
}
\examples{
data(mock_raw_data)
door_summary(data = mock_raw_data,
             trtVar = "ARM",
             doorVar = "DOOR",
             trtCodes = c(1,2),
             trtLabels = c("Test, Control"),
             compVars = c("infectious complications", "clinical failure", "death"))

}
