% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select-rd.R, R/select.R
\name{select.duckplyr_df}
\alias{select.duckplyr_df}
\title{Keep or drop columns using their names and types}
\usage{
\method{select}{duckplyr_df}(.data, ...)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{...}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> One or more unquoted
expressions separated by commas. Variable names can be used as if they
were positions in the data frame, so expressions like \code{x:y} can
be used to select a range of variables.}
}
\description{
This is a method for the \code{\link[dplyr:select]{dplyr::select()}} generic.
See "Fallbacks" section for differences in implementation.
Select (and optionally rename) variables in a data frame,
using a concise mini-language that makes it easy to refer to variables
based on their name (e.g. \code{a:f} selects all columns from a on the left
to f on the right) or type
(e.g. \code{where(is.numeric)} selects all numeric columns).
}
\section{Fallbacks}{

There is no DuckDB translation in \code{select.duckplyr_df()}
\itemize{
\item with no expression,
\item nor with a selection that returns no columns.
}

These features fall back to \code{\link[dplyr:select]{dplyr::select()}}, see \code{vignette("fallback")} for details.
}

\examples{
library(duckplyr)
select(mtcars, mpg)
}
\seealso{
\code{\link[dplyr:select]{dplyr::select()}}
}
