% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symdiff-rd.R, R/symdiff.R
\name{symdiff.duckplyr_df}
\alias{symdiff.duckplyr_df}
\title{Symmetric difference}
\usage{
\method{symdiff}{duckplyr_df}(x, y, ...)
}
\arguments{
\item{x, y}{Pair of compatible data frames. A pair of data frames is
compatible if they have the same column names (possibly in different
orders) and compatible types.}

\item{...}{These dots are for future extensions and must be empty.}
}
\description{
This is a method for the \code{\link[dplyr:setops]{dplyr::symdiff()}} generic.
See "Fallbacks" section for differences in implementation.
\code{symdiff(x, y)}  computes the symmetric difference,
i.e. all rows in \code{x} that aren't in \code{y} and all rows in \code{y} that aren't in \code{x}.
}
\section{Fallbacks}{

There is no DuckDB translation in \code{symdiff.duckplyr_df()}
\itemize{
\item if column names are duplicated in one of the tables,
\item if column names are different in both tables.
}

These features fall back to \code{\link[dplyr:setops]{dplyr::symdiff()}}, see \code{vignette("fallback")} for details.
}

\examples{
df1 <- duckdb_tibble(x = 1:3)
df2 <- duckdb_tibble(x = 3:5)
symdiff(df1, df2)
}
\seealso{
\code{\link[dplyr:setops]{dplyr::symdiff()}}
}
