% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebnm_methods.R
\name{quantile.ebnm}
\alias{quantile.ebnm}
\title{Obtain posterior quantiles using a fitted EBNM model}
\usage{
\method{quantile}{ebnm}(
  x,
  probs = seq(0, 1, 0.25),
  names = TRUE,
  type = 7,
  digits = 7,
  nsim = 1000,
  ...
)
}
\arguments{
\item{x}{The fitted \code{ebnm} object.}

\item{probs}{numeric vector of probabilities with values in
    \eqn{[0,1]}.  (Values up to \samp{2e-14} outside that
    range are accepted and moved to the nearby endpoint.)}

\item{names}{logical; if true, the result has a \code{\link{names}}
    attribute.  Set to \code{FALSE} for speedup with many \code{probs}.}

\item{type}{An integer between 1 and 9 selecting one of the nine quantile
algorithms detailed in \code{\link[stats]{quantile}} to be used.}

\item{digits}{used only when \code{names} is true: the precision to use
    when formatting the percentages.  In \R versions up to 4.0.x, this had
    been set to \code{max(2, getOption("digits"))}, internally.}

\item{nsim}{The number of samples to use to estimate quantiles.}

\item{...}{Additional arguments to be passed to the posterior sampler
function. Since \code{ebnm_horseshoe} returns an MCMC sampler, it takes
parameter \code{burn}, the number of burn-in samples to discard.  At
present, no other samplers take any additional parameters.}
}
\value{
A matrix with columns giving quantiles for each posterior
  \eqn{\theta_i \mid x_i, s_i, g}.
}
\description{
The \code{\link[stats]{quantile}} method for class \code{\link{ebnm}}.
  Quantiles for posterior distributions \eqn{\theta_i \mid x_i, s_i, g} are
  estimated via sampling. By default, \code{\link{ebnm}} does not return a
  posterior sampler; one can be added to the \code{ebnm} object using
  function \code{\link{ebnm_add_sampler}}.
}
