% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha_div.r
\name{adiv_functions}
\alias{adiv_functions}
\alias{ace}
\alias{berger}
\alias{brillouin}
\alias{chao1}
\alias{faith}
\alias{fisher}
\alias{inv_simpson}
\alias{margalef}
\alias{mcintosh}
\alias{menhinick}
\alias{observed}
\alias{shannon}
\alias{simpson}
\alias{squares}
\title{Alpha Diversity Metrics}
\usage{
ace(counts, cutoff = 10, cpus = n_cpus())

berger(counts, norm = "percent", cpus = n_cpus())

brillouin(counts, cpus = n_cpus())

chao1(counts, cpus = n_cpus())

faith(counts, tree = NULL, cpus = n_cpus())

fisher(counts, digits = 3L, cpus = n_cpus())

inv_simpson(counts, norm = "percent", cpus = n_cpus())

margalef(counts, cpus = n_cpus())

mcintosh(counts, cpus = n_cpus())

menhinick(counts, cpus = n_cpus())

observed(counts, cpus = n_cpus())

shannon(counts, norm = "percent", cpus = n_cpus())

simpson(counts, norm = "percent", cpus = n_cpus())

squares(counts, cpus = n_cpus())
}
\arguments{
\item{counts}{A numeric matrix of count data where each column is a
feature, and each row is a sample. Any object coercible with
\code{as.matrix()} can be given here, as well as \code{phyloseq}, \code{rbiom},
\code{SummarizedExperiment}, and \code{TreeSummarizedExperiment} objects.}

\item{cutoff}{The maximum number of observations to consider "rare".
Default: \code{10}.}

\item{cpus}{How many parallel processing threads should be used. The
default, \code{n_cpus()}, will use all logical CPU cores.}

\item{norm}{Normalize the incoming counts. Options are:
\describe{
\item{\code{norm = "percent"} - }{ Relative abundance (sample abundances sum to 1). }
\item{\code{norm = "binary"}  - }{ Unweighted presence/absence (each count is either 0 or 1). }
\item{\code{norm = "clr"}     - }{ Centered log ratio. }
\item{\code{norm = "none"}    - }{ No transformation. }
}
Default: \code{'percent'}, which is the expected input for these formulas.}

\item{tree}{A \code{phylo}-class object representing the phylogenetic tree for
the OTUs in \code{counts}. The OTU identifiers given by \code{colnames(counts)}
must be present in \code{tree}. Can be omitted if a tree is embedded with
the \code{counts} object or as \code{attr(counts, 'tree')}.}

\item{digits}{Precision of the returned values, in number of decimal
places. E.g. the default \code{digits=3} could return \code{6.392}.}
}
\value{
A numeric vector.
}
\description{
Alpha Diversity Metrics
}
\section{Formulas}{


Prerequisite: all counts are whole numbers.

Given:
\itemize{
\item \eqn{n} : The number of features (e.g. species, OTUs, ASVs, etc).
\item \eqn{X_i} : Integer count of the \eqn{i}-th feature.
\item \eqn{X_T} : Total of all counts (i.e. sequencing depth). \eqn{X_T = \sum_{i=1}^{n} X_i}
\item \eqn{P_i} : Proportional abundance of the \eqn{i}-th feature. \eqn{P_i = X_i / X_T}
\item \eqn{F_1} : Number of features where \eqn{X_i = 1} (i.e. singletons).
\item \eqn{F_2} : Number of features where \eqn{X_i = 2} (i.e. doubletons).
}\tabular{ll}{
    \tab  \cr
   \strong{Abundance-based Coverage Estimator (ACE)} \if{html}{\out{<br>}} \code{ace()} \tab See below. \cr
   \strong{Berger-Parker Index}                      \if{html}{\out{<br>}} \code{berger()} \tab \eqn{\max(P_i)} \cr
   \strong{Brillouin Index}                          \if{html}{\out{<br>}} \code{brillouin()} \tab \eqn{\displaystyle \frac{\ln{[(\sum_{i = 1}^{n} X_i)!]} - \sum_{i = 1}^{n} \ln{(X_i!)}}{\sum_{i = 1}^{n} X_i}} \cr
   \strong{Chao1}                                    \if{html}{\out{<br>}} \code{chao1()} \tab \eqn{\displaystyle n + \frac{(F_1)^2}{2 F_2}} \cr
   \strong{Faith's Phylogenetic Diversity}           \if{html}{\out{<br>}} \code{faith()} \tab See below. \cr
   \strong{Fisher's Alpha (\eqn{\alpha})}            \if{html}{\out{<br>}} \code{fisher()} \tab \eqn{\displaystyle \frac{n}{\alpha} = \ln{\left(1 + \frac{X_T}{\alpha}\right)}} \if{html}{\out{<br>}} The value of \eqn{\alpha} must be solved for iteratively. \cr
   \strong{Gini-Simpson Index}                       \if{html}{\out{<br>}} \code{simpson()} \tab \eqn{1 - \sum_{i = 1}^{n} P_i^2} \cr
   \strong{Inverse Simpson Index}                    \if{html}{\out{<br>}} \code{inv_simpson()} \tab \eqn{1 / \sum_{i = 1}^{n} P_i^2} \cr
   \strong{Margalef's Richness Index}                \if{html}{\out{<br>}} \code{margalef()} \tab \eqn{\displaystyle \frac{n - 1}{\ln{X_T}}} \cr
   \strong{McIntosh Index}                           \if{html}{\out{<br>}} \code{mcintosh()} \tab \eqn{\displaystyle \frac{X_T - \sqrt{\sum_{i = 1}^{n} (X_i)^2}}{X_T - \sqrt{X_T}}} \cr
   \strong{Menhinick's Richness Index}               \if{html}{\out{<br>}} \code{menhinick()} \tab \eqn{\displaystyle \frac{n}{\sqrt{X_T}}} \cr
   \strong{Observed Features}                        \if{html}{\out{<br>}} \code{observed()} \tab \eqn{n} \cr
   \strong{Shannon Diversity Index}                  \if{html}{\out{<br>}} \code{shannon()} \tab \eqn{-\sum_{i = 1}^{n} P_i \times \ln(P_i)} \cr
   \strong{Squares Richness Estimator}               \if{html}{\out{<br>}} \code{squares()} \tab \eqn{\displaystyle n + \frac{(F_1)^2 \sum_{i=1}^{n} (X_i)^2}{X_T^2 - nF_1}} \cr
}

\subsection{Abundance-based Coverage Estimator (ACE)}{

Given:
\itemize{
\item \eqn{n} : The number of features (e.g. species, OTUs, ASVs, etc).
\item \eqn{r} : Rare cutoff. Features with \eqn{\le r} counts are considered rare.
\item \eqn{X_i} : Integer count of the \eqn{i}-th feature.
\item \eqn{F_i} : Number of features with exactly \eqn{i} counts.
\item \eqn{F_1} : Number of features where \eqn{X_i = 1} (i.e. singletons).
\item \eqn{F_{rare}} : Number of rare features where \eqn{X_i \le r}.
\item \eqn{F_{abund}} : Number of abundant features where \eqn{X_i > r}.
\item \eqn{X_{rare}} : Total counts belonging to rare features.
\item \eqn{C_{ace}} : The sample abundance coverage estimator, defined below.
\item \eqn{\gamma_{ace}^2} : The estimated coefficient of variation, defined below.
\item \eqn{D_{ace}} : Estimated number of features in the sample.
}

\eqn{\displaystyle C_{ace} = 1 - \frac{F_1}{X_{rare}}}

\eqn{\displaystyle \gamma_{ace}^2 = \max\left[\frac{F_{rare} \sum_{i=1}^{r}i(i-1)F_i}{C_{ace}X_{rare}(X_{rare} - 1)} - 1, 0\right]}

\eqn{\displaystyle D_{ace} = F_{abund} + \frac{F_{rare}}{C_{ace}} + \frac{F_1}{C_{ace}}\gamma_{ace}^2 }
}

\subsection{Faith's Phylogenetic Diversity (Faith's PD)}{

Given \eqn{n} branches with lengths \eqn{L} and a sample's abundances
\eqn{A} on each of those branches coded as 1 for present or 0 for absent:

\eqn{\sum_{i = 1}^{n} L_i A_i}
}
}

\examples{
    # Example counts matrix
    t(ex_counts)
    
    ace(ex_counts)
    
    chao1(ex_counts)
    
    squares(ex_counts)
    
}
\concept{adiv_functions}
