% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.sign.R
\name{InitErgmTerm.delesf}
\alias{InitErgmTerm.delesf}
\title{Delayed edgewise shared friends}
\usage{
# binary: delese(d = 1, base = "+", type = "OTP")
}
\arguments{
\item{d}{Integer.
The exact number of shared friends to count for edges in the current network.}

\item{base}{Character indicating which edges in the current network are used as the base:
`"+"` for positive ties or `"-"` for negative ties.}

\item{type}{For directed networks, the definition of shared friends:
\describe{
  \item{"OTP"}{Outgoing two-path (\( i -> k -> j \))}
  \item{"ITP"}{Incoming two-path (\( j -> k -> i \))}
  \item{"RTP"}{Reciprocated two-path (\( i <- k <- j \))}
  \item{"OSP"}{Outgoing shared partner (\( i -> k, j -> k \))}
  \item{"ISP"}{Incoming shared partner (\( k -> i, k -> j \))}
}
Ignored for undirected networks.}
}
\description{
This term adds one network statistic to the model that counts the number of
positive or negative edges in the current network whose endpoints had exactly
`d` shared friends (common positive ties) in the previous network.

For directed networks, different definitions of shared friends can be specified
using the `type` argument. For undirected networks, only one configuration applies.
}
\details{
For each edge in the current network (positive or negative, depending on `base`),
this term checks how many nodes were connected positively to both endpoints
in the previous network.
}
\concept{delayed}
