% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R
\name{b2dsp-ergmTerm}
\alias{b2dsp-ergmTerm}
\alias{InitErgmTerm.b2dsp}
\title{Dyadwise shared partners for dyads in the second bipartition}
\usage{
# binary: b2dsp(d)
}
\arguments{
\item{d}{a vector of distinct integers}
}
\description{
This term adds one network statistic to the model for each element in \code{d} ; the \eqn{i} th
such statistic equals the number of dyads in the second bipartition with exactly
\code{d[i]} shared partners. (Those shared partners, of course, must be members
of the first bipartition.) This term can only be used with bipartite networks.
}
\note{
This term takes an additional term option (see
\code{\link[=ergm-options]{options?ergm}}), \code{cache.sp}, controlling whether
the implementation will cache the number of shared partners for
each dyad in the network; this is usually enabled by default.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "b2dsp", "subsection")}
}
\concept{bipartite}
\concept{undirected}
