% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nparam.R
\name{nparam}
\alias{nparam}
\alias{nparam.default}
\alias{nparam.ergm}
\title{Length of the parameter vector associated with an object or with its terms.}
\usage{
nparam(object, ...)

\method{nparam}{default}(object, ...)

\method{nparam}{ergm}(object, offset = NA, ...)
}
\arguments{
\item{object}{An object for which number of parameters is defined.}

\item{...}{Additional arguments to methods.}

\item{offset}{If \code{NA} (the default), all model terms are counted;
if \code{TRUE}, only offset terms are counted; and if
\code{FALSE}, offset terms are skipped.}
}
\description{
This is a generic that returns the number of parameters associated with a model or a model fit.
}
\section{Methods (by class)}{
\itemize{
\item \code{nparam(default)}: By default, the length of the \code{\link[=coef]{coef()}} vector is returned.

\item \code{nparam(ergm)}: A method to return the number of parameters of an \code{\link{ergm}} fit.

}}
