% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm.stepping.R
\name{shrink_into_CH}
\alias{shrink_into_CH}
\title{Identify the position of a point relative to the  convex hull of a set of points}
\usage{
shrink_into_CH(
  p,
  M,
  m = NULL,
  verbose = FALSE,
  max_run = nrow(M),
  ...,
  solver = c("glpk", "lpsolve")
)
}
\arguments{
\item{p}{a \eqn{d}-dimensional vector or a matrix with \eqn{d}
columns.}

\item{M}{an \eqn{n} by \eqn{d} matrix.  Each row of \code{M} is a
\eqn{d}-dimensional vector.}

\item{m}{a \eqn{d}-dimensional vector specifying the value towards
which to shrink; must be in the interior of the convex hull of
\eqn{M}, and defaults to its centroid (column means).}

\item{verbose}{A logical or an integer to control the amount of
progress and diagnostic information to be printed. \code{FALSE}/\code{0}
produces minimal output, with higher values producing more
detail. Note that very high values (5+) may significantly slow
down processing.}

\item{max_run}{if there are no decreases in step length in this
many consecutive test points, conclude that diminishing returns
have been reached and finish.}

\item{\dots}{arguments passed directly to linear program solver.}

\item{solver}{a character string selecting which solver to use; by
default, tries \code{Rglpk}'s but falls back to \code{lpSolveAPI}'s.}
}
\value{
The scaling factor described above is
returned. \code{shrink_into_CH() >= 1} indicates that all points in
\code{p} are in the convex hull of \code{M}.
}
\description{
This function uses linear programming to find the value by which
vector \code{p} needs to be scaled towards or away from vector \code{m} in
order for \code{p} to be on the boundary of the convex hull of rows of
\code{M}. If \code{p} is a matrix, a value that scales all rows of \code{p} into
the convex hull of \code{M} is found.
}
\note{
This is a successor to the deprecated function \code{is.inCH()},
which was originally written for the "stepping" algorithm of
\insertCite{HuHu12i;textual}{ergm}. See the updated of
\insertCite{KrKu23l;textual}{ergm} for detailed discussion of algorithms
used in \code{is.inCH()} and \code{shrink_into_CH()}.
}
\references{
\insertAllCited{}

\url{https://www.cs.mcgill.ca/~fukuda/soft/polyfaq/node22.html}
}
\keyword{internal}
