% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ernm.R
\name{simulateStatistics}
\alias{simulateStatistics}
\title{Simulate statistics}
\usage{
simulateStatistics(
  formula,
  theta,
  nodeSamplingPercentage = 0.2,
  mcmcBurnIn = 10000,
  mcmcInterval = 100,
  mcmcSampleSize = 100,
  ignoreMnar = TRUE,
  modelArgs = list(modelClass = "Model"),
  ...
)
}
\arguments{
\item{formula}{the model formula (see \code{\link{ernm-formula}})}

\item{theta}{model parameters}

\item{nodeSamplingPercentage}{how often the nodes should be toggled}

\item{mcmcBurnIn}{burn in}

\item{mcmcInterval}{interval}

\item{mcmcSampleSize}{sample size}

\item{ignoreMnar}{ignore missing not at random offsets}

\item{modelArgs}{additional arguments for the model, e.g. tapering parameters}

\item{...}{additional arguments to createCppSampler}
}
\value{
a matrix of statistics
}
\description{
Generates a MCMC chain for an ernm model and returns the sample statistics
}
\examples{
\dontrun{
edge_list <- matrix(numeric(),ncol=2)
net <- new(UndirectedNet,edge_list,5)
net[["group"]] <- c("a","b","a","b","a")

# generate sample statistics from a simple ernm model with positive homophily
stats <- simulateStatistics(net ~ edges() + nodeCount("group") + homophily("group") | group,
  theta = c(0,0,2),
  mcmcBurnIn=10)
colMeans(stats)
}
}
