% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patient_sample.R
\name{PatientSample}
\alias{PatientSample}
\title{A sample of patients to use in simulations.}
\description{
Class to house the latent random variables that govern toxicity and efficacy
events in patients. Instances of this class can be used in simulation-like
tasks to effectively use the same simulated individuals in different designs,
thus supporting reduced Monte Carlo error and more efficient comparison.
}
\references{
Sweeting, M., Slade, D., Jackson, D., & Brock, K. (2024).
Potential outcome simulation for efficient head-to-head comparison of
adaptive dose-finding designs. arXiv preprint arXiv:2402.15460
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{num_patients}}{(`integer(1)`)\cr}

\item{\code{tox_u}}{(`numeric(num_patients)`)\cr}

\item{\code{time_to_tox_func}}{(`function`)\cr}

\item{\code{tox_time}}{(`numeric(num_patients)`)\cr}

\item{\code{eff_u}}{(`numeric(num_patients)`)\cr}

\item{\code{time_to_eff_func}}{(`function`)\cr}

\item{\code{eff_time}}{(`numeric(num_patients)`)\cr}

\item{\code{can_grow}}{(`logical(1)`)\cr}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PatientSample-new}{\code{PatientSample$new()}}
\item \href{#method-PatientSample-set_eff_and_tox}{\code{PatientSample$set_eff_and_tox()}}
\item \href{#method-PatientSample-expand_to}{\code{PatientSample$expand_to()}}
\item \href{#method-PatientSample-get_tox_u}{\code{PatientSample$get_tox_u()}}
\item \href{#method-PatientSample-get_patient_tox}{\code{PatientSample$get_patient_tox()}}
\item \href{#method-PatientSample-get_eff_u}{\code{PatientSample$get_eff_u()}}
\item \href{#method-PatientSample-get_patient_eff}{\code{PatientSample$get_patient_eff()}}
\item \href{#method-PatientSample-clone}{\code{PatientSample$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PatientSample-new"></a>}}
\if{latex}{\out{\hypertarget{method-PatientSample-new}{}}}
\subsection{Method \code{new()}}{
Creator.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PatientSample$new(
  num_patients = 0,
  time_to_tox_func = function() runif(n = 1),
  time_to_eff_func = function() runif(n = 1)
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{num_patients}}{(`integer(1)`) Number of patients.}

\item{\code{time_to_tox_func}}{(`function`) function taking no args that returns
a single time of toxicity, given that toxicity occurs.}

\item{\code{time_to_eff_func}}{(`function`) function taking no args that returns
a single time of efficacy, given that efficacy occurs.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[PatientSample].
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PatientSample-set_eff_and_tox"></a>}}
\if{latex}{\out{\hypertarget{method-PatientSample-set_eff_and_tox}{}}}
\subsection{Method \code{set_eff_and_tox()}}{
Set the toxicity and efficacy latent variables that govern occurrence of
toxicity and efficacy events. By default, instances of this class
automatically grow these latent variables to accommodate arbitrarily high
sample sizes. However, when you set these latent variables manually via
this function, you override the ability of the class to self-manage, so
its ability to grow is turned off by setting the internal variable
\code{self$can_grow <- FALSE}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PatientSample$set_eff_and_tox(
  tox_u,
  eff_u,
  tox_time = rep(0, length(tox_u)),
  eff_time = rep(0, length(eff_u))
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tox_u}}{(`numeric()`) Patient-level toxicity propensities.}

\item{\code{eff_u}}{(`numeric()`) Patient-level efficacy propensities.}

\item{\code{tox_time}}{(`numeric()`) Patient-level toxicity times, given that
toxicity occurs.}

\item{\code{eff_time}}{(`numeric()`) Patient-level efficacy times, given that
efficacy occurs.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PatientSample-expand_to"></a>}}
\if{latex}{\out{\hypertarget{method-PatientSample-expand_to}{}}}
\subsection{Method \code{expand_to()}}{
Expand sample to size at least num_patients
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PatientSample$expand_to(num_patients)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{num_patients}}{(`integer(1)`).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PatientSample-get_tox_u"></a>}}
\if{latex}{\out{\hypertarget{method-PatientSample-get_tox_u}{}}}
\subsection{Method \code{get_tox_u()}}{
Get toxicity latent variable for patient i
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PatientSample$get_tox_u(i)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{(`integer(1)`) patient index}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PatientSample-get_patient_tox"></a>}}
\if{latex}{\out{\hypertarget{method-PatientSample-get_patient_tox}{}}}
\subsection{Method \code{get_patient_tox()}}{
Get 0 or 1 event marker for whether toxicity occurred in patient i
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PatientSample$get_patient_tox(i, prob_tox, time = Inf)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{(`integer(1)`) patient index}

\item{\code{prob_tox}}{(`numeric(1)`) probability of toxicity}

\item{\code{time}}{(`numeric(1)`) at time}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PatientSample-get_eff_u"></a>}}
\if{latex}{\out{\hypertarget{method-PatientSample-get_eff_u}{}}}
\subsection{Method \code{get_eff_u()}}{
Get efficacy latent variable for patient i
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PatientSample$get_eff_u(i)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{(`integer(1)`) patient index}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PatientSample-get_patient_eff"></a>}}
\if{latex}{\out{\hypertarget{method-PatientSample-get_patient_eff}{}}}
\subsection{Method \code{get_patient_eff()}}{
Get 0 or 1 event marker for whether efficacy occurred in patient i
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PatientSample$get_patient_eff(i, prob_eff, time = Inf)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{(`integer(1)`) patient index}

\item{\code{prob_eff}}{(`numeric(1)`) probability of efficacy}

\item{\code{time}}{(`numeric(1)`) at time}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PatientSample-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PatientSample-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PatientSample$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
