% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vol_gradient.R
\name{vol.gradient}
\alias{vol.gradient}
\title{Gradient of a volume}
\usage{
vol.gradient(vol, alias = "", description = NULL)
}
\arguments{
\item{vol}{"volume" class object.}

\item{alias}{Character string, \code{$alias} of the created object.}

\item{description}{Character string, describing the created object. If
\code{description = NULL} (default value), it will be set to
\code{paste (vol$object.alias, "gradient")}.}
}
\value{
Returns a "volume" class object (see \link[espadon]{espadon.class}
for class definitions), with the same grid and modality
as \code{vol}, gradient of \code{vol}.
}
\description{
The \code{vol.gradient} function calculates the 3D gradient of a
"volume" class object
}
\examples{
# loading of toy-patient objects (decrease dxyz and increase beam.nb for 
# better result)
step <- 3
pat <- toy.load.patient (modality = c ("ct"), dxyz = rep (step, 3))
CT.gradient <- vol.gradient (pat$ct[[1]])

display.plane (CT.gradient, view.type = "sagi", view.coord = 61, 
               interpolate = FALSE)
}
