% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_cursored_search.R
\name{tidy_cursored_search}
\alias{tidy_cursored_search}
\title{Tidy Cursored Search}
\usage{
tidy_cursored_search(query, max_items = 10000, ...)
}
\arguments{
\item{query}{string with the search term(s)}

\item{max_items}{numeric that indicates max items collected}

\item{...}{params passed to get request, see also `query_search_api()`}
}
\value{
S3 object of type `cursored_search`. Contains a `data.table` with
all the responses transformed to tabular format, the path to the first
request that starts the cursored search, and the corresponding response object
compatible with `httr` methods.
}
\description{
This function is a "runner" of a particular query that consequently makes
API requests until maximum items are reached or all related items have been
collected.
}
\examples{
\dontshow{if (Sys.getenv("EUROPEANA_KEY") != "") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
#set your API key with set_key(api_key = "XXXX")
#query search API up to 3 items
res <- tidy_cursored_search(query = "animal",
                            max_items = 3,
                            theme = "art",
                            media = TRUE)
head(res$data[, 1:3])
}
\dontshow{\}) # examplesIf}
}
