% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearest_arg.R
\name{nearest_arg}
\alias{nearest_arg}
\title{Nearest Candidate Value}
\usage{
nearest_arg(arg, choices, method = "cosine", ...)
}
\arguments{
\item{arg}{character: vector or NULL}

\item{choices}{character: vector of candidate values}

\item{method}{character: method for distance calculation (default: \code{cosine})}

\item{...}{further parameters for \link[stringdist:stringdist]{stringdist::stringdistmatrix}}
}
\value{
For each value in \code{arg} the (first) nearest element of \code{choices}.
}
\description{
It determines the nearest candidate value for each value in \code{arg}.
As a replacement for \verb{[base::match.arg]}, it is more error-tolerant, but detecting a wrong choice can be proven challenging.
}
\examples{
# match.arg("tow.sided", c("two.sided", "less", "greater")) # will fail
nearest_arg("tow.sided", c("two.sided", "less", "greater")) 
nearest_arg(c("two.sided", "less", "greater"), c("two.sided", "less", "greater"))
nearest_arg(c("two", "two", "ded", "ss", "ea"), c("two.sided", "less", "greater"))
}
