% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proptests.R
\name{proptests}
\alias{proptests}
\title{Proportion Tests}
\usage{
proptests(proptest, elem = NULL, hyperloop = NULL)
}
\arguments{
\item{proptest}{proptest: the base result from a valid t-test generated by \code{\link[=proptest_num]{proptest_num()}}}

\item{elem}{character: element to extract (default: \code{NULL})}

\item{hyperloop}{named list: parameter values to run over (default: see above)}
}
\value{
list of \code{proptest} objects is returned
}
\description{
\code{proptests} runs a bunch of modifications of the input parameters of \code{proptest} to generate all possible proportion tests.
See under "Details" the detailed parameter values which are used. Note that not giving the parameter \code{hyperloop} will
results in several hundred tests generated.
Only the distinct tests will be returned, with the first element being \code{proptest}. If only a specific element of a \code{proptests} is of interest,
provide the name of the element in \code{elem}. All \code{proptests} will then be returned where the value of \code{elem} is different.
}
\details{
The default \code{hyperloop} is:

\if{html}{\out{<div class="sourceCode">}}\preformatted{list(x           = c(proptest$x, proptest$n-proptest$x)
     pi0         = c(proptest$pi0, 1-proptest$pi0, proptest$x/proptest$n, 1-proptest$x/proptest$n)
     alpha       = unique(c(proptest$alpha, 0.01, 0.05, 0.1)),
     alternative = c("two.sided", "greater", "less")
   )
}\if{html}{\out{</div>}}
}
\examples{
basetest  <- proptest_num(x=3, n=8, alternative="greater")
# vary the number of observations
hyperloop <- list(pi0 = c(basetest$pi0, 1-basetest$pi0, 
                          basetest$x/basetest$n, 1-basetest$x/basetest$n))
# return all different tests
tts       <- proptests(basetest, hyperloop=hyperloop)
# return all different random sampling functions
proptests(basetest, "X", hyperloop)
}
