% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unit_normalize.R
\name{step_unit_normalize}
\alias{step_unit_normalize}
\alias{tidy.step_unit_normalize}
\title{Perform Unit Normalization}
\usage{
step_unit_normalize(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  norm = c("l2", "l1", "max"),
  columns = NULL,
  skip = FALSE,
  id = rand_id("unit_normalize")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which variables are
affected by the step. See \code{\link[recipes:selections]{recipes::selections()}} for more details.  For the \code{tidy}
method, these are not currently used.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{norm}{Character denoting which type of normalization to perform. Must
be one of \code{"l1"}, \code{"l2"}, or "\code{"max"}.}

\item{columns}{A character string of variable names that will be populated
(eventually) by the \code{terms} argument.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake]{bake()}}? While all operations are baked
when \code{\link[recipes:prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of existing steps (if any). For the \code{tidy} method, a tibble with
columns \code{terms} (the columns that will be affected) and \code{base}.
}
\description{
\code{step_unit_normalize()} creates a \emph{specification} of a recipe step that will
perform unit normalization by scaling individual samples to have unit norm.
}
\examples{
library(recipes)

rec <- recipe(~., data = mtcars) \%>\%
  step_unit_normalize(all_predictors()) \%>\%
  prep()

rec \%>\%
  bake(new_data = NULL)

tidy(rec, 1)
}
