% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-render_report.R
\name{make_prog_summary_plot}
\alias{make_prog_summary_plot}
\title{Create progressive preprocessing summary plot}
\usage{
make_prog_summary_plot(
  pupil_data,
  pupil_steps,
  preview_n = 3,
  plot_params = list(),
  run_id = "run-01",
  cex = 2,
  eye_suffix = NULL
)
}
\arguments{
\item{pupil_data}{A data frame containing pupil time series data with
multiple preprocessing columns (e.g., \code{eyeris$timeseries$block_1})}

\item{pupil_steps}{Character vector of column names containing pupil data
at different preprocessing stages
(e.g., \code{c("pupil_raw", "pupil_deblink", "pupil_detrend")})}

\item{preview_n}{Number of columns for subplot layout. Defaults to \code{3}}

\item{plot_params}{Named list of additional parameters to forward to plotting
functions. Defaults to \code{list()}}

\item{run_id}{Character string identifying the run/block (e.g., "run-01").
Used for plot titles and file naming. Defaults to \code{"run-01"}}

\item{cex}{Character expansion factor for plot elements. Defaults to \code{2.0}}

\item{eye_suffix}{Optional eye suffix for binocular data}
}
\value{
NULL (invisibly). Creates a plot showing progressive preprocessing
effects with multiple layers overlaid on the same time series
}
\description{
Internal function to create a comprehensive visualization showing the
progressive effects of preprocessing steps on pupil data. This plot displays
multiple preprocessing stages overlaid on the same time series, allowing
users to see how each step modifies the pupil signal.
}
\details{
This function creates a two-panel visualization:
\itemize{
\item Top panel: Overlaid time series showing progressive preprocessing
effects with different colors for each step
\item Bottom panel: Legend identifying each preprocessing step
}

The plot excludes z-scored data (columns ending with "_z") and only
includes steps with sufficient valid data points (>100). Each preprocessing
step is displayed with a distinct color, making it easy to see how the
signal changes through the pipeline.
}
\seealso{
\code{\link{plot.eyeris}}
}
\keyword{internal}
