% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline-confounds.R
\name{normalize_gaze_coords}
\alias{normalize_gaze_coords}
\title{Normalize gaze coordinates to screen-relative units}
\usage{
normalize_gaze_coords(pupil_df, screen_width, screen_height)
}
\arguments{
\item{pupil_df}{A data frame containing raw gaze
coordinates (\code{eye_x}, \code{eye_y})}

\item{screen_width}{The screen width in pixels}

\item{screen_height}{The screen height in pixels}
}
\value{
A data frame with added columns:
\itemize{
\item \code{eye_x_norm}: Normalized x coordinate [-1,1]
\item \code{eye_y_norm}: Normalized y coordinate [-1,1]
\item \code{gaze_dist_from_center}: Normalized distance from screen center
}
}
\description{
Transforms raw gaze coordinates (in pixels) to normalized coordinates where:
\itemize{
\item (0,0) represents the center of the screen
\item Coordinates are scaled to [-1,1] range
\item Also calculates the normalized distance from screen center
}
}
\keyword{internal}
