% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accuracy.R
\docType{data}
\name{MDA}
\alias{MDA}
\alias{MDV}
\alias{MDPV}
\alias{directional_accuracy_measures}
\title{Directional accuracy measures}
\format{
An object of class \code{list} of length 3.
}
\usage{
MDA(.resid, .actual, na.rm = TRUE, reward = 1, penalty = 0, ...)

MDV(.resid, .actual, na.rm = TRUE, ...)

MDPV(.resid, .actual, na.rm = TRUE, ...)

directional_accuracy_measures
}
\arguments{
\item{.resid}{A vector of residuals from either the training (model accuracy)
or test (forecast accuracy) data.}

\item{.actual}{A vector of responses matching the fitted values
(for forecast accuracy, \code{new_data} must be provided).}

\item{na.rm}{Remove the missing values before calculating the accuracy measure}

\item{reward, penalty}{The weights given to correct and incorrect predicted
directions.}

\item{...}{Additional arguments for each measure.}
}
\description{
A collection of accuracy measures based on the accuracy of the prediction's
direction (say, increasing or decreasing).
}
\details{
\code{MDA()}: Mean Directional Accuracy
\code{MDV()}: Mean Directional Value
\code{MDPV()}: Mean Directional Percentage Value
}
\references{
Blaskowitz and H. Herwartz (2011) "On economic evaluation of directional forecasts". \emph{International Journal of Forecasting},
\bold{27}(4), 1058-1065.
}
\keyword{datasets}
