# Engines API
#
# Allow clients to fetch Engines Analytics through APIs.
#
# The version of the OpenAPI document: 2
# Contact: analytics.api.support@factset.com
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title DocumentDirectories
#' @description DocumentDirectories Class
#' @format An \code{R6Class} generator object
#' @field documents  list( character ) [optional]
#'
#' @field directories  list( character ) [optional]
#'
#'
#' @importFrom R6 R6Class
#' @importFrom jsonlite fromJSON toJSON
#' @export
DocumentDirectories <- R6::R6Class(
  'DocumentDirectories',
  public = list(
    `documents` = NULL,
    `directories` = NULL,
    initialize = function(`documents`=NULL, `directories`=NULL, ...){
      local.optional.var <- list(...)
      if (!is.null(`documents`)) {
        stopifnot(is.vector(`documents`), length(`documents`) != 0)
        sapply(`documents`, function(x) stopifnot(is.character(x)))
        self$`documents` <- `documents`
      }
      if (!is.null(`directories`)) {
        stopifnot(is.vector(`directories`), length(`directories`) != 0)
        sapply(`directories`, function(x) stopifnot(is.character(x)))
        self$`directories` <- `directories`
      }
    },
    toJSON = function() {
      DocumentDirectoriesObject <- list()
      if (!is.null(self$`documents`)) {
        DocumentDirectoriesObject[['documents']] <-
          self$`documents`
      }
      if (!is.null(self$`directories`)) {
        DocumentDirectoriesObject[['directories']] <-
          self$`directories`
      }

      DocumentDirectoriesObject
    },
    fromJSON = function(DocumentDirectoriesJson) {
      DocumentDirectoriesObject <- jsonlite::fromJSON(DocumentDirectoriesJson)
      if (!is.null(DocumentDirectoriesObject$`documents`)) {
        self$`documents` <- ApiClient$new()$deserializeObj(DocumentDirectoriesObject$`documents`, "array[character]", loadNamespace("factset.analyticsapi.engines"))
      }
      if (!is.null(DocumentDirectoriesObject$`directories`)) {
        self$`directories` <- ApiClient$new()$deserializeObj(DocumentDirectoriesObject$`directories`, "array[character]", loadNamespace("factset.analyticsapi.engines"))
      }
    },
    toJSONString = function() {
      jsoncontent <- c(
        if (!is.null(self$`documents`)) {
        sprintf(
        '"documents":
           [%s]
        ',
        paste(unlist(lapply(self$`documents`, function(x) paste0('"', x, '"'))), collapse=",")
        )},
        if (!is.null(self$`directories`)) {
        sprintf(
        '"directories":
           [%s]
        ',
        paste(unlist(lapply(self$`directories`, function(x) paste0('"', x, '"'))), collapse=",")
        )}
      )
      jsoncontent <- paste(jsoncontent, collapse = ",")
      paste('{', jsoncontent, '}', sep = "")
    },
    fromJSONString = function(DocumentDirectoriesJson) {
      DocumentDirectoriesObject <- jsonlite::fromJSON(DocumentDirectoriesJson)
      self$`documents` <- ApiClient$new()$deserializeObj(DocumentDirectoriesObject$`documents`, "array[character]", loadNamespace("factset.analyticsapi.engines"))
      self$`directories` <- ApiClient$new()$deserializeObj(DocumentDirectoriesObject$`directories`, "array[character]", loadNamespace("factset.analyticsapi.engines"))
      self
    }
  )
)
