% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fairness.R
\name{eval_cond_acc_equality}
\alias{eval_cond_acc_equality}
\title{Examine Conditional Use Accuracy Equality of a Model}
\usage{
eval_cond_acc_equality(
  data,
  outcome,
  group,
  probs,
  cutoff = 0.5,
  confint = TRUE,
  alpha = 0.05,
  bootstraps = 2500,
  digits = 2,
  message = TRUE
)
}
\arguments{
\item{data}{Data frame containing the outcome, predicted outcome, and
sensitive attribute}

\item{outcome}{Name of the outcome variable, it must be binary}

\item{group}{Name of the sensitive attribute}

\item{probs}{Name of the predicted outcome variable}

\item{cutoff}{Threshold for the predicted outcome, default is 0.5}

\item{confint}{Whether to compute 95\% confidence interval, default is TRUE}

\item{alpha}{The 1 - significance level for the confidence interval, default is 0.05}

\item{bootstraps}{Number of bootstrap samples, default is 2500}

\item{digits}{Number of digits to round the results to, default is 2}

\item{message}{Logical; if TRUE (default), prints a textual summary of the
fairness evaluation. Only works if \code{confint} is TRUE.}
}
\value{
A list containing the following elements:
\itemize{
\item PPV_Group1: Positive Predictive Value for the first group
\item PPV_Group2: Positive Predictive Value for the second group
\item PPV_Diff: Difference in Positive Predictive Value
\item NPV_Group1: Negative Predictive Value for the first group
\item NPV_Group2: Negative Predictive Value for the second group
\item NPV_Diff: Difference in Negative Predictive Value
If confidence intervals are computed (\code{confint = TRUE}):
\item PPV_Diff_CI: A vector of length 2 containing the lower and upper bounds
of the 95\% confidence interval for the difference in Positive Predictive
Value
\item NPV_Diff_CI: A vector of length 2 containing the lower and upper bounds
of the 95\% confidence interval for the difference in Negative Predictive
Value
}
}
\description{
This function evaluates \emph{Conditional Use Accuracy Equality}, a fairness criterion
that requires predictive performance to be similar across groups when a model
makes positive or negative predictions.
}
\examples{
\donttest{
library(fairmetrics)
library(dplyr)
library(magrittr)
library(randomForest)
data("mimic_preprocessed")
set.seed(123)
train_data <- mimic_preprocessed \%>\%
  dplyr::filter(dplyr::row_number() <= 700)
# Fit a random forest model
rf_model <- randomForest::randomForest(factor(day_28_flg) ~ ., data = train_data, ntree = 1000)
# Test the model on the remaining data
test_data <- mimic_preprocessed \%>\%
  dplyr::mutate(gender = ifelse(gender_num == 1, "Male", "Female")) \%>\%
  dplyr::filter(dplyr::row_number() > 700)

test_data$pred <- predict(rf_model, newdata = test_data, type = "prob")[, 2]

# Fairness evaluation
# We will use sex as the sensitive attribute and day_28_flg as the outcome.
# We choose threshold = 0.41 so that the overall FPR is around 5\%.

# Evaluate Conditional Use Accuracy Equality
eval_cond_acc_equality(
  data = test_data,
  outcome = "day_28_flg",
  group = "gender",
  probs = "pred",
  cutoff = 0.41
)
}
}
\seealso{
\code{\link{eval_acc_parity}}
}
