% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructor.R
\name{new_score_obj}
\alias{new_score_obj}
\title{Construct a new score object}
\usage{
new_score_obj(
  subclass = c("cat_num", "cat_cat", "num_num", "any"),
  outcome_type = c("numeric", "factor"),
  predictor_type = c("numeric", "factor"),
  case_weights = NULL,
  range = NULL,
  inclusive = NULL,
  fallback_value = NULL,
  score_type = NULL,
  trans = NULL,
  sorts = NULL,
  direction = NULL,
  deterministic = NULL,
  tuning = NULL,
  ties = NULL,
  calculating_fn = NULL,
  label = NULL,
  ...
)
}
\arguments{
\item{subclass}{A character string indicating the type of predictor-outcome combination
the scoring method supports. One of:
\itemize{
\item \code{"cat_num"}
\item \code{"cat_cat"}
\item \code{"num_num"}
\item \code{"any"}
}}

\item{outcome_type}{A character string indicating the outcome type. One of:
\itemize{
\item \code{"numeric"}
\item \code{"factor"}
}}

\item{predictor_type}{A character string indicating the predictor type. One of:
\itemize{
\item \code{"numeric"}
\item \code{"factor"}
}}

\item{case_weights}{A logical value, indicating whether the model accepts
case weights (\code{TRUE}) or not (\code{FALSE}).}

\item{range}{A numeric vector of length two, specifying the minimum and maximum
possible values, respectively.}

\item{inclusive}{A logical vector of length two, indicating whether the lower and
upper bounds of the range are inclusive (\code{TRUE}) or exclusive (\code{FALSE}).}

\item{fallback_value}{A numeric scalar used as a fallback value. Typical values
include:
\itemize{
\item \code{0}
\item \code{1}
\item \code{Inf}
}}

\item{score_type}{A character string indicating the type of scoring metric to compute.
Available options include:
\itemize{
\item ANOVA F-Test: \code{"fstat"}, \code{"pval"}
\item Correlation: \code{"pearson"}, \code{"spearman"}
\item Cross Tabulation: \code{"pval_chisq"}, \code{"pval_fisher"}
\item Random Forest:\code{"imp_rf"}, \code{"imp_rf_conditional"}, \code{"imp_rf_oblique"}
\item Information Gain: \code{"infogain"}, \code{"gainratio"}, \code{"symuncert"}
\item ROC AUC: \code{"roc_auc"}
}}

\item{trans}{Currently not used.}

\item{sorts}{An optional function used to sort the scores. Common options include:
\itemize{
\item \code{identity}
\item \code{abs}
\item \code{function(score) max(score, 1 - score)}
}}

\item{direction}{A character string indicating the optimization direction. One of:
\itemize{
\item \code{"maximize"}
\item \code{"minimize"}
\item \code{"target"}
}}

\item{deterministic}{A logical value, indicating whether the score is
deterministic (\code{TRUE}) or not (\code{FALSE}).}

\item{tuning}{A logical value, indicating whether the model should be tuned
(\code{TRUE}) or not (\code{FALSE}).}

\item{ties}{An optional logical value indicating whether ties in score can occur (\code{TRUE})
or not (\code{FALSE}).}

\item{calculating_fn}{An optional function used to compute the score. A default function
is selected based on the \code{score_type}.}

\item{label}{A named character string that can be used for printing and plotting.}

\item{...}{Currently not used.}
}
\value{
A score object.
}
\description{
Create a new score object that contains associated metadata, such as \code{range},
\code{fallback_value}, \code{score_type}, \code{direction}, and other relevant attributes.
}
\examples{
# Create a score object
new_score_obj()
}
