% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flux_calc.R
\name{flux_calc}
\alias{flux_calc}
\title{Calculates ecosystem gas fluxes}
\usage{
flux_calc(
  slopes_df,
  slope_col,
  f_datetime = f_datetime,
  temp_air_col,
  chamber_volume = deprecated(),
  setup_volume,
  atm_pressure,
  plot_area,
  f_fluxid = f_fluxid,
  conc_unit,
  flux_unit,
  cols_keep = c(),
  cols_ave = c(),
  cols_sum = c(),
  cols_med = c(),
  cols_nest = "none",
  tube_volume = deprecated(),
  temp_air_unit = "celsius",
  f_cut = f_cut,
  keep_arg = "keep",
  cut = TRUE,
  fit_type = c()
)
}
\arguments{
\item{slopes_df}{dataframe of flux slopes}

\item{slope_col}{column containing the slope to calculate the flux}

\item{f_datetime}{column containing the datetime of each gas concentration
measurements in \code{slopes_df}. The first one after cutting will be kept as
datetime of each flux in the output.}

\item{temp_air_col}{column containing the air temperature used
to calculate fluxes. Will be averaged with NA removed.}

\item{chamber_volume}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} see \code{setup_volume}}

\item{setup_volume}{volume of the flux chamber and instrument together in L,
can also be a column in case it is a variable}

\item{atm_pressure}{atmospheric pressure in atm,
can be a constant (numerical) or a variable (column name)}

\item{plot_area}{area of the plot in m^2,
can also be a column in case it is a variable}

\item{f_fluxid}{column containing the flux IDs}

\item{conc_unit}{unit in which the concentration of gas was measured
\code{mmol/mol}, \code{ppm}, \code{ppb}, or \code{ppt}}

\item{flux_unit}{desired units for the calculated fluxes. Has to be of the
form amount/surface/time. Amount can be \code{mol}, \code{mmol}, \code{umol}, \code{nmol} or
\code{pmol}. Time can be \code{d} (day), \code{h} (hour), \code{mn} (minute) or \code{s} (seconds).
Surface can be \code{m2}, \code{dm2} or \code{cm2}.}

\item{cols_keep}{columns to keep from the input to the output.
Those columns need to have unique values for each flux,
as \link[dplyr:distinct]{distinct} is applied.}

\item{cols_ave}{columns with values that should be averaged
for each flux in the output. Note that NA are removed in mean calculation.
Those columns will get the \verb{_ave} suffix in the output.}

\item{cols_sum}{columns with values for which is sum is provided
for each flux in the output. Those columns will get the \verb{_sum} suffix in the
output.}

\item{cols_med}{columns with values for which is median is provided
for each flux in the output. Note that NA are removed in median calculation.
Those columns will get the \verb{_med} suffix in the output.}

\item{cols_nest}{columns to nest in \code{nested_variables} for each flux in the
output. Can be character vector of column names, \code{"none"} (default) selects
none, or \code{"all"} selects all the column except those in \code{cols_keep}.}

\item{tube_volume}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} see \code{setup_volume}}

\item{temp_air_unit}{units in which air temperature was measured.
Has to be either \code{celsius} (default), \code{fahrenheit} or \code{kelvin.}}

\item{f_cut}{column containing cutting information}

\item{keep_arg}{name in \code{f_cut} of data to keep}

\item{cut}{if 'TRUE' (default), the measurements will be cut according to
'f_cut' before calculating fluxes. This has no influence on the flux itself
since the slope is provided from \link[fluxible:flux_fitting]{flux_fitting},
but it will influence the values of the variables in \code{cols_ave}, \code{cols_cum},
and \code{cols_med}.}

\item{fit_type}{(optional) model used in
\link[fluxible:flux_fitting]{flux_fitting}. Will be automatically filled if
\code{slopes_df} was produced using \link[fluxible:flux_fitting]{flux_fitting}.}
}
\value{
a dataframe containing flux IDs, datetime of measurements' starts,
fluxes (\code{f_flux}) in the units defined with \code{flux_unit}, temperature average
for each flux in the same unit as the input (\code{f_temp_ave}), the model used in
\link[fluxible:flux_fitting]{flux_fitting}, any column specified in
\code{cols_keep}, any column specified in \code{cols_ave}, \code{cols_med} or \code{cols_sum}
with their values treated accordingly over the measurement after cuts, and a
column \code{nested_variables} with the variables specified in \code{cols_nest}.
}
\description{
Calculates a flux based on the rate of change
of gas concentration over time
}
\examples{
data(co2_conc)
slopes <- flux_fitting(co2_conc, conc, datetime, fit_type = "exp_zhao18")
flux_calc(slopes,
f_slope,
datetime,
temp_air,
conc_unit = "ppm",
flux_unit = "mmol/m2/h",
setup_volume = 24.575,
atm_pressure = 1,
plot_area = 0.0625)
}
